/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.TripwireDatabase;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class JCiteTask
extends MatchingTask {
    private File srcDir;
    private File destDir = null;
    private File file;
    private Path sourcePath;
    private File projectPath = null;
    private boolean usePRE = true;
    private boolean verbose = false;
    private boolean failOnWarning = false;
    private File tripwireFile = null;
    private File tripwirePath = null;
    private String tripwireNewLine = null;
    private boolean acceptChanges = false;
    private File diffPath = null;
    private String differ = "";

    public final void setSrcDir(File _srcDir) {
        this.srcDir = _srcDir;
    }

    public final void setDestDir(File _destDir) {
        this.destDir = _destDir;
    }

    public final void setFile(File _file) {
        this.file = _file;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public Path createSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcePathRef(Reference r) {
        this.createSourcePath().setRefid(r);
    }

    public File getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(File _projectPath) {
        this.projectPath = _projectPath;
    }

    public void setFailOnWarning(boolean _failOnWarning) {
        this.failOnWarning = _failOnWarning;
    }

    public void setUsePRE(boolean _usePRE) {
        this.usePRE = _usePRE;
    }

    public void setVerbose(boolean _verbose) {
        this.verbose = _verbose;
    }

    public void setTripwireFile(File _tripwireFile) {
        this.tripwireFile = _tripwireFile;
    }

    public void setTripwirePath(File _tripwirePath) {
        this.tripwirePath = _tripwirePath;
    }

    public void setTripwireNewLine(String _tripwireNewLine) {
        this.tripwireNewLine = _tripwireNewLine.replace("\\r", "\r").replace("\\n", "\n");
    }

    public void setAcceptChanges(boolean _acceptChanges) {
        this.acceptChanges = _acceptChanges;
    }

    public void setDiffPath(File _diffPath) {
        this.diffPath = _diffPath;
    }

    public void setDiffer(String _differ) {
        this.differ = _differ;
    }

    public void execute() throws BuildException {
        try {
            String msg;
            String[] files;
            this.validate();
            String[] srcPath = this.sourcePath != null ? this.sourcePath.list() : new String[]{};
            JCite jcite = new JCite(srcPath, this.usePRE, this.verbose);
            if (this.verbose) {
                jcite.printCitelets();
            }
            if (null != this.projectPath) {
                this.log("Project path is " + this.projectPath, 3);
                jcite.setProjectPath(this.projectPath.getPath());
            }
            if (this.tripwireFile != null) {
                this.log("Using tripwires from file " + this.tripwireFile, 3);
                jcite.setTripwires(new TripwireDatabase(this.tripwireFile, false, this.tripwireNewLine));
            } else if (this.tripwirePath != null) {
                this.log("Using tripwires from folder " + this.tripwirePath, 3);
                jcite.setTripwires(new TripwireDatabase(this.tripwirePath, true, this.tripwireNewLine));
            }
            jcite.setAcceptTripUps(this.acceptChanges);
            jcite.setDiffPath(this.diffPath);
            jcite.setDiffer(this.differ);
            jcite.setupTripwires(!this.verbose);
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            for (String fname : files = ds.getIncludedFiles()) {
                try {
                    this.log("Processing " + fname, 3);
                    jcite.process(new File(this.srcDir, fname), new File(this.destDir, fname));
                }
                catch (JCiteError e) {
                    throw new BuildException((Throwable)e);
                }
            }
            jcite.finalizeTripwires(!this.verbose);
            this.log("" + jcite.citationCount() + " citations processed.");
            if (jcite.warningsCount() > 0) {
                msg = "" + jcite.warningsCount() + " warnings encountered.";
                this.log(msg, 1);
                if (this.failOnWarning) {
                    throw new BuildException(msg);
                }
            }
            if (jcite.errorCount() > 0) {
                msg = "" + jcite.errorCount() + " errors encountered.";
                this.log(msg, 0);
                throw new BuildException(msg);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void validate() {
        if (this.file != null) {
            if (this.srcDir != null) {
                throw new BuildException("cannot set srcdir and file simultaneously!");
            }
            this.fileset.setFile(this.file);
            this.srcDir = this.file.getParentFile();
        }
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
    }
}

