/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.JCite;
import ch.arrenbrecht.jcite.java.JavaCitelet;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.io.File;
import java.util.Map;

public class JCiteTaglet
implements Taglet {
    private static final String NAME = ".jcite";
    private final JCite jcite = new JCite();
    private final JavaCitelet citer = new JavaCitelet(this.jcite);

    public static void register(Map tagletMap) {
        JCiteTaglet tag = new JCiteTaglet();
        Taglet t = (Taglet)tagletMap.get(tag.getName());
        if (t != null) {
            tagletMap.remove(tag.getName());
        }
        tagletMap.put(tag.getName(), tag);
    }

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public String toString(Tag[] tags) {
        assert (false) : "toString(Tag[]) is not supported";
        return null;
    }

    public JCiteTaglet() {
        this.jcite.setPRE(true);
        this.jcite.setVerbose("true".equalsIgnoreCase(System.getProperty("jciteverbose")));
        this.addSourcePath(System.getProperty("jcitesourcepath"));
    }

    private void addSourcePath(String _pathList) {
        if (_pathList != null) {
            String[] sourcePaths;
            for (String sourcePath : sourcePaths = _pathList.split(File.pathSeparator)) {
                this.jcite.addSourceFolder(sourcePath);
            }
        }
    }

    public String toString(Tag _tag) {
        try {
            String markup = _tag.text();
            int posOfColon = markup.indexOf(58);
            if (posOfColon < 0) {
                markup = this.getSourceClassNameOf(_tag) + ":" + markup;
            } else if (markup.substring(0, posOfColon - 1).indexOf(46) < 0) {
                markup = this.getSourcePackagePathOf(_tag) + markup;
            }
            return this.citer.format(this.citer.cite(markup));
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (null == msg) {
                msg = e.getClass().getName();
            }
            this.printError(_tag.position(), "JCite: " + msg);
            return "<p><pre style='color:red'>" + msg + "</pre></p>";
        }
    }

    private String getSourceClassNameOf(Tag _tag) {
        ClassDoc classDoc;
        Doc doc = _tag.holder();
        if (doc instanceof ClassDoc) {
            classDoc = (ClassDoc)doc;
        } else if (doc instanceof ProgramElementDoc) {
            ProgramElementDoc eltDoc = (ProgramElementDoc)doc;
            classDoc = eltDoc.containingClass();
        } else {
            this.printError(_tag.position(), "JCite: cannot resolve unqualified citation: " + _tag.text());
            return "";
        }
        return classDoc.qualifiedName();
    }

    private String getSourcePackagePathOf(Tag _tag) {
        String className = this.getSourceClassNameOf(_tag);
        int posOfLastDot = className.lastIndexOf(46);
        if (posOfLastDot >= 0) {
            return className.substring(0, posOfLastDot + 1);
        }
        return "";
    }

    private void printError(SourcePosition _pos, String _text) {
        System.err.append("ERROR: ").append(_text).append(" at ").append(_pos.toString()).println();
        System.exit(1);
    }
}

