/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.Constants;
import ch.arrenbrecht.jcite.JCiteError;
import ch.arrenbrecht.jcite.JCitelet;
import ch.arrenbrecht.jcite.JCiteletProvider;
import ch.arrenbrecht.jcite.TripwireDatabase;
import ch.arrenbrecht.jcite.Util;
import ch.arrenbrecht.jcite.include.IncludeCitelet;
import ch.arrenbrecht.jcite.java.JavaCitelet;
import ch.arrenbrecht.jcite.java.PlainJavaCitelet;
import ch.arrenbrecht.jcite.path.PathCitelet;
import ch.arrenbrecht.jcite.text.PlainTextCitelet;
import ch.arrenbrecht.jcite.text.RawTextCitelet;
import ch.arrenbrecht.jcite.text.TextCitelet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.discovery.tools.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JCite {
    private final Collection<JCitelet> citelets = new ArrayList<JCitelet>();
    private List<String> sourceFolders = new ArrayList<String>();
    private String projectPath = "";
    private boolean pre = false;
    private boolean verbose = false;
    private Collection<String> tripUpCollection = null;
    private TripwireDatabase tripwires = null;
    private boolean acceptTripUps = false;
    private File diffPath = null;
    private String differ = "";
    private File currentSourceFile = null;
    private String currentSourceText = null;
    private String currentCitationPrefix = null;
    private int warningsCount = 0;
    private int errorCount = 0;
    private int citationCount = 0;

    public static void main(String ... _args) {
        try {
            JCite jcite = new JCite();
            jcite.runWith(_args);
            if (jcite.errorCount() > 0) {
                System.err.println();
                System.err.println("" + jcite.errorCount() + " error(s) encountered.");
                System.exit(1);
            }
            if (jcite.warningsCount() > 0) {
                System.err.println();
                System.err.println("" + jcite.warningsCount() + " warning(s) encountered.");
                System.exit(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public JCite() {
        this.registerCitelet(new JavaCitelet(this));
        this.registerCitelet(new PlainJavaCitelet(this));
        this.registerCitelet(new TextCitelet(this));
        this.registerCitelet(new PlainTextCitelet(this));
        this.registerCitelet(new RawTextCitelet(this));
        this.registerCitelet(new PathCitelet(this));
        this.registerCitelet(new IncludeCitelet(this));
        Enumeration providers = Service.providers(JCiteletProvider.class);
        while (providers.hasMoreElements()) {
            JCiteletProvider provider = (JCiteletProvider)providers.nextElement();
            this.registerCitelet(provider.getCitelet(this));
        }
    }

    public JCite(String[] _sourceFolders, boolean _usePRE, boolean _verbose) {
        this();
        this.setPRE(_usePRE);
        this.setVerbose(_verbose);
        for (String sourceFolder : _sourceFolders) {
            this.addSourceFolder(sourceFolder);
        }
    }

    void registerCitelet(JCitelet _citelet) {
        this.citelets.add(_citelet);
    }

    void setTripUpCollection(Collection<String> _tripUps) {
        this.tripUpCollection = _tripUps;
    }

    void runWith(String ... _args) throws IOException, JCiteError {
        ArrayList<File> inputs = new ArrayList<File>(1);
        File output = null;
        boolean quiet = false;
        boolean recurse = false;
        int iArg = -1;
        while (++iArg < _args.length) {
            String arg = _args[iArg];
            if (arg.equalsIgnoreCase("-i") || arg.equalsIgnoreCase("--input")) {
                inputs.add(new File(_args[++iArg]));
                continue;
            }
            if (arg.equalsIgnoreCase("-o") || arg.equalsIgnoreCase("--output")) {
                output = new File(_args[++iArg]);
                continue;
            }
            if (arg.equalsIgnoreCase("-sp") || arg.equalsIgnoreCase("--source-path")) {
                this.addSourceFolder(_args[++iArg]);
                continue;
            }
            if (arg.equalsIgnoreCase("-pp") || arg.equalsIgnoreCase("--project-path")) {
                this.setProjectPath(_args[++iArg]);
                continue;
            }
            if (arg.equalsIgnoreCase("-tw") || arg.equalsIgnoreCase("--tripwire-path")) {
                this.tripwires = new TripwireDatabase(new File(_args[++iArg]), true);
                continue;
            }
            if (arg.equalsIgnoreCase("-twf") || arg.equalsIgnoreCase("--tripwire-file")) {
                this.tripwires = new TripwireDatabase(new File(_args[++iArg]), false);
                continue;
            }
            if (arg.equalsIgnoreCase("-ac") || arg.equalsIgnoreCase("--accept-changes")) {
                this.acceptTripUps = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-dp") || arg.equalsIgnoreCase("--diff-path")) {
                this.diffPath = new File(_args[++iArg]);
                continue;
            }
            if (arg.equalsIgnoreCase("--differ")) {
                this.differ = _args[++iArg];
                continue;
            }
            if (arg.equalsIgnoreCase("-v") || arg.equalsIgnoreCase("--verbose")) {
                this.setVerbose(true);
                continue;
            }
            if (arg.equalsIgnoreCase("-q") || arg.equalsIgnoreCase("--quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-r") || arg.equalsIgnoreCase("--recursive")) {
                recurse = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-license") || arg.equalsIgnoreCase("--license")) {
                System.out.println(Constants.INTRO);
                System.out.println(Constants.LICENSE);
                quiet = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-?") || arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help") || arg.equalsIgnoreCase("--help")) {
                System.out.println(Constants.INTRO);
                System.out.println(Constants.HELP);
                quiet = true;
                continue;
            }
            if (this.argHandledByCitelet(arg)) continue;
            System.out.println(Constants.INTRO);
            System.out.println("Invalid command line option: " + arg);
            System.out.println(Constants.HELP);
            quiet = true;
        }
        if (!quiet) {
            System.out.println(Constants.INTRO);
            this.printCitelets();
        }
        this.setupTripwires(quiet);
        if (0 == inputs.size()) {
            System.out.println("No input specified. Use -i <file>, or -h for help.");
        } else if (null == output) {
            System.out.println("No output specified. Use -o <file>, or -h for help.");
        } else {
            for (File input : inputs) {
                if (!quiet) {
                    System.out.println();
                    System.out.println("Processing " + input.getPath());
                }
                if (this.isPattern(input.getName())) {
                    this.processPattern(input.getParentFile(), input.getName(), output, recurse);
                    continue;
                }
                this.process(input, output);
            }
        }
        this.finalizeTripwires(quiet);
        if (this.citationCount() > 0) {
            System.out.println();
            System.out.println("" + this.citationCount() + " citations processed.");
        }
    }

    public void setupTripwires(boolean quiet) throws IOException {
        if (null != this.tripwires) {
            if (!quiet) {
                System.out.println();
                System.out.println("Loading tripwire data from " + this.tripwires.toString());
            }
            this.tripwires.load();
        }
    }

    public void finalizeTripwires(boolean quiet) throws IOException {
        if (null != this.tripwires && this.errorCount() + this.warningsCount() == 0) {
            if (!quiet) {
                System.out.println();
                System.out.println("Saving tripwire data to " + this.tripwires.toString());
            }
            this.tripwires.save();
        }
    }

    final void printCitelets() {
        for (JCitelet c : this.citelets) {
            System.out.println("Using " + c.getClass().getName());
        }
    }

    private boolean argHandledByCitelet(String _arg) {
        for (JCitelet citelet : this.citelets) {
            if (!citelet.argHandled(_arg)) continue;
            return true;
        }
        return false;
    }

    private boolean isPattern(String _name) {
        return _name.indexOf(42) >= 0 || _name.indexOf(63) >= 0;
    }

    public final boolean isPRE() {
        return this.pre;
    }

    public final void setPRE(boolean _pre) {
        this.pre = _pre;
    }

    final boolean isVerbose() {
        return this.verbose;
    }

    final void setVerbose(boolean _verbose) {
        this.verbose = _verbose;
    }

    public final TripwireDatabase getTripwires() {
        return this.tripwires;
    }

    public final void setTripwires(TripwireDatabase _tripwires) {
        this.tripwires = _tripwires;
    }

    public final boolean getAcceptTripUps() {
        return this.acceptTripUps;
    }

    public final void setAcceptTripUps(boolean _acceptTripUps) {
        this.acceptTripUps = _acceptTripUps;
    }

    public File getDiffPath() {
        return this.diffPath;
    }

    public void setDiffPath(File _diffPath) {
        this.diffPath = _diffPath;
    }

    public void setDiffer(String _differ) {
        this.differ = _differ;
    }

    public final void addSourceFolder(String _sourceFolder) {
        this.sourceFolders.add(_sourceFolder);
    }

    List<String> sourceFolders() {
        return this.sourceFolders;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String _projectPath) {
        this.projectPath = _projectPath;
    }

    public void processPattern(File _inputFolder, String _pattern, File _outputFolder, boolean _recurse) throws IOException, JCiteError {
        Util.iterateFiles(_inputFolder, _pattern, _outputFolder, _recurse, new Util.FileVisitor(){

            public void visit(File _inputFile, File _outputFile) throws IOException, JCiteError {
                if (JCite.this.isVerbose()) {
                    System.out.print("JCite processing ");
                    System.out.println(_inputFile.getPath());
                }
                JCite.this.process(_inputFile, _outputFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File _source, File _target) throws IOException, JCiteError {
        this.currentSourceFile = _source;
        try {
            String source = Util.readStringFrom(_source);
            String target = this.process(source);
            File parentDir = _target.getParentFile();
            if (null != parentDir) {
                parentDir.mkdirs();
            }
            Util.writeStringTo(target, _target);
        }
        finally {
            this.currentSourceFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(String _source) throws JCiteError {
        this.currentSourceText = _source;
        try {
            String result = _source;
            for (JCitelet citelet : this.citelets) {
                this.currentCitationPrefix = citelet.referencePrefix();
                try {
                    result = citelet.process(result);
                }
                finally {
                    this.currentCitationPrefix = null;
                }
            }
            String string = result;
            return string;
        }
        finally {
            this.currentSourceText = null;
        }
    }

    void checkTripwires(String _citation, String _value, int _sourceIndex) throws IOException {
        String value;
        String citation;
        String name;
        if (null != this.tripwires && !this.tripwires.check(name = this.tripwires.sanitizeName(citation = this.currentCitationPrefix + ":" + _citation), value = this.tripwires.sanitizeValue(_value))) {
            if (this.acceptTripUps) {
                this.tripwires.update(name, value);
            } else if (null != this.tripUpCollection) {
                this.tripUpCollection.add(this.tripUpLocation(_sourceIndex));
            } else {
                this.logTripUp(citation, name, value, _sourceIndex);
            }
        }
    }

    void logTripUp(String _citation, String _name, String _value, int _sourceIndex) throws IOException {
        this.warn("Cited text changed in " + this.tripUpLocation(_sourceIndex) + " for " + _citation);
        if (null != this.diffPath) {
            this.diff(this.tripwires.get(_name), _value, this.currentSourceFile.getName() + "_" + _sourceIndex);
        }
    }

    private void diff(String _was, String _is, String _baseName) throws IOException {
        this.diffPath.mkdirs();
        File wasFile = new File(this.diffPath, _baseName + ".was");
        File isFile = new File(this.diffPath, _baseName + ".is");
        Util.writeStringTo(_was, wasFile);
        Util.writeStringTo(_is, isFile);
        if (null != this.differ && !"".equals(this.differ)) {
            try {
                Util.execAndPipeOutputToSystem(this.differ, this.quotedName(wasFile), this.quotedName(isFile));
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private String quotedName(File _file) throws IOException {
        return _file.getCanonicalPath();
    }

    private String tripUpLocation(int _sourceIndex) {
        return this.currentSourceFile.getName() + ":" + this.indexToLineNumber(_sourceIndex, this.currentSourceText);
    }

    void logCitationError(Exception _e, String _markup, int _sourceIndex) {
        StringBuilder msg;
        String errMsg = _e.getMessage();
        StringBuilder stringBuilder = msg = null == errMsg ? new StringBuilder(_e.getClass().getName()) : new StringBuilder(errMsg);
        if (null != this.currentSourceFile) {
            msg.append(" In file ").append(this.currentSourceFile.getPath());
            msg.append(':').append(this.indexToLineNumber(_sourceIndex, this.currentSourceText));
        }
        this.error(msg.toString());
    }

    private int indexToLineNumber(int _index, String _text) {
        int index = Math.min(_index, _text.length() - 1);
        int result = 1;
        for (int i = 0; i <= index; ++i) {
            switch (_text.charAt(i)) {
                case '\n': {
                    ++result;
                }
            }
        }
        return result;
    }

    public void warn(String _message) {
        System.err.print("WARNING: ");
        System.err.println(_message);
        ++this.warningsCount;
    }

    public int warningsCount() {
        return this.warningsCount;
    }

    public void error(String _message) {
        System.err.print("ERROR: ");
        System.err.println(_message);
        ++this.errorCount;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void logCitation(String _markup, int _sourceIndex) {
        ++this.citationCount;
    }

    public int citationCount() {
        return this.citationCount;
    }
}

