/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.jcite;

import ch.arrenbrecht.jcite.FragmentLocator;
import ch.arrenbrecht.jcite.UnclosedMarkupError;
import ch.arrenbrecht.jcite.Util;

public abstract class FragmentMarker {
    private final String prefix;
    private final String suffix;

    public FragmentMarker(String _prefix, String _suffix) {
        this.prefix = _prefix;
        this.suffix = _suffix;
    }

    public FragmentMarker(String _prefixAndSuffix) {
        this(_prefixAndSuffix, _prefixAndSuffix);
    }

    public static boolean findFragment(String _in, int _startingAt, FragmentMarker[] _markers, FragmentLocator _locator) throws UnclosedMarkupError {
        for (FragmentMarker marker : _markers) {
            if (!marker.find(_in, _startingAt, _locator)) continue;
            return true;
        }
        return false;
    }

    public final boolean find(String _in, int _startingAt, FragmentLocator _locator) throws UnclosedMarkupError {
        int beginPrefix = _in.indexOf(this.prefix, _startingAt);
        if (beginPrefix >= 0) {
            _locator.beginPrefix = beginPrefix;
            _locator.beginFragment = beginPrefix + this.prefix.length();
            int beginSuffix = _in.indexOf(this.suffix, _locator.beginFragment);
            if (beginSuffix < 0) {
                throw new UnclosedMarkupError(this.getClass().getSimpleName() + " can't find '" + this.suffix + "' in (position=" + _locator.beginFragment + "):\n" + _in.substring(_locator.beginFragment));
            }
            _locator.endFragment = beginSuffix;
            this.adjustFragment(_in, _locator);
            _locator.endSuffix = beginSuffix + this.suffix.length();
            _locator.marker = this;
            return true;
        }
        return false;
    }

    protected void adjustFragment(String _in, FragmentLocator _locator) {
        _locator.endFragment = Util.scanBackTo(_in, '\n', _locator.endFragment) + 1;
    }
}

