/*
 * Decompiled with CFR 0.152.
 */
package ch.arrenbrecht.describable;

public class DescriptionBuilder {
    private final StringBuilder builder = new StringBuilder();
    private final String indent;
    private final int indentLength;
    private StringBuilder indentation = new StringBuilder();
    private boolean indentPending = true;

    public DescriptionBuilder() {
        this("\t");
    }

    public DescriptionBuilder(String _indent) {
        this.indent = _indent;
        this.indentLength = _indent.length();
    }

    public StringBuilder getIndentation() {
        return this.indentation;
    }

    public void indent() {
        this.indentation.append(this.indent);
    }

    public void outdent() {
        int l = this.indentation.length();
        if (this.indentLength <= l) {
            this.indentation.setLength(l - this.indentLength);
        }
    }

    public void newLine() {
        this.builder.append('\n');
        this.indentPending = true;
    }

    private void addIndentationIfPending() {
        if (this.indentPending) {
            this.addIndentation();
        }
    }

    private void addIndentation() {
        this.builder.append((CharSequence)this.indentation);
        this.indentPending = false;
    }

    public String toString() {
        return this.builder.toString();
    }

    public void appendLine(String _string) {
        this.append(_string);
        this.newLine();
    }

    public DescriptionBuilder append(boolean _b) {
        this.addIndentationIfPending();
        this.builder.append(_b);
        return this;
    }

    public DescriptionBuilder append(char _c) {
        this.addIndentationIfPending();
        this.builder.append(_c);
        return this;
    }

    public DescriptionBuilder append(char[] _str, int _offset, int _len) {
        this.addIndentationIfPending();
        this.builder.append(_str, _offset, _len);
        return this;
    }

    public DescriptionBuilder append(char[] _str) {
        this.addIndentationIfPending();
        this.builder.append(_str);
        return this;
    }

    public DescriptionBuilder append(CharSequence _s, int _start, int _end) {
        this.addIndentationIfPending();
        this.builder.append(_s, _start, _end);
        return this;
    }

    public DescriptionBuilder append(CharSequence _s) {
        this.addIndentationIfPending();
        this.builder.append(_s);
        return this;
    }

    public DescriptionBuilder append(double _d) {
        this.addIndentationIfPending();
        this.builder.append(_d);
        return this;
    }

    public DescriptionBuilder append(float _f) {
        this.addIndentationIfPending();
        this.builder.append(_f);
        return this;
    }

    public DescriptionBuilder append(int _i) {
        this.addIndentationIfPending();
        this.builder.append(_i);
        return this;
    }

    public DescriptionBuilder append(long _lng) {
        this.addIndentationIfPending();
        this.builder.append(_lng);
        return this;
    }

    public DescriptionBuilder append(Object _obj) {
        this.addIndentationIfPending();
        this.builder.append(_obj);
        return this;
    }

    public DescriptionBuilder append(String _str) {
        this.addIndentationIfPending();
        this.builder.append(_str);
        return this;
    }

    public DescriptionBuilder append(StringBuffer _sb) {
        this.addIndentationIfPending();
        this.builder.append(_sb);
        return this;
    }

    public void ensureCapacity(int _minimumCapacity) {
        this.builder.ensureCapacity(_minimumCapacity);
    }

    public int length() {
        return this.builder.length();
    }
}

