/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.Message;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.bind.CredentialsBinder;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationViaFormAction {
    public static final String SUCCESS = "success";
    public static final String SUCCESS_WITH_WARNINGS = "successWithWarnings";
    public static final String WARN = "warn";
    public static final String AUTHENTICATION_FAILURE = "authenticationFailure";
    public static final String ERROR = "error";
    private CredentialsBinder credentialsBinder;
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private CookieGenerator warnCookieGenerator;
    private boolean hasWarningMessages;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public final void doBind(RequestContext context, Credential credential) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        if (this.credentialsBinder != null && this.credentialsBinder.supports(credential.getClass())) {
            this.credentialsBinder.bind(request, credential);
        }
    }

    public final Event submit(RequestContext context, Credential credential, MessageContext messageContext) throws Exception {
        String providedLoginTicket;
        String authoritativeLoginTicket = WebUtils.getLoginTicketFromFlowScope(context);
        if (!authoritativeLoginTicket.equals(providedLoginTicket = WebUtils.getLoginTicketFromRequest(context))) {
            this.logger.warn("Invalid login ticket {}", (Object)providedLoginTicket);
            messageContext.addMessage(new MessageBuilder().code("error.invalid.loginticket").build());
            return this.newEvent(ERROR);
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
        WebApplicationService service = WebUtils.getService(context);
        if (StringUtils.hasText((String)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null) {
            try {
                String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credential);
                WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                this.putWarnCookieIfRequestParameterPresent(context);
                return this.newEvent(WARN);
            }
            catch (AuthenticationException e) {
                return this.newEvent(AUTHENTICATION_FAILURE, e);
            }
            catch (TicketCreationException e) {
                this.logger.warn("Invalid attempt to access service using renew=true with different credential. Ending SSO session.");
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
            }
            catch (TicketException e) {
                return this.newEvent(ERROR, e);
            }
        }
        try {
            String tgtId = this.centralAuthenticationService.createTicketGrantingTicket(credential);
            WebUtils.putTicketGrantingTicketInFlowScope(context, tgtId);
            this.putWarnCookieIfRequestParameterPresent(context);
            TicketGrantingTicket tgt = (TicketGrantingTicket)this.ticketRegistry.getTicket(tgtId);
            for (Map.Entry<String, HandlerResult> entry : tgt.getAuthentication().getSuccesses().entrySet()) {
                for (Message message : entry.getValue().getWarnings()) {
                    this.addWarningToContext(messageContext, message);
                }
            }
            if (this.hasWarningMessages) {
                return this.newEvent(SUCCESS_WITH_WARNINGS);
            }
            return this.newEvent(SUCCESS);
        }
        catch (AuthenticationException e) {
            return this.newEvent(AUTHENTICATION_FAILURE, e);
        }
        catch (Exception e) {
            return this.newEvent(ERROR, e);
        }
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse(context);
        if (StringUtils.hasText((String)context.getExternalContext().getRequestParameterMap().get(WARN))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    private AuthenticationException getAuthenticationExceptionAsCause(TicketException e) {
        return (AuthenticationException)e.getCause();
    }

    private Event newEvent(String id) {
        return new Event((Object)this, id);
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap(ERROR, (Object)error));
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public final void setCredentialsBinder(CredentialsBinder credentialsBinder) {
        this.credentialsBinder = credentialsBinder;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    private void addWarningToContext(MessageContext context, Message warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
        this.hasWarningMessages = true;
    }
}

