/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class JpaLockingStrategy
implements LockingStrategy {
    public static final int DEFAULT_LOCK_TIMEOUT = 3600;
    @NotNull
    @PersistenceContext
    protected EntityManager entityManager;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private String applicationId;
    @NotNull
    private String uniqueId;
    private int lockTimeout = 3600;

    public void setApplicationId(String id) {
        this.applicationId = id;
    }

    public void setUniqueId(String id) {
        this.uniqueId = id;
    }

    public void setLockTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Lock timeout must be non-negative.");
        }
        this.lockTimeout = seconds;
    }

    @Override
    @Transactional(readOnly=false)
    public boolean acquire() {
        Lock lock;
        try {
            lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        }
        catch (PersistenceException e) {
            this.logger.debug("{} failed querying for {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            return false;
        }
        boolean result = false;
        if (lock != null) {
            Date expDate = lock.getExpirationDate();
            if (lock.getUniqueId() == null) {
                this.logger.debug("{} trying to acquire {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(this.entityManager, lock);
            } else if (expDate != null && new Date().after(expDate)) {
                this.logger.debug("{} trying to acquire expired {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
                result = this.acquire(this.entityManager, lock);
            }
        } else {
            this.logger.debug("Creating {} lock initially held by {}.", (Object)this.applicationId, (Object)this.uniqueId);
            result = this.acquire(this.entityManager, new Lock());
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public void release() {
        Lock lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId, LockModeType.PESSIMISTIC_WRITE);
        if (lock == null) {
            return;
        }
        String owner = lock.getUniqueId();
        if (!this.uniqueId.equals(owner)) {
            throw new IllegalStateException("Cannot release lock owned by " + owner);
        }
        lock.setUniqueId(null);
        lock.setExpirationDate(null);
        this.logger.debug("Releasing {} lock held by {}.", (Object)this.applicationId, (Object)this.uniqueId);
        this.entityManager.persist((Object)lock);
    }

    @Transactional(readOnly=true)
    public String getOwner() {
        Lock lock = (Lock)this.entityManager.find(Lock.class, (Object)this.applicationId);
        if (lock != null) {
            return lock.getUniqueId();
        }
        return null;
    }

    public String toString() {
        return this.uniqueId;
    }

    private boolean acquire(EntityManager em, Lock lock) {
        lock.setUniqueId(this.uniqueId);
        if (this.lockTimeout > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, this.lockTimeout);
            lock.setExpirationDate(cal.getTime());
        } else {
            lock.setExpirationDate(null);
        }
        boolean success = false;
        try {
            if (lock.getApplicationId() != null) {
                em.merge((Object)lock);
            } else {
                lock.setApplicationId(this.applicationId);
                em.persist((Object)lock);
            }
            success = true;
        }
        catch (PersistenceException e) {
            success = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} could not obtain {} lock.", new Object[]{this.uniqueId, this.applicationId, e});
            }
            this.logger.info("{} could not obtain {} lock.", (Object)this.uniqueId, (Object)this.applicationId);
        }
        return success;
    }

    @Entity
    @Table(name="locks")
    public static class Lock {
        @Id
        @Column(name="application_id")
        private String applicationId;
        @Column(name="unique_id")
        private String uniqueId;
        @Temporal(value=TemporalType.TIMESTAMP)
        @Column(name="expiration_date")
        private Date expirationDate;

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }
    }
}

