/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.ArrayList;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.cas.ticket.registry.support.NoOpLockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private LockingStrategy lock = new NoOpLockingStrategy();
    @NotNull
    private LogoutManager logoutManager;
    private boolean logUserOutOfServices = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        this.logger.info("Beginning ticket cleanup.");
        this.logger.debug("Attempting to acquire ticket cleanup lock.");
        if (!this.lock.acquire()) {
            this.logger.info("Could not obtain lock.  Aborting cleanup.");
            return;
        }
        this.logger.debug("Acquired lock.  Proceeding with cleanup.");
        try {
            ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
            Collection<Ticket> ticketsInCache = this.ticketRegistry.getTickets();
            for (Ticket ticket : ticketsInCache) {
                if (!ticket.isExpired()) continue;
                ticketsToRemove.add(ticket);
            }
            this.logger.info("{} tickets found to be removed.", (Object)ticketsToRemove.size());
            for (Ticket ticket : ticketsToRemove) {
                if (this.logUserOutOfServices && ticket instanceof TicketGrantingTicket) {
                    this.logoutManager.performLogout((TicketGrantingTicket)ticket);
                }
                this.ticketRegistry.deleteTicket(ticket.getId());
            }
        }
        finally {
            this.logger.debug("Releasing ticket cleanup lock.");
            this.lock.release();
        }
        this.logger.info("Finished ticket cleanup.");
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setLock(LockingStrategy strategy) {
        this.lock = strategy;
    }

    public void setLogUserOutOfServices(boolean logUserOutOfServices) {
        this.logUserOutOfServices = logUserOutOfServices;
    }

    public void setLogoutManager(LogoutManager logoutManager) {
        this.logoutManager = logoutManager;
    }
}

