/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractTicketRegistry;
import org.springframework.util.Assert;

public final class DefaultTicketRegistry
extends AbstractTicketRegistry {
    private final Map<String, Ticket> cache;

    public DefaultTicketRegistry() {
        this.cache = new ConcurrentHashMap<String, Ticket>();
    }

    public DefaultTicketRegistry(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.cache = new ConcurrentHashMap<String, Ticket>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        this.logger.debug("Added ticket [{}] to registry.", (Object)ticket.getId());
        this.cache.put(ticket.getId(), ticket);
    }

    @Override
    public Ticket getTicket(String ticketId) {
        if (ticketId == null) {
            return null;
        }
        this.logger.debug("Attempting to retrieve ticket [{}]", (Object)ticketId);
        Ticket ticket = this.cache.get(ticketId);
        if (ticket != null) {
            this.logger.debug("Ticket [{}] found in registry.", (Object)ticketId);
        }
        return ticket;
    }

    @Override
    public boolean deleteTicket(String ticketId) {
        if (ticketId == null) {
            return false;
        }
        this.logger.debug("Removing ticket [{}] from registry", (Object)ticketId);
        return this.cache.remove(ticketId) != null;
    }

    @Override
    public Collection<Ticket> getTickets() {
        return Collections.unmodifiableCollection(this.cache.values());
    }

    @Override
    public int sessionCount() {
        int count = 0;
        for (Ticket t : this.cache.values()) {
            if (!(t instanceof TicketGrantingTicket)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int serviceTicketCount() {
        int count = 0;
        for (Ticket t : this.cache.values()) {
            if (!(t instanceof ServiceTicket)) continue;
            ++count;
        }
        return count;
    }
}

