/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.UniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cas20ProxyHandler
implements ProxyHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PGTIOU_PREFIX = "PGTIOU";
    private static final String PARAMETER_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String PARAMETER_PROXY_GRANTING_TICKET_ID = "pgtId";
    @NotNull
    private UniqueTicketIdGenerator uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    @NotNull
    private HttpClient httpClient;

    @Override
    public String handle(Credential credential, String proxyGrantingTicketId) {
        HttpBasedServiceCredential serviceCredentials = (HttpBasedServiceCredential)credential;
        String proxyIou = this.uniqueTicketIdGenerator.getNewTicketId(PGTIOU_PREFIX);
        String serviceCredentialsAsString = serviceCredentials.getCallbackUrl().toExternalForm();
        int bufferLength = serviceCredentialsAsString.length() + proxyIou.length() + proxyGrantingTicketId.length() + 15;
        StringBuilder stringBuffer = new StringBuilder(bufferLength);
        stringBuffer.append(serviceCredentialsAsString);
        if (serviceCredentials.getCallbackUrl().getQuery() != null) {
            stringBuffer.append("&");
        } else {
            stringBuffer.append("?");
        }
        stringBuffer.append(PARAMETER_PROXY_GRANTING_TICKET_IOU);
        stringBuffer.append("=");
        stringBuffer.append(proxyIou);
        stringBuffer.append("&");
        stringBuffer.append(PARAMETER_PROXY_GRANTING_TICKET_ID);
        stringBuffer.append("=");
        stringBuffer.append(proxyGrantingTicketId);
        if (this.httpClient.isValidEndPoint(stringBuffer.toString())) {
            this.logger.debug("Sent ProxyIou of {} for service: {}", (Object)proxyIou, (Object)serviceCredentials.toString());
            return proxyIou;
        }
        this.logger.debug("Failed to send ProxyIou of {} for service: {}", (Object)proxyIou, (Object)serviceCredentials.toString());
        return null;
    }

    public void setUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.uniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public boolean canHandle(Credential credential) {
        return true;
    }
}

