/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredServiceRegexAttributeFilter
implements RegisteredServiceAttributeFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private Pattern pattern;

    public RegisteredServiceRegexAttributeFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public Map<String, Object> filter(String principalId, Map<String, Object> givenAttributes, RegisteredService registeredService) {
        HashMap<String, Object> attributesToRelease = new HashMap<String, Object>();
        for (String attributeName : givenAttributes.keySet()) {
            Object filteredAttributes;
            Object attributeValue = givenAttributes.get(attributeName);
            this.logger.debug("Received attribute [{}] with value [{}]", (Object)attributeName, attributeValue);
            if (attributeValue == null) continue;
            if (attributeValue instanceof Collection) {
                filteredAttributes = this.filterArrayAttributes(((Collection)attributeValue).toArray(new String[0]), attributeName);
                if (((String[])filteredAttributes).length <= 0) continue;
                attributesToRelease.put(attributeName, filteredAttributes);
                continue;
            }
            if (attributeValue.getClass().isArray()) {
                filteredAttributes = this.filterArrayAttributes((String[])attributeValue, attributeName);
                if (((String[])filteredAttributes).length <= 0) continue;
                attributesToRelease.put(attributeName, filteredAttributes);
                continue;
            }
            if (attributeValue instanceof Map) {
                filteredAttributes = this.filterMapAttributes((Map)attributeValue);
                if (filteredAttributes.size() <= 0) continue;
                attributesToRelease.put(attributeName, filteredAttributes);
                continue;
            }
            if (!this.patternMatchesAttributeValue(attributeValue.toString())) continue;
            this.logReleasedAttributeEntry(attributeName, attributeValue.toString());
            attributesToRelease.put(attributeName, attributeValue);
        }
        this.logger.debug("Received {} attributes. Filtered and released {}", (Object)givenAttributes.size(), (Object)attributesToRelease.size());
        return attributesToRelease;
    }

    private Map<String, String> filterMapAttributes(Map<String, String> valuesToFilter) {
        HashMap<String, String> attributesToFilter = new HashMap<String, String>(valuesToFilter.size());
        for (String attributeName : valuesToFilter.keySet()) {
            String attributeValue = valuesToFilter.get(attributeName);
            if (!this.patternMatchesAttributeValue(attributeValue)) continue;
            this.logReleasedAttributeEntry(attributeName, attributeValue);
            attributesToFilter.put(attributeName, valuesToFilter.get(attributeName));
        }
        return attributesToFilter;
    }

    private boolean patternMatchesAttributeValue(String value) {
        return this.pattern.matcher(value).matches();
    }

    private String[] filterArrayAttributes(String[] valuesToFilter, String attributeName) {
        Vector<String> vector = new Vector<String>(valuesToFilter.length);
        for (String attributeValue : valuesToFilter) {
            if (!this.patternMatchesAttributeValue(attributeValue)) continue;
            this.logReleasedAttributeEntry(attributeName, attributeValue);
            vector.add(attributeValue);
        }
        return vector.toArray(new String[0]);
    }

    private void logReleasedAttributeEntry(String attributeName, String attributeValue) {
        this.logger.debug("The attribute value [{}] for attribute name {} matches the pattern {}. Releasing attribute...", new Object[]{attributeValue, attributeName, this.pattern.pattern()});
    }
}

