/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.HealthStatus;
import org.jasig.cas.monitor.Monitor;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.monitor.StatusCode;

public class HealthCheckMonitor
implements Monitor<HealthStatus> {
    @NotNull
    private Collection<Monitor> monitors = Collections.emptySet();

    public void setMonitors(Collection<Monitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public String getName() {
        return HealthCheckMonitor.class.getSimpleName();
    }

    @Override
    public HealthStatus observe() {
        LinkedHashMap<String, Status> results = new LinkedHashMap<String, Status>(this.monitors.size());
        StatusCode code = StatusCode.UNKNOWN;
        for (Monitor monitor : this.monitors) {
            Object result;
            try {
                result = monitor.observe();
                if (((Status)result).getCode().value() > code.value()) {
                    code = ((Status)result).getCode();
                }
            }
            catch (Exception e) {
                code = StatusCode.ERROR;
                result = new Status(code, e.getClass().getSimpleName() + ": " + e.getMessage());
            }
            results.put(monitor.getName(), (Status)result);
        }
        return new HealthStatus(code, results);
    }
}

