/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.github.inspektr.audit.annotation.Audit;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.AnyAuthenticationPolicy;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationBuilder;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.AuthenticationPolicy;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UnresolvedPrincipalException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PolicyBasedAuthenticationManager
implements AuthenticationManager {
    private static final Principal NULL_PRINCIPAL = new NullPrincipal();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();
    @NotNull
    private AuthenticationPolicy authenticationPolicy = new AnyAuthenticationPolicy();
    @NotNull
    private final Map<AuthenticationHandler, PrincipalResolver> handlerResolverMap;

    public PolicyBasedAuthenticationManager(AuthenticationHandler ... handlers) {
        this(Arrays.asList(handlers));
    }

    public PolicyBasedAuthenticationManager(List<AuthenticationHandler> handlers) {
        Assert.notEmpty(handlers, (String)"At least one authentication handler is required");
        this.handlerResolverMap = new LinkedHashMap<AuthenticationHandler, PrincipalResolver>(handlers.size());
        for (AuthenticationHandler handler : handlers) {
            this.handlerResolverMap.put(handler, null);
        }
    }

    public PolicyBasedAuthenticationManager(Map<AuthenticationHandler, PrincipalResolver> map) {
        Assert.notEmpty(map, (String)"At least one authentication handler is required");
        this.handlerResolverMap = map;
    }

    @Override
    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Profiled(tag="AUTHENTICATE", logFailuresSeparately=false)
    public final Authentication authenticate(Credential ... credentials) throws AuthenticationException {
        AuthenticationBuilder builder = this.authenticateInternal(credentials);
        Authentication authentication = builder.build();
        Principal principal = authentication.getPrincipal();
        if (principal instanceof NullPrincipal) {
            throw new UnresolvedPrincipalException(authentication);
        }
        for (HandlerResult result : authentication.getSuccesses().values()) {
            builder.addAttribute("authenticationMethod", result.getHandlerName());
        }
        this.logger.info("Authenticated {} with credentials {}.", (Object)principal, Arrays.asList(credentials));
        this.logger.debug("Attribute map for {}: {}", (Object)principal.getId(), principal.getAttributes());
        for (AuthenticationMetaDataPopulator populator : this.authenticationMetaDataPopulators) {
            for (Credential credential : credentials) {
                populator.populateAttributes(builder, credential);
            }
        }
        return builder.build();
    }

    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> populators) {
        this.authenticationMetaDataPopulators = populators;
    }

    public void setAuthenticationPolicy(AuthenticationPolicy policy) {
        this.authenticationPolicy = policy;
    }

    protected AuthenticationBuilder authenticateInternal(Credential ... credentials) throws AuthenticationException {
        AuthenticationBuilder builder = new AuthenticationBuilder(NULL_PRINCIPAL);
        for (Credential c : credentials) {
            builder.addCredential(new BasicCredentialMetaData(c));
        }
        for (Credential credential : credentials) {
            boolean found = false;
            for (AuthenticationHandler handler : this.handlerResolverMap.keySet()) {
                if (!handler.supports(credential)) continue;
                found = true;
                try {
                    Principal principal;
                    HandlerResult result = handler.authenticate(credential);
                    builder.addSuccess(handler.getName(), result);
                    this.logger.info("{} successfully authenticated {}", (Object)handler.getName(), (Object)credential);
                    PrincipalResolver resolver = this.handlerResolverMap.get(handler);
                    if (resolver == null) {
                        principal = result.getPrincipal();
                        this.logger.debug("No resolver configured for {}. Falling back to handler principal {}", (Object)handler.getName(), (Object)principal);
                    } else {
                        principal = this.resolvePrincipal(handler.getName(), resolver, credential);
                    }
                    if (principal != null) {
                        builder.setPrincipal(principal);
                    }
                    if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) continue;
                    return builder;
                }
                catch (GeneralSecurityException e) {
                    this.logger.info("{} failed authenticating {}", (Object)handler.getName(), (Object)credential);
                    builder.addFailure(handler.getName(), e.getClass());
                }
                catch (PreventedException e) {
                    builder.addFailure(handler.getName(), e.getClass());
                }
            }
            if (found) continue;
            this.logger.warn("Cannot find authentication handler that supports {}, which suggests a configuration problem.", (Object)credential);
        }
        if (builder.getSuccesses().isEmpty()) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        if (!this.authenticationPolicy.isSatisfiedBy(builder.build())) {
            throw new AuthenticationException(builder.getFailures(), builder.getSuccesses());
        }
        return builder;
    }

    protected Principal resolvePrincipal(String handlerName, PrincipalResolver resolver, Credential credential) {
        if (resolver.supports(credential)) {
            try {
                Principal p = resolver.resolve(credential);
                this.logger.debug("{} resolved {} from {}", new Object[]{resolver, p, credential});
                return p;
            }
            catch (Exception e) {
                this.logger.error("{} failed to resolve principal from {}", new Object[]{resolver, credential, e});
            }
        } else {
            this.logger.warn("{} is configured to use {} but it does not support {}, which suggests a configuration problem.", new Object[]{handlerName, resolver, credential});
        }
        return null;
    }

    private static AuthenticationException createAuthenticationException(Authentication authn) {
        return new AuthenticationException(authn.getFailures(), authn.getSuccesses());
    }

    static class NullPrincipal
    implements Principal {
        private static final String NOBODY = "nobody";

        NullPrincipal() {
        }

        @Override
        public String getId() {
            return NOBODY;
        }

        @Override
        public Map<String, Object> getAttributes() {
            return Collections.emptyMap();
        }
    }
}

