/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.forgerock.http.io.BranchingInputStream;

public final class FileBranchingStream
extends BranchingInputStream {
    private final InputStream input;
    private final File file;
    private long position = 0L;

    public FileBranchingStream(File file) throws FileNotFoundException {
        super(null);
        this.file = file;
        this.input = new BufferedInputStream(new FileInputStream(file));
    }

    private FileBranchingStream(File file, long position, BranchingInputStream parent) throws IOException {
        super(parent);
        this.file = file;
        this.input = new FileInputStream(file);
        long skipBytes = position;
        while (this.position < position) {
            long skipped = this.input.skip(skipBytes);
            this.position += skipped;
            skipBytes -= skipped;
        }
    }

    @Override
    public BranchingInputStream branch() throws IOException {
        return new FileBranchingStream(this.file, this.position, this);
    }

    @Override
    public BranchingInputStream copy() throws IOException {
        return new FileBranchingStream(this.file, this.position, this.parent());
    }

    @Override
    public int read() throws IOException {
        ++this.position;
        return this.input.read();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

