/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class RangeSet
extends AbstractSet<String>
implements Set<String>,
Cloneable,
Serializable {
    static final long serialVersionUID = 1L;
    private int start;
    private int end;

    public RangeSet(int start, int end) {
        this.start = start;
        this.end = end;
        if (start > end) {
            throw new IllegalArgumentException("start must be <= end");
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int cursor;
            {
                this.cursor = RangeSet.this.start;
            }

            @Override
            public boolean hasNext() {
                return this.cursor <= RangeSet.this.end;
            }

            @Override
            public String next() {
                if (this.cursor > RangeSet.this.end) {
                    throw new NoSuchElementException();
                }
                return Integer.toString(this.cursor++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.end - this.start + 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = false;
        if (o != null && o instanceof String) {
            try {
                int n = Integer.parseInt((String)o);
                result = n >= this.start && n <= this.end;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    @Override
    public boolean add(String e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

