/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.util.Reject;

public final class PromptingTrustManager
implements X509TrustManager {
    private static final LocalizedLogger LOG = LocalizedLogger.getLoggerForThisClass();
    private static final String DEFAULT_PATH = System.getProperty("user.home") + File.separator + ".opendj" + File.separator + "keystore";
    private static final char[] DEFAULT_PASSWORD = "OpenDJ".toCharArray();
    private final KeyStore inMemoryTrustStore;
    private final KeyStore onDiskTrustStore;
    private final X509TrustManager inMemoryTrustManager;
    private final X509TrustManager onDiskTrustManager;
    private final X509TrustManager nestedTrustManager;
    private final ConsoleApplication app;

    public PromptingTrustManager(ConsoleApplication app, String acceptedStorePath, X509TrustManager sourceTrustManager) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Reject.ifNull((Object)app, (String)acceptedStorePath);
        this.app = app;
        this.nestedTrustManager = sourceTrustManager;
        this.inMemoryTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.onDiskTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File onDiskTrustStorePath = new File(acceptedStorePath);
        this.inMemoryTrustStore.load(null, null);
        if (!onDiskTrustStorePath.exists()) {
            this.onDiskTrustStore.load(null, null);
        } else {
            try (FileInputStream fos = new FileInputStream(onDiskTrustStorePath);){
                this.onDiskTrustStore.load(fos, DEFAULT_PASSWORD);
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.inMemoryTrustStore);
        X509TrustManager x509tm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            x509tm = (X509TrustManager)tm;
            break;
        }
        if (x509tm == null) {
            throw new NoSuchAlgorithmException();
        }
        this.inMemoryTrustManager = x509tm;
        tmf.init(this.onDiskTrustStore);
        x509tm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            x509tm = (X509TrustManager)tm;
            break;
        }
        if (x509tm == null) {
            throw new NoSuchAlgorithmException();
        }
        this.onDiskTrustManager = x509tm;
    }

    public PromptingTrustManager(ConsoleApplication app, X509TrustManager sourceTrustManager) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this(app, DEFAULT_PATH, sourceTrustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        block7: {
            try {
                this.inMemoryTrustManager.checkClientTrusted(x509Certificates, s);
            }
            catch (Exception ce1) {
                try {
                    this.onDiskTrustManager.checkClientTrusted(x509Certificates, s);
                }
                catch (Exception ce2) {
                    if (this.nestedTrustManager != null) {
                        try {
                            this.nestedTrustManager.checkClientTrusted(x509Certificates, s);
                        }
                        catch (Exception ce3) {
                            this.checkManuallyTrusted(x509Certificates, ce3);
                        }
                        break block7;
                    }
                    this.checkManuallyTrusted(x509Certificates, ce1);
                }
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        block7: {
            try {
                this.inMemoryTrustManager.checkServerTrusted(x509Certificates, s);
            }
            catch (Exception ce1) {
                try {
                    this.onDiskTrustManager.checkServerTrusted(x509Certificates, s);
                }
                catch (Exception ce2) {
                    if (this.nestedTrustManager != null) {
                        try {
                            this.nestedTrustManager.checkServerTrusted(x509Certificates, s);
                        }
                        catch (Exception ce3) {
                            this.checkManuallyTrusted(x509Certificates, ce3);
                        }
                        break block7;
                    }
                    this.checkManuallyTrusted(x509Certificates, ce1);
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.nestedTrustManager != null) {
            return this.nestedTrustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    private void acceptCertificate(X509Certificate[] chain, boolean permanent) {
        if (permanent) {
            LOG.debug(LocalizableMessage.raw((CharSequence)"Permanently accepting certificate chain to truststore", (Object[])new Object[0]));
        } else {
            LOG.debug(LocalizableMessage.raw((CharSequence)"Accepting certificate chain for this session", (Object[])new Object[0]));
        }
        for (X509Certificate aChain : chain) {
            try {
                String alias = aChain.getSubjectDN().getName();
                this.inMemoryTrustStore.setCertificateEntry(alias, aChain);
                if (!permanent) continue;
                this.onDiskTrustStore.setCertificateEntry(alias, aChain);
            }
            catch (Exception e) {
                LOG.warn(LocalizableMessage.raw((CharSequence)("Error setting certificate to store: " + e + "\nCert: " + aChain), (Object[])new Object[0]));
            }
        }
        if (permanent) {
            try {
                File truststoreFile = new File(DEFAULT_PATH);
                if (!truststoreFile.exists()) {
                    this.createFile(truststoreFile);
                }
                try (FileOutputStream fos = new FileOutputStream(truststoreFile);){
                    this.onDiskTrustStore.store(fos, DEFAULT_PASSWORD);
                }
            }
            catch (Exception e) {
                LOG.warn(LocalizableMessage.raw((CharSequence)("Error saving store to disk: " + e), (Object[])new Object[0]));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkManuallyTrusted(X509Certificate[] chain, Exception exception) throws CertificateException {
        this.app.println();
        this.app.println(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_SERVER_CERTIFICATE.get());
        this.app.println();
        for (X509Certificate element : chain) {
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_USER_DN.get((Object)element.getSubjectDN().toString()));
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_VALIDITY.get((Object)element.getNotBefore().toString(), (Object)element.getNotAfter().toString()));
            this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_ISSUER.get((Object)element.getIssuerDN().toString()));
            this.app.println();
            this.app.println();
        }
        this.app.println();
        this.app.println(CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION.get());
        this.app.println();
        menuOptions = new HashMap<String, TrustOption>();
        for (TrustOption t : TrustOption.values()) {
            menuOptions.put(t.getChoice().toString(), t);
            builder = new LocalizableMessageBuilder();
            builder.append((Object)t.getChoice());
            builder.append((CharSequence)") ");
            builder.append(t.getMenuMessage());
            this.app.println(builder.toMessage(), 2);
        }
        defaultTrustMethod = TrustOption.SESSION;
        promptMsg = CliMessages.INFO_MENU_PROMPT_SINGLE.get();
        block11: while (true) {
            this.app.println();
            try {
                choice = this.app.readInput(promptMsg, defaultTrustMethod.getChoice().toString());
            }
            catch (ClientException e) {
                throw new CertificateException(exception);
            }
            finally {
                this.app.println();
            }
            option = (TrustOption)menuOptions.get(choice.trim());
            if (option == null) {
                this.app.println(CliMessages.ERR_MENU_BAD_CHOICE_SINGLE.get());
                this.app.println();
                continue;
            }
            switch (1.$SwitchMap$com$forgerock$opendj$cli$PromptingTrustManager$TrustOption[option.ordinal()]) {
                case 1: {
                    if (exception instanceof CertificateException) {
                        throw (CertificateException)exception;
                    }
                    throw new CertificateException(exception);
                }
                case 2: {
                    var8_13 = chain;
                    var9_14 = var8_13.length;
                    var10_16 = 0;
                    while (true) {
                        if (var10_16 < var9_14) ** break;
                        continue block11;
                        aChain = var8_13[var10_16];
                        this.app.println();
                        this.app.println(CliMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE.get((Object)aChain.toString()));
                        this.app.println();
                        ++var10_16;
                    }
                }
                default: {
                    this.acceptCertificate(chain, option == TrustOption.PERMANENT);
                    return;
                }
            }
            break;
        }
    }

    private boolean createFile(File f) throws IOException {
        boolean success = false;
        if (f != null) {
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            success = f.createNewFile();
        }
        return success;
    }

    private static enum TrustOption {
        UNTRUSTED(1, CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_NO.get()),
        SESSION(2, CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_SESSION.get()),
        PERMANENT(3, CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_ALWAYS.get()),
        CERTIFICATE_DETAILS(4, CliMessages.INFO_LDAP_CONN_PROMPT_SECURITY_CERTIFICATE_DETAILS.get());

        private Integer choice;
        private LocalizableMessage msg;

        private TrustOption(int i, LocalizableMessage msg) {
            this.choice = i;
            this.msg = msg;
        }

        Integer getChoice() {
            return this.choice;
        }

        LocalizableMessage getMenuMessage() {
            return this.msg;
        }
    }
}

