/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.forgerock.util.Reject;

public final class MultiColumnPrinter {
    private static final String SEPARATOR_ID = "separator";
    private static int separatorIdNumber;
    private final PrintStream stream;
    private final List<Column> columns;
    private final boolean format;
    private final Alignment titleAlignment;
    private final String columnSeparator;
    private List<Column> printableColumns;
    private final int lineLength;
    private Iterator<Column> columnIterator;
    private Column currentColumn;

    public static Column separatorColumn() {
        return new Column(SEPARATOR_ID + separatorIdNumber++, "", 1, 0);
    }

    public static Column column(String id, String title, int doublePrecision) {
        return new Column(id, title, 1, doublePrecision);
    }

    public static Column column(String id, String title, int width, int doublePrecision) {
        return new Column(id, title, Math.max(width, title.length()), doublePrecision);
    }

    public static Builder builder(PrintStream stream, List<Column> columns) {
        return new Builder(stream, columns);
    }

    private MultiColumnPrinter(Builder builder) {
        this.stream = builder.stream;
        this.columns = Collections.unmodifiableList(builder.columns);
        this.format = builder.format;
        this.columnSeparator = builder.columnSeparator;
        this.titleAlignment = builder.titleAlignment;
        this.lineLength = this.computeLineLength();
        this.resetIterator();
        this.computePrintableColumns();
    }

    public void printDashedLine() {
        this.startNewLineIfNeeded();
        for (int i = 0; i < this.lineLength; ++i) {
            this.stream.print('-');
        }
        this.stream.println();
    }

    public void printTitleSection(String data, int rowSpan) {
        this.consumeSeparatorColumn();
        int lengthToPad = 0;
        int nbColumnMerged = 0;
        while (this.columnIterator.hasNext() && nbColumnMerged < rowSpan) {
            lengthToPad += this.currentColumn.width + this.columnSeparator.length();
            if (!this.isSeparatorColumn(this.currentColumn)) {
                ++nbColumnMerged;
            }
            this.currentColumn = this.columnIterator.next();
        }
        this.stream.print(this.align(data, this.titleAlignment, lengthToPad));
        this.consumeSeparatorColumn();
        if (!this.columnIterator.hasNext()) {
            this.nextLine();
        }
    }

    public void printTitleLine() {
        this.startNewLineIfNeeded();
        this.passFirstSeparatorColumn();
        for (Column column : this.printableColumns) {
            this.printCell(column.title, Alignment.RIGHT);
        }
    }

    public void printData(Double value) {
        this.passFirstSeparatorColumn();
        this.printData(value.isNaN() ? "-" : String.format(Locale.ENGLISH, "%." + this.currentColumn.doublePrecision + "f", value));
    }

    public void printData(String data) {
        this.passFirstSeparatorColumn();
        this.printCell(data, Alignment.RIGHT);
    }

    public List<Column> getColumns() {
        return this.printableColumns;
    }

    private void printCell(String data, Alignment alignment) {
        String toPrint;
        String string = toPrint = this.format ? this.align(data, alignment, this.currentColumn.width) : data;
        if (this.columnIterator.hasNext()) {
            toPrint = toPrint + this.columnSeparator;
        }
        this.stream.print(toPrint);
        this.nextLineOnEOLOrNextColumn();
    }

    private String align(String data, Alignment alignment, int width) {
        String rawData = data.trim();
        int padding = width - rawData.length();
        if (padding <= 0) {
            return rawData;
        }
        switch (alignment) {
            case RIGHT: {
                return this.pad(padding, rawData, 0);
            }
            case LEFT: {
                return this.pad(0, rawData, padding);
            }
            case CENTER: {
                int paddingBefore = padding / 2;
                return this.pad(paddingBefore, rawData, padding - paddingBefore);
            }
        }
        return "";
    }

    private String pad(int leftPad, String s, int rightPad) {
        return Utils.repeat(' ', leftPad) + s + Utils.repeat(' ', rightPad);
    }

    private void passFirstSeparatorColumn() {
        if (this.cursorOnLineStart()) {
            this.consumeSeparatorColumn();
        }
    }

    private void consumeSeparatorColumn() {
        if (this.isSeparatorColumn(this.currentColumn)) {
            this.stream.print('|' + this.columnSeparator);
            this.nextLineOnEOLOrNextColumn();
        }
    }

    private void startNewLineIfNeeded() {
        if (!this.cursorOnLineStart()) {
            this.nextLine();
        }
    }

    private void nextLineOnEOLOrNextColumn() {
        if (this.columnIterator.hasNext()) {
            this.currentColumn = this.columnIterator.next();
            this.consumeSeparatorColumn();
        } else {
            this.nextLine();
        }
    }

    private void nextLine() {
        this.stream.println();
        this.resetIterator();
    }

    private void resetIterator() {
        this.columnIterator = this.columns.iterator();
        this.currentColumn = this.columnIterator.next();
    }

    private boolean cursorOnLineStart() {
        return this.currentColumn == this.columns.get(0);
    }

    private boolean isSeparatorColumn(Column column) {
        return column.id.startsWith(SEPARATOR_ID);
    }

    private void computePrintableColumns() {
        this.printableColumns = new ArrayList<Column>(this.columns);
        Iterator<Column> it = this.printableColumns.iterator();
        while (it.hasNext()) {
            if (!this.isSeparatorColumn(it.next())) continue;
            it.remove();
        }
    }

    private int computeLineLength() {
        int lineLength = 0;
        int separatorLength = this.columnSeparator.length();
        for (Column column : this.columns) {
            lineLength += column.width + separatorLength;
        }
        return lineLength - separatorLength;
    }

    public static final class Builder {
        private final PrintStream stream;
        private final List<Column> columns;
        private Alignment titleAlignment = Alignment.RIGHT;
        private String columnSeparator = " ";
        private boolean format;

        private Builder(PrintStream stream, List<Column> columns) {
            Reject.ifNull((Object)stream);
            this.stream = stream;
            this.columns = columns;
        }

        public Builder format(boolean format) {
            this.format = format;
            return this;
        }

        public Builder titleAlignment(Alignment titleAlignment) {
            this.titleAlignment = titleAlignment;
            return this;
        }

        public Builder columnSeparator(String separator) {
            this.columnSeparator = separator;
            return this;
        }

        public MultiColumnPrinter build() {
            return new MultiColumnPrinter(this);
        }
    }

    public static final class Column {
        private final String id;
        private final String title;
        private final int width;
        private final int doublePrecision;

        private Column(String id, String title, int width, int doublePrecision) {
            this.id = id;
            this.title = title;
            this.width = Math.max(width, title.length());
            this.doublePrecision = doublePrecision;
        }

        public String getId() {
            return this.id;
        }
    }

    public static enum Alignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

