/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessageBuilder;

public final class FileBasedArgument
extends Argument {
    private final Map<String, String> namesToValues = new LinkedHashMap<String, String>();

    public static Builder builder(String longIdentifier) {
        return new Builder(longIdentifier);
    }

    private FileBasedArgument(Builder builder) throws ArgumentException {
        super(builder);
    }

    @Override
    public void addValue(String valueString) {
        String actualValue = this.namesToValues.get(valueString);
        if (actualValue != null) {
            super.addValue(actualValue);
        }
    }

    public Map<String, String> getNameToValueMap() {
        return this.namesToValues;
    }

    @Override
    public boolean valueIsAcceptable(String valueString, LocalizableMessageBuilder invalidReason) {
        String line;
        File valueFile;
        try {
            valueFile = new File(valueString);
            if (!valueFile.exists()) {
                invalidReason.append(CliMessages.ERR_FILEARG_NO_SUCH_FILE.get((Object)valueString, (Object)this.longIdentifier));
                return false;
            }
        }
        catch (Exception e) {
            invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_VERIFY_FILE_EXISTENCE.get((Object)valueString, (Object)this.longIdentifier, (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return false;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(valueFile));){
            line = reader.readLine();
        }
        catch (FileNotFoundException e) {
            invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_OPEN_FILE.get((Object)valueString, (Object)this.longIdentifier, (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return false;
        }
        catch (IOException e) {
            invalidReason.append(CliMessages.ERR_FILEARG_CANNOT_READ_FILE.get((Object)valueString, (Object)this.longIdentifier, (Object)StaticUtils.getExceptionMessage((Throwable)e)));
            return false;
        }
        if (line == null) {
            invalidReason.append(CliMessages.ERR_FILEARG_EMPTY_FILE.get((Object)valueString, (Object)this.longIdentifier));
            return false;
        }
        this.namesToValues.put(valueString, line);
        return true;
    }

    public static final class Builder
    extends Argument.ArgumentBuilder<Builder, String, FileBasedArgument> {
        private Builder(String longIdentifier) {
            super(longIdentifier);
        }

        @Override
        Builder getThis() {
            return this;
        }

        @Override
        public FileBasedArgument buildArgument() throws ArgumentException {
            return new FileBasedArgument(this);
        }
    }
}

