/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.util.annotations.VisibleForTesting;

public final class ElasticsearchUtil {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @VisibleForTesting
    protected static final String NORMALIZED_FIELD = "_normalized";
    @VisibleForTesting
    protected static final String FIELD_NAMES_FIELD = "fieldNames";
    private static final String NORMALIZED_FIELD_JSON_PREFIX = ",\"_normalized\":";
    private static final int MAX_FIELD_COUNT = 1;
    private static final Pattern JSON_KEY_WITH_PERIOD_CHAR_PATTERN = Pattern.compile("[{,]\\s*\"((?=[^\"]*[.][^\"]*)[^\"]+)\"\\s*:");
    private static final Pattern JSON_KEY_WITH_UNDERSCORE_CHAR_PATTERN = Pattern.compile("[{,]\\s*\"((?=[^\"]*[_][^\"]*)[^\"]+)\"\\s*:");
    private static final Pattern PERIOD_CHAR_PATTERN = Pattern.compile("[.]");

    private ElasticsearchUtil() {
    }

    public static String normalizeJson(JsonValue value) throws IOException {
        if (value != null) {
            if (value.get(NORMALIZED_FIELD).isNotNull()) {
                throw new IllegalStateException("_normalized is a reserved JsonValue field");
            }
            String json = OBJECT_MAPPER.writeValueAsString(value.getObject());
            return ElasticsearchUtil.replaceKeyPeriodsWithUnderscores(json);
        }
        return null;
    }

    public static JsonValue denormalizeJson(JsonValue value) throws IOException {
        if (value != null) {
            JsonValue normalized = value.get(NORMALIZED_FIELD);
            if (!normalized.isNotNull()) {
                return value;
            }
            value.remove(NORMALIZED_FIELD);
            return ElasticsearchUtil.restoreKeyPeriods(value, normalized);
        }
        return null;
    }

    @VisibleForTesting
    protected static String replaceKeyPeriodsWithUnderscores(String json) throws IOException {
        Matcher m = JSON_KEY_WITH_PERIOD_CHAR_PATTERN.matcher(json);
        if (m.find()) {
            LinkedHashMap normalized = new LinkedHashMap(1);
            LinkedHashMap<String, String> fieldNames = new LinkedHashMap<String, String>(2);
            normalized.put(FIELD_NAMES_FIELD, fieldNames);
            int n = json.length();
            StringBuilder builder = new StringBuilder(n + NORMALIZED_FIELD_JSON_PREFIX.length() + 128);
            builder.append(json);
            String originalFieldName = m.group(1);
            String normalizedFieldName = ElasticsearchUtil.replaceAllPeriodsWithUnderscores(builder, m.start(1), m.end(1));
            fieldNames.put(normalizedFieldName, originalFieldName);
            int index = m.end();
            while (index != n && m.find(index)) {
                originalFieldName = m.group(1);
                normalizedFieldName = ElasticsearchUtil.replaceAllPeriodsWithUnderscores(builder, m.start(1), m.end(1));
                fieldNames.put(normalizedFieldName, originalFieldName);
                index = m.end();
            }
            builder.setLength(n - 1);
            builder.append(NORMALIZED_FIELD_JSON_PREFIX).append(OBJECT_MAPPER.writeValueAsString(normalized)).append('}');
            return builder.toString();
        }
        return json;
    }

    @VisibleForTesting
    protected static JsonValue restoreKeyPeriods(JsonValue value, JsonValue normalized) throws IOException {
        String s;
        Matcher m;
        JsonValue fieldNames = normalized.get(FIELD_NAMES_FIELD);
        if (fieldNames.isNotNull() && !fieldNames.asMap().isEmpty() && (m = JSON_KEY_WITH_UNDERSCORE_CHAR_PATTERN.matcher(s = OBJECT_MAPPER.writeValueAsString(value.getObject()))).find()) {
            int n = s.length();
            StringBuilder builder = new StringBuilder(n);
            if (m.start(1) != 0) {
                builder.append(s.substring(0, m.start(1)));
            }
            builder.append(ElasticsearchUtil.replace(m.group(1), fieldNames));
            int index = m.end(1);
            while (index != n && m.find(index)) {
                if (index != m.start(1)) {
                    builder.append(s.substring(index, m.start(1)));
                }
                builder.append(ElasticsearchUtil.replace(m.group(1), fieldNames));
                index = m.end(1);
            }
            if (index != n) {
                builder.append(s.substring(index));
            }
            return JsonValue.json((Object)Json.readJson((String)builder.toString()));
        }
        return value;
    }

    private static String replaceAllPeriodsWithUnderscores(StringBuilder s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != '.') continue;
            s.setCharAt(i, '_');
        }
        return s.substring(start, end);
    }

    private static String replace(String fieldName, JsonValue fieldNames) {
        JsonValue value = fieldNames.get(fieldName);
        return value.isNull() ? fieldName : value.asString();
    }

    public static JsonPointer normalizeJsonPointer(JsonPointer ptr) {
        String jsonPointer;
        Matcher matcher;
        if (ptr != null && (matcher = PERIOD_CHAR_PATTERN.matcher(jsonPointer = ptr.toString())).find()) {
            return new JsonPointer(matcher.replaceAll("_"));
        }
        return ptr;
    }

    public static boolean renameField(JsonValue jsonValue, String oldKey, String newKey) {
        Map map;
        Object value;
        if (jsonValue.isMap() && (value = (map = jsonValue.asMap()).remove(oldKey)) != null) {
            if (map.put(newKey, value) != null) {
                ElasticsearchUtil.renameField(jsonValue, newKey, oldKey);
                throw new IllegalStateException("Cannot overwrite existing field: " + newKey);
            }
            return true;
        }
        return false;
    }
}

