/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.retention;

import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import org.joda.time.format.DateTimeFormatter;

public class TimestampFilenameFilter
implements FilenameFilter {
    private final File initialFile;
    private final String prefix;
    private final DateTimeFormatter suffixDateFormat;

    public TimestampFilenameFilter(File initialFile, String prefix, DateTimeFormatter suffixDateFormat) {
        this.initialFile = initialFile;
        this.prefix = prefix;
        this.suffixDateFormat = suffixDateFormat;
    }

    @Override
    public boolean accept(File dir, String name) {
        StringBuilder newFileNameBuilder = new StringBuilder();
        Path path = this.initialFile.toPath();
        if (this.prefix != null) {
            newFileNameBuilder.append(this.prefix);
        }
        newFileNameBuilder.append(path.getFileName());
        String newFileName = newFileNameBuilder.toString();
        if (name.length() < newFileName.length()) {
            return false;
        }
        String timestamp = name.substring(newFileName.length());
        try {
            this.suffixDateFormat.parseDateTime(timestamp.replace(".gz", ""));
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            return false;
        }
        return name.startsWith(newFileName);
    }
}

