/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers.buffering;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.batch.CommonAuditBatchConfiguration;
import org.forgerock.audit.events.handlers.buffering.BatchConsumer;
import org.forgerock.audit.events.handlers.buffering.BatchException;
import org.forgerock.audit.events.handlers.buffering.BatchPublisher;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferedBatchPublisher
implements BatchPublisher {
    private static final Logger logger = LoggerFactory.getLogger(BufferedBatchPublisher.class);
    private final BlockingQueue<BatchEntry> queue;
    private final ScheduledExecutorService scheduler;
    private final QueueConsumer queueConsumer;
    private final Duration writeInterval;

    private BufferedBatchPublisher(BuilderImpl builder) {
        this.queue = new ArrayBlockingQueue<BatchEntry>(builder.capacity);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.queueConsumer = new QueueConsumer(builder.maxBatchedEvents, builder.averagePerEventPayloadSize, builder.autoFlush, this.queue, this.scheduler, builder.batchConsumer);
        this.writeInterval = builder.writeInterval;
    }

    @Override
    public void startup() {
        this.scheduler.scheduleAtFixedRate(this.queueConsumer, 0L, this.writeInterval.to(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        if (!this.scheduler.isShutdown()) {
            this.queueConsumer.shutdown();
        }
    }

    @Override
    public boolean offer(String topic, JsonValue event) {
        return this.queue.offer(new BatchEntry(topic, event));
    }

    public static Builder newBuilder(BatchConsumer batchConsumer) {
        return new BuilderImpl(batchConsumer);
    }

    private static final class BuilderImpl
    implements Builder {
        private static final int MIN_QUEUE_SIZE = 10000;
        private static final int MIN_BATCH_SIZE = 500;
        private static final int MIN_PER_EVENT_PAYLOAD_SIZE = 32;
        private final BatchConsumer batchConsumer;
        private int capacity;
        private int maxBatchedEvents;
        private int averagePerEventPayloadSize;
        private Duration writeInterval;
        private boolean autoFlush;

        private BuilderImpl(BatchConsumer batchConsumer) {
            Reject.ifNull((Object)batchConsumer, (String)"batchConsumer must not be null");
            this.batchConsumer = batchConsumer;
            this.capacity = 10000;
            this.maxBatchedEvents = 500;
            this.averagePerEventPayloadSize = 32;
            this.writeInterval = CommonAuditBatchConfiguration.POLLING_INTERVAL;
        }

        @Override
        public Builder capacity(int capacity) {
            this.capacity = Math.max(capacity, 10000);
            return this;
        }

        @Override
        public Builder maxBatchEvents(int maxBatchedEvents) {
            this.maxBatchedEvents = Math.max(maxBatchedEvents, 500);
            return this;
        }

        @Override
        public Builder averagePerEventPayloadSize(int averagePerEventPayloadSize) {
            this.averagePerEventPayloadSize = Math.max(averagePerEventPayloadSize, 32);
            return this;
        }

        @Override
        public Builder writeInterval(Duration writeInterval) {
            this.writeInterval = writeInterval != null && writeInterval.getValue() > 0L ? writeInterval : CommonAuditBatchConfiguration.POLLING_INTERVAL;
            return this;
        }

        @Override
        public Builder autoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
            return this;
        }

        @Override
        public BatchPublisher build() {
            return new BufferedBatchPublisher(this);
        }
    }

    public static interface Builder {
        public Builder capacity(int var1);

        public Builder maxBatchEvents(int var1);

        public Builder averagePerEventPayloadSize(int var1);

        public Builder writeInterval(Duration var1);

        public Builder autoFlush(boolean var1);

        public BatchPublisher build();
    }

    private static class QueueConsumer
    implements Runnable {
        private final int maxBatchedEvents;
        private final boolean flushOnShutdown;
        private final BlockingQueue<BatchEntry> queue;
        private final List<BatchEntry> batch;
        private final StringBuilder payload;
        private final BatchConsumer batchEventHandler;
        private final ScheduledExecutorService scheduler;
        private volatile boolean shutdown;

        public QueueConsumer(int maxBatchedEvents, int averagePerEventPayloadSize, boolean flushOnShutdown, BlockingQueue<BatchEntry> queue, ScheduledExecutorService scheduler, BatchConsumer batchEventHandler) {
            this.queue = queue;
            this.flushOnShutdown = flushOnShutdown;
            this.scheduler = scheduler;
            this.batchEventHandler = batchEventHandler;
            this.maxBatchedEvents = maxBatchedEvents;
            this.batch = new ArrayList<BatchEntry>(maxBatchedEvents);
            this.payload = new StringBuilder(maxBatchedEvents * averagePerEventPayloadSize);
        }

        public void shutdown() {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.flushOnShutdown) {
                    boolean interrupted = false;
                    while (!this.scheduler.isTerminated()) {
                        try {
                            this.scheduler.awaitTermination(1L, TimeUnit.MINUTES);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void batch() {
            this.queue.drainTo(this.batch, this.maxBatchedEvents);
            if (!this.batch.isEmpty()) {
                try {
                    for (BatchEntry entry : this.batch) {
                        try {
                            this.batchEventHandler.addToBatch(entry.getTopic(), entry.getEvent(), this.payload);
                        }
                        catch (Exception e) {
                            logger.error("addToBatch failed", (Throwable)e);
                        }
                    }
                    if (this.payload.length() != 0) {
                        this.batchEventHandler.publishBatch(this.payload.toString()).thenCatch((Function)new Function<BatchException, Void, BatchException>(){

                            public Void apply(BatchException e) throws BatchException {
                                logger.error("publishBatch failed", (Throwable)e);
                                return null;
                            }
                        });
                    }
                }
                finally {
                    this.batch.clear();
                    this.payload.setLength(0);
                }
            }
        }

        @Override
        public void run() {
            if (this.shutdown) {
                this.scheduler.shutdown();
                if (this.flushOnShutdown) {
                    while (!this.queue.isEmpty()) {
                        this.batch();
                    }
                }
            }
            this.batch();
        }
    }

    private static class BatchEntry {
        private final String topic;
        private final JsonValue event;

        public BatchEntry(String topic, JsonValue event) {
            this.topic = topic;
            this.event = event;
        }

        public JsonValue getEvent() {
            return this.event;
        }

        public String getTopic() {
            return this.topic;
        }
    }
}

