/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventTopicsMetaDataBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EventTopicsMetaDataBuilder.class);
    private static final String SCHEMA = "schema";
    private static final String PROPERTIES = "properties";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private JsonValue coreTopicSchemaExtensions = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
    private JsonValue additionalTopicSchemas = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));

    private EventTopicsMetaDataBuilder() {
    }

    public static EventTopicsMetaDataBuilder coreTopicSchemas() {
        return new EventTopicsMetaDataBuilder();
    }

    public EventTopicsMetaDataBuilder withCoreTopicSchemaExtensions(JsonValue coreTopicSchemaExtensions) {
        this.coreTopicSchemaExtensions = coreTopicSchemaExtensions == null ? JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0])) : coreTopicSchemaExtensions;
        return this;
    }

    public EventTopicsMetaDataBuilder withAdditionalTopicSchemas(JsonValue additionalTopicSchemas) {
        this.additionalTopicSchemas = additionalTopicSchemas == null ? JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0])) : additionalTopicSchemas;
        return this;
    }

    public EventTopicsMetaData build() {
        Map<String, JsonValue> auditEventTopicSchemas = this.readCoreEventTopicSchemas();
        this.extendCoreEventTopicsSchemas(auditEventTopicSchemas);
        this.addCustomEventTopicSchemas(auditEventTopicSchemas);
        return new EventTopicsMetaData(auditEventTopicSchemas);
    }

    private Map<String, JsonValue> readCoreEventTopicSchemas() {
        HashMap<String, JsonValue> hashMap;
        block9: {
            HashMap<String, JsonValue> auditEvents = new HashMap<String, JsonValue>();
            InputStream configStream = this.getResourceAsStream("/org/forgerock/audit/events.json");
            try {
                JsonValue predefinedEventTypes = new JsonValue(MAPPER.readValue(configStream, Map.class));
                for (String eventTypeName : predefinedEventTypes.keys()) {
                    auditEvents.put(eventTypeName, predefinedEventTypes.get(eventTypeName));
                }
                hashMap = auditEvents;
                if (configStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (configStream != null) {
                        try {
                            configStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.error("Error while parsing core event topic schema definitions", (Throwable)ioe);
                    throw new RuntimeException(ioe);
                }
            }
            configStream.close();
        }
        return hashMap;
    }

    private InputStream getResourceAsStream(String resourcePath) {
        return new BufferedInputStream(this.getClass().getResourceAsStream(resourcePath));
    }

    private void extendCoreEventTopicsSchemas(Map<String, JsonValue> auditEventTopicSchemas) {
        for (String topic : this.coreTopicSchemaExtensions.keys()) {
            if (!auditEventTopicSchemas.containsKey(topic)) continue;
            JsonValue coreEventType = auditEventTopicSchemas.get(topic);
            JsonValue coreProperties = coreEventType.get(SCHEMA).get(PROPERTIES);
            JsonValue extendedProperties = this.coreTopicSchemaExtensions.get(topic).get(SCHEMA).get(PROPERTIES);
            for (String property : extendedProperties.keys()) {
                if (coreProperties.isDefined(property)) {
                    logger.warn("Cannot override {} property of {} topic", (Object)property, (Object)topic);
                    continue;
                }
                coreProperties.add(property, (Object)extendedProperties.get(property));
            }
        }
    }

    private void addCustomEventTopicSchemas(Map<String, JsonValue> auditEventTopicSchemas) {
        for (String topic : this.additionalTopicSchemas.keys()) {
            if (!auditEventTopicSchemas.containsKey(topic)) {
                JsonValue additionalTopicSchema = this.additionalTopicSchemas.get(topic);
                if (!additionalTopicSchema.get(SCHEMA).isDefined(PROPERTIES)) {
                    logger.warn("{} topic schema definition is invalid", (Object)topic);
                    continue;
                }
                auditEventTopicSchemas.put(topic, additionalTopicSchema);
                continue;
            }
            logger.warn("Cannot override pre-defined event topic {}", (Object)topic);
        }
    }
}

