/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.transform;

import io.swagger.models.Info;
import org.forgerock.api.transform.LocalizableTitleAndDescription;
import org.forgerock.util.i18n.LocalizableString;

class LocalizableInfo
extends Info
implements LocalizableTitleAndDescription<Info> {
    private LocalizableString title;
    private LocalizableString description;

    LocalizableInfo() {
    }

    @Override
    public LocalizableInfo title(LocalizableString title) {
        this.title = title;
        return this;
    }

    @Override
    public LocalizableInfo description(LocalizableString description) {
        this.description = description;
        return this;
    }

    @Override
    public LocalizableInfo title(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.title = new LocalizableString(title);
    }

    @Override
    public LocalizableInfo description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        this.description = new LocalizableString(description);
    }

    @Override
    public LocalizableString getLocalizableTitle() {
        return this.title;
    }

    @Override
    public LocalizableString getLocalizableDescription() {
        return this.description;
    }

    public LocalizableInfo mergeWith(Info info) {
        super.mergeWith(info);
        if (info instanceof LocalizableInfo) {
            LocalizableInfo localizableInfo = (LocalizableInfo)info;
            if (localizableInfo.description != null) {
                this.description = localizableInfo.description;
            }
            if (localizableInfo.title != null) {
                this.title = localizableInfo.title;
            }
        } else {
            if (info.getDescription() != null) {
                this.description(info.getDescription());
            }
            if (info.getTitle() != null) {
                this.title(info.getTitle());
            }
        }
        return this;
    }
}

