/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.api.util.PathUtil;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.http.routing.Version;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class Paths {
    private final Map<String, VersionedPath> paths;

    private Paths(Builder builder) {
        this.paths = builder.paths;
    }

    @JsonValue
    protected Map<String, VersionedPath> getPaths() {
        return this.paths;
    }

    @JsonIgnore
    public VersionedPath get(String name) {
        return this.paths.get(name);
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.paths.keySet();
    }

    public static Builder paths() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Paths paths1 = (Paths)o;
        return Objects.equals(this.paths, paths1.paths);
    }

    public int hashCode() {
        return Objects.hash(this.paths);
    }

    public static final class Builder {
        private final Map<String, VersionedPath> paths = new HashMap<String, VersionedPath>();

        private Builder() {
        }

        @JsonAnySetter
        public Builder put(String path, VersionedPath versionedPath) {
            if (path == null || ValidationUtil.containsWhitespace(path)) {
                throw new IllegalArgumentException("path required and may not contain whitespace");
            }
            if (!path.isEmpty()) {
                path = PathUtil.buildPath(path, new String[0]);
            }
            if (this.paths.containsKey(path)) {
                throw new IllegalStateException("path not unique");
            }
            this.paths.put(path, (VersionedPath)Reject.checkNotNull((Object)versionedPath));
            return this;
        }

        public Builder merge(String path, VersionedPath versionedPath) {
            if (path == null || ValidationUtil.containsWhitespace(path)) {
                throw new IllegalArgumentException("path required and may not contain whitespace");
            }
            if (!path.isEmpty()) {
                path = PathUtil.buildPath(path, new String[0]);
            }
            if (!this.paths.containsKey(path)) {
                this.put(path, (VersionedPath)Reject.checkNotNull((Object)versionedPath));
            } else {
                VersionedPath existing = this.paths.get(path);
                for (Version v : versionedPath.getVersions()) {
                    existing.addVersion(v, versionedPath.get(v));
                }
            }
            return this;
        }

        public Paths build() {
            return new Paths(this);
        }
    }
}

