/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Definitions;
import org.forgerock.api.models.Errors;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Services;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.Version;
import org.forgerock.util.i18n.LocalizableString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrestApiProducer
implements ApiProducer<ApiDescription> {
    private final String version;
    private final String id;
    private final LocalizableString description;
    private static final Logger LOGGER = LoggerFactory.getLogger(CrestApiProducer.class);

    public CrestApiProducer(String id, String apiVersion, LocalizableString description) {
        this.id = id;
        this.version = apiVersion;
        this.description = description;
    }

    public CrestApiProducer(String id, String apiVersion) {
        this(id, apiVersion, null);
    }

    public ApiDescription withPath(ApiDescription api, String parentPath) {
        Paths.Builder paths = Paths.paths();
        Set<String> names = api.getPaths().getNames();
        for (String subpath : names) {
            paths.put(subpath.equals("") ? parentPath : parentPath + "/" + subpath, api.getPaths().get(subpath));
        }
        return this.createApi(api.getDefinitions(), api.getErrors(), api.getServices(), paths.build());
    }

    public ApiDescription withVersion(ApiDescription api, Version version) {
        Paths.Builder paths = Paths.paths();
        Set<String> names = api.getPaths().getNames();
        for (String path : names) {
            VersionedPath versionedPath = api.getPaths().get(path);
            if (Collections.singleton(VersionedPath.UNVERSIONED).equals(versionedPath.getVersions())) {
                paths.put(path, VersionedPath.versionedPath().put(version, versionedPath.get(VersionedPath.UNVERSIONED)).build());
                continue;
            }
            throw new IllegalStateException("Trying to version something already versioned: " + versionedPath);
        }
        return this.createApi(api.getDefinitions(), api.getErrors(), api.getServices(), paths.build());
    }

    public ApiDescription merge(List<ApiDescription> descriptions) {
        Paths.Builder paths = Paths.paths();
        Definitions.Builder definitions = Definitions.definitions();
        Errors.Builder errors = Errors.errors();
        Services.Builder services = Services.services();
        for (ApiDescription description : descriptions) {
            if (description == null) continue;
            try {
                if (description.getDefinitions() != null) {
                    for (String definition : description.getDefinitions().getNames()) {
                        definitions.put(definition, description.getDefinitions().get(definition));
                    }
                }
                if (description.getErrors() != null) {
                    for (String error : description.getErrors().getNames()) {
                        errors.put(error, description.getErrors().get(error));
                    }
                }
                if (description.getServices() != null) {
                    for (String service : description.getServices().getNames()) {
                        services.put(service, description.getServices().get(service));
                    }
                }
                if (description.getPaths() == null) continue;
                for (String path : description.getPaths().getNames()) {
                    paths.merge(path, description.getPaths().get(path));
                }
            }
            catch (RuntimeException re) {
                LOGGER.error(re.getMessage(), re.fillInStackTrace());
                throw re;
            }
        }
        return this.createApi(definitions.build(), errors.build(), services.build(), paths.build());
    }

    public ApiDescription addApiInfo(ApiDescription api) {
        return this.createApi(api.getDefinitions(), api.getErrors(), api.getServices(), api.getPaths());
    }

    private ApiDescription createApi(Definitions definitions, Errors errors, Services services, Paths paths) {
        return ApiDescription.apiDescription().definitions(definitions).errors(errors).services(services).paths(paths).id(this.id).version(this.version).description(this.description).build();
    }

    public ApiProducer<ApiDescription> newChildProducer(String idFragment) {
        return new CrestApiProducer(this.id + idFragment, this.version);
    }
}

