/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

class InterfaceCollectionInstance
implements RequestHandler {
    private final CollectionResourceProvider provider;

    InterfaceCollectionInstance(CollectionResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.provider.actionInstance(Resources.parentOf(context), Resources.idOf(context), request);
    }

    @Override
    public final Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return Promises.newExceptionPromise((Exception)Resources.newBadRequestException("The resource instance %s cannot be created", request.getResourcePath()));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return this.provider.deleteInstance(Resources.parentOf(context), Resources.idOf(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return this.provider.patchInstance(Resources.parentOf(context), Resources.idOf(context), request);
    }

    @Override
    public final Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return Promises.newExceptionPromise((Exception)Resources.newBadRequestException("The resource instance %s cannot be queried", request.getResourcePath()));
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return this.provider.readInstance(Resources.parentOf(context), Resources.idOf(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return this.provider.updateInstance(Resources.parentOf(context), Resources.idOf(context), request);
    }
}

