/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Reject;

public class AccessTokenInfo {
    public static final long NEVER_EXPIRES = Long.MAX_VALUE;
    private final JsonValue rawInfo;
    private final String token;
    private final Set<String> scopes;
    private final long expiresAt;

    public AccessTokenInfo(JsonValue rawInfo, String token, Set<String> scopes, long expiresAt) {
        this.rawInfo = ((JsonValue)Reject.checkNotNull((Object)rawInfo)).clone();
        this.token = (String)Reject.checkNotNull((Object)token);
        this.scopes = Collections.unmodifiableSet((Set)Reject.checkNotNull(scopes));
        this.expiresAt = expiresAt;
    }

    public Map<String, Object> getInfo() {
        return this.rawInfo.asMap();
    }

    public JsonValue asJsonValue() {
        return this.rawInfo;
    }

    public String getToken() {
        return this.token;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }
}

