/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import io.swagger.models.Swagger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.forgerock.api.CrestApiProducer;
import org.forgerock.api.commons.CommonsApi;
import org.forgerock.api.jackson.PathsModule;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.transform.OpenApiTransformer;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Handler;
import org.forgerock.http.header.AcceptLanguageHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.http.swagger.SwaggerUtils;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.Applications;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.CrestApplication;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilters;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourcePath;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpContext;
import org.forgerock.json.resource.http.HttpContextFactory;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.json.resource.http.RequestRunner;
import org.forgerock.json.resource.http.SecurityContextFactory;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.i18n.PreferredLocales;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpAdapter
implements Handler,
Describable<Swagger, org.forgerock.http.protocol.Request>,
Describable.Listener {
    private static final Logger logger = LoggerFactory.getLogger(HttpAdapter.class);
    private static final ObjectMapper API_OBJECT_MAPPER = new ObjectMapper().registerModules(new Module[]{new Json.LocalizableStringModule(), new Json.JsonValueModule(), new PathsModule()});
    private final ConnectionFactory connectionFactory;
    private final HttpContextFactory contextFactory;
    private final String apiId;
    private final String apiVersion;
    private Swagger descriptor;
    private final List<Describable.Listener> apiListeners = new CopyOnWriteArrayList<Describable.Listener>();
    private ApiProducer<Swagger> apiProducer;

    @Deprecated
    public HttpAdapter(ConnectionFactory connectionFactory) {
        this(connectionFactory, (HttpContextFactory)null);
    }

    @Deprecated
    public HttpAdapter(ConnectionFactory connectionFactory, Context parentContext) {
        this(connectionFactory, HttpUtils.staticContextFactory(parentContext));
    }

    @Deprecated
    public HttpAdapter(ConnectionFactory connectionFactory, HttpContextFactory contextFactory) {
        this(Applications.simpleCrestApplication((ConnectionFactory)connectionFactory, null, null), contextFactory);
    }

    public HttpAdapter(CrestApplication application, HttpContextFactory contextFactory) {
        this.contextFactory = contextFactory != null ? contextFactory : SecurityContextFactory.getHttpServletContextFactory();
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)application.getConnectionFactory());
        this.apiId = application.getApiId();
        this.apiVersion = application.getApiVersion();
        try {
            Optional<Describable<ApiDescription, Request>> describable = this.getDescribableConnection();
            if (describable.isPresent()) {
                ((Describable)describable.get()).addDescriptorListener((Describable.Listener)this);
            }
        }
        catch (ResourceException e) {
            logger.warn("Could not create connection", (Throwable)e);
        }
    }

    public Promise<Response, NeverThrowsException> handle(Context context, org.forgerock.http.protocol.Request request) {
        try {
            RequestType requestType = HttpUtils.determineRequestType(request);
            switch (requestType) {
                case CREATE: {
                    return this.doCreate(context, request);
                }
                case READ: {
                    return this.doRead(context, request);
                }
                case UPDATE: {
                    return this.doUpdate(context, request);
                }
                case DELETE: {
                    return this.doDelete(context, request);
                }
                case PATCH: {
                    return this.doPatch(context, request);
                }
                case ACTION: {
                    return this.doAction(context, request);
                }
                case QUERY: {
                    return this.doQuery(context, request);
                }
                case API: {
                    return this.doApiRequest(context, request);
                }
            }
            throw new NotSupportedException("Operation " + requestType + " not supported");
        }
        catch (ResourceException e) {
            return HttpUtils.fail(request, e);
        }
    }

    Promise<Response, NeverThrowsException> doDelete(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            DeleteRequest request = Requests.newDeleteRequest((ResourcePath)this.getResourcePath(context, req)).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doRead(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            String rev = HttpUtils.getIfNoneMatch(req);
            if ("*".equals(rev)) {
                throw new PreconditionFailedException("If-None-Match * not appropriate for " + HttpUtils.getMethod(req) + " requests");
            }
            ReadRequest request = Requests.newReadRequest((ResourcePath)this.getResourcePath(context, req)).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                if (HttpUtils.PARAM_MIME_TYPE.equalsIgnoreCase(name)) {
                    if (values.size() != 1 || ((String)values.get(0)).split(",").length > 1) {
                        throw new BadRequestException("Only one mime type value allowed");
                    }
                    if (((List)parameters.get((Object)HttpUtils.PARAM_FIELDS)).size() == 1) continue;
                    throw new BadRequestException("The mime type parameter requires only 1 field to be specified");
                }
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doQuery(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            HttpUtils.rejectIfNoneMatch(req);
            QueryRequest request = Requests.newQueryRequest((ResourcePath)this.getResourcePath(context, req)).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                if (name.equalsIgnoreCase(HttpUtils.PARAM_SORT_KEYS)) {
                    for (String s : values) {
                        try {
                            request.addSortKey(s.split(","));
                        }
                        catch (IllegalArgumentException e) {
                            throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma separated list of sort keys");
                        }
                    }
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_ID)) {
                    request.setQueryId(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_EXPRESSION)) {
                    request.setQueryExpression(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_COOKIE)) {
                    request.setPagedResultsCookie(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_OFFSET)) {
                    request.setPagedResultsOffset(HttpUtils.asIntValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGE_SIZE)) {
                    request.setPageSize(HttpUtils.asIntValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_FILTER)) {
                    String s = HttpUtils.asSingleValue(name, values);
                    try {
                        request.setQueryFilter(QueryFilters.parse((String)s));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a valid query filter");
                    }
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_TOTAL_PAGED_RESULTS_POLICY)) {
                    String policy = HttpUtils.asSingleValue(name, values);
                    try {
                        request.setTotalPagedResultsPolicy(CountPolicy.valueOf((String)policy.toUpperCase()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new BadRequestException("The value '" + policy + "' for parameter '" + name + "' could not be parsed as a valid count policy");
                    }
                }
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            if (request.getQueryId() != null && request.getQueryFilter() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_FILTER + " are mutually exclusive");
            }
            if (request.getQueryId() != null && request.getQueryExpression() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
            }
            if (request.getQueryFilter() != null && request.getQueryExpression() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_FILTER + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
            }
            if (request.getPagedResultsOffset() > 0 && request.getPagedResultsCookie() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_PAGED_RESULTS_OFFSET + " and " + HttpUtils.PARAM_PAGED_RESULTS_COOKIE + " are mutually exclusive");
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doPatch(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if (req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Use of If-None-Match not supported for PATCH requests");
            }
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            PatchRequest request = Requests.newPatchRequest((ResourcePath)this.getResourcePath(context, req), (PatchOperation[])new PatchOperation[0]).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            request.getPatchOperations().addAll(HttpUtils.getJsonPatchContent(req));
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doCreate(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if ("POST".equals(HttpUtils.getMethod(req))) {
                HttpUtils.rejectIfNoneMatch(req);
                HttpUtils.rejectIfMatch(req);
                Form parameters = req.getForm();
                JsonValue content = HttpUtils.getJsonContent(req);
                CreateRequest request = Requests.newCreateRequest((ResourcePath)this.getResourcePath(context, req), (JsonValue)content).setResourceVersion(requestedResourceVersion);
                for (Map.Entry p : parameters.entrySet()) {
                    List values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                    request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
                }
                return this.doRequest(context, req, resp, (Request)request);
            }
            if (req.getHeaders().getFirst("If-Match") != null && req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Simultaneous use of If-Match and If-None-Match not supported for PUT requests");
            }
            Form parameters = req.getForm();
            JsonValue content = HttpUtils.getJsonContent(req);
            ResourcePath resourcePath = this.getResourcePath(context, req);
            if (resourcePath.isEmpty()) {
                throw new BadRequestException("No new resource ID in HTTP PUT request");
            }
            CreateRequest request = Requests.newCreateRequest((ResourcePath)resourcePath.parent(), (JsonValue)content).setNewResourceId(resourcePath.leaf()).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doAction(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            String action = HttpUtils.asSingleValue(HttpUtils.PARAM_ACTION, HttpUtils.getParameter(req, HttpUtils.PARAM_ACTION));
            JsonValue content = HttpUtils.getJsonActionContent(req);
            ActionRequest request = Requests.newActionRequest((ResourcePath)this.getResourcePath(context, req), (String)action).setContent(content).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doUpdate(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if (req.getHeaders().getFirst("If-Match") != null && req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Simultaneous use of If-Match and If-None-Match not supported for PUT requests");
            }
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            JsonValue content = HttpUtils.getJsonContent(req);
            UpdateRequest request = Requests.newUpdateRequest((ResourcePath)this.getResourcePath(context, req), (JsonValue)content).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    private Promise<Response, NeverThrowsException> doApiRequest(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Optional<Describable<ApiDescription, Request>> describable = this.getDescribableConnection();
            if (!describable.isPresent()) {
                throw new NotSupportedException();
            }
            Request request = Requests.newApiRequest((ResourcePath)this.getResourcePath(context, req));
            context = this.prepareRequest(context, req, request);
            ApiDescription api = (ApiDescription)((Describable)describable.get()).handleApiRequest(context, (Object)request);
            ObjectWriter writer = Json.makeLocalizingObjectWriter((ObjectMapper)API_OBJECT_MAPPER, (PreferredLocales)request.getPreferredLocales());
            List<String> values = HttpUtils.getParameter(req, "_prettyPrint");
            if (values != null && HttpUtils.asBooleanValue("_prettyPrint", values)) {
                writer = writer.withDefaultPrettyPrinter();
            }
            return Promises.newResultPromise((Object)new Response(Status.OK).setEntity((Object)writer.writeValueAsBytes((Object)api)));
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    private Optional<Describable<ApiDescription, Request>> getDescribableConnection() throws ResourceException {
        if (this.apiId == null || this.apiVersion == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("CREST API Descriptor API ID and Version are not set. Not describing.");
            }
            return Optional.absent();
        }
        Connection connection = this.connectionFactory.getConnection();
        if (connection instanceof Describable) {
            return Optional.of((Object)((Describable)connection));
        }
        return Optional.absent();
    }

    private Promise<Response, NeverThrowsException> doRequest(Context context, org.forgerock.http.protocol.Request req, Response resp, Request request) throws Exception {
        Context ctx = this.prepareRequest(context, req, request);
        final RequestRunner runner = new RequestRunner(ctx, request, req, resp);
        return this.connectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(Connection connection) {
                return runner.handleResult(connection);
            }
        }, (AsyncFunction)new AsyncFunction<ResourceException, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(ResourceException error) {
                return runner.handleError(error);
            }
        });
    }

    private Context prepareRequest(Context context, org.forgerock.http.protocol.Request req, Request request) throws ResourceException, MalformedHeaderException {
        Context ctx = this.newRequestContext(context, req);
        AcceptLanguageHeader acceptLanguageHeader = (AcceptLanguageHeader)req.getHeaders().get(AcceptLanguageHeader.class);
        request.setPreferredLocales(acceptLanguageHeader != null ? acceptLanguageHeader.getLocales() : new PreferredLocales(null));
        return ctx;
    }

    private ResourcePath getResourcePath(Context context, org.forgerock.http.protocol.Request req) throws ResourceException {
        try {
            if (context.containsContext(UriRouterContext.class)) {
                ResourcePath reqPath = ResourcePath.valueOf((String)req.getUri().getRawPath());
                return reqPath.subSequence(this.getMatchedUri(context).size(), reqPath.size());
            }
            return ResourcePath.valueOf((String)req.getUri().getRawPath());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private ResourcePath getMatchedUri(Context context) {
        ArrayList<ResourcePath> matched = new ArrayList<ResourcePath>();
        Context ctx = context;
        while (ctx.containsContext(UriRouterContext.class)) {
            UriRouterContext uriRouterContext = (UriRouterContext)ctx.asContext(UriRouterContext.class);
            matched.add(ResourcePath.valueOf((String)uriRouterContext.getMatchedUri()));
            ctx = uriRouterContext.getParent();
        }
        Collections.reverse(matched);
        ResourcePath matchedUri = new ResourcePath();
        for (ResourcePath resourcePath : matched) {
            matchedUri = matchedUri.concat(resourcePath);
        }
        return matchedUri;
    }

    private Context newRequestContext(Context context, org.forgerock.http.protocol.Request req) throws ResourceException {
        Context parent = this.contextFactory.createContext(context, req);
        return new AdviceContext((Context)new HttpContext(parent, req), HttpUtils.RESTRICTED_HEADER_NAMES);
    }

    private boolean parseCommonParameter(String name, List<String> values, Request request) throws ResourceException {
        if (name.equalsIgnoreCase(HttpUtils.PARAM_FIELDS)) {
            for (String s : values) {
                try {
                    request.addField(s.split(","));
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma separated list of JSON pointers");
                }
            }
            return true;
        }
        if (name.equalsIgnoreCase("_prettyPrint")) {
            HttpUtils.asBooleanValue(name, values);
            return true;
        }
        return false;
    }

    private void preprocessRequest(org.forgerock.http.protocol.Request req) throws ResourceException {
        String contentType = ContentTypeHeader.valueOf((Message)req).getType();
        if (!(req.getMethod().equalsIgnoreCase("GET") || contentType == null || HttpUtils.CONTENT_TYPE_REGEX.matcher(contentType).matches() || HttpUtils.isMultiPartRequest(contentType))) {
            throw new BadRequestException("The request could not be processed because it specified the content-type '" + contentType + "' when only the content-type '" + "application/json" + "' and '" + "multipart/form-data" + "' are supported");
        }
        if (req.getHeaders().getFirst("If-Modified-Since") != null) {
            throw new ConflictException("Header If-Modified-Since not supported");
        }
        if (req.getHeaders().getFirst("If-Unmodified-Since") != null) {
            throw new ConflictException("Header If-Unmodified-Since not supported");
        }
    }

    public Swagger api(ApiProducer<Swagger> producer) {
        this.apiProducer = producer;
        this.updateDescriptor();
        return this.descriptor;
    }

    private void updateDescriptor() {
        if (this.apiProducer == null) {
            return;
        }
        try {
            ApiDescription api;
            Optional<Describable<ApiDescription, Request>> describable = this.getDescribableConnection();
            if (describable.isPresent() && (api = (ApiDescription)((Describable)describable.get()).api((ApiProducer)new CrestApiProducer(this.apiId, this.apiVersion))) != null) {
                this.descriptor = (Swagger)this.apiProducer.addApiInfo((Object)OpenApiTransformer.execute((ApiDescription)api, (ApiDescription[])new ApiDescription[]{CommonsApi.COMMONS_API_DESCRIPTION}));
            }
        }
        catch (ResourceException e) {
            throw new IllegalStateException("Cannot get connection", e);
        }
    }

    public Swagger handleApiRequest(Context context, org.forgerock.http.protocol.Request request) {
        return this.descriptor != null ? SwaggerUtils.clone((Swagger)this.descriptor) : null;
    }

    public void addDescriptorListener(Describable.Listener listener) {
        this.apiListeners.add(listener);
    }

    public void removeDescriptorListener(Describable.Listener listener) {
        this.apiListeners.remove(listener);
    }

    public void notifyDescriptorChange() {
        this.updateDescriptor();
        for (Describable.Listener listener : this.apiListeners) {
            listener.notifyDescriptorChange();
        }
    }
}

