/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.handlers.jdbc.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JdbcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JdbcUtils() {
    }

    /*
     * Unable to fully structure code
     */
    static void initializePreparedStatement(PreparedStatement preparedStatement, List<Parameter> params) throws AuditException, SQLException, JsonProcessingException {
        i = 1;
        for (Parameter parameter : params) {
            parameterValue = parameter.getParameter();
            switch (1.$SwitchMap$org$forgerock$audit$handlers$jdbc$Parameter$Type[parameter.getParameterType().ordinal()]) {
                case 1: {
                    preparedStatement.setString(i, (String)parameterValue);
                    break;
                }
                case 2: {
                    if (parameterValue == null) {
                        preparedStatement.setNull(i, 6);
                        break;
                    }
                    if (!(parameterValue instanceof Float)) ** GOTO lbl15
                    preparedStatement.setFloat(i, ((Float)parameterValue).floatValue());
                    ** GOTO lbl20
lbl15:
                    // 1 sources

                    if (!(parameterValue instanceof Double)) ** GOTO lbl18
                    preparedStatement.setDouble(i, (Double)parameterValue);
                    ** GOTO lbl20
lbl18:
                    // 1 sources

                    if (parameterValue instanceof BigDecimal) {
                        preparedStatement.setBigDecimal(i, (BigDecimal)parameterValue);
                    }
                }
lbl20:
                // 6 sources

                case 3: {
                    if (parameterValue == null) {
                        preparedStatement.setNull(i, 4);
                        break;
                    }
                    if (parameterValue instanceof Long) {
                        preparedStatement.setLong(i, (Long)parameterValue);
                        break;
                    }
                    if (parameterValue instanceof Integer) {
                        preparedStatement.setInt(i, (Integer)parameterValue);
                        break;
                    }
                    error = String.format("Unable to map class type %s to %s for field %d", new Object[]{parameterValue.getClass().getCanonicalName(), parameter.getParameterType(), i});
                    JdbcUtils.LOGGER.error(error);
                    throw new AuditException(error);
                }
                case 4: {
                    if (parameterValue == null) {
                        preparedStatement.setNull(i, 16);
                        break;
                    }
                    preparedStatement.setBoolean(i, (Boolean)parameterValue);
                    break;
                }
                case 5: 
                case 6: {
                    if (parameterValue == null) {
                        preparedStatement.setString(i, null);
                        break;
                    }
                    preparedStatement.setString(i, JdbcUtils.MAPPER.writeValueAsString(parameterValue));
                    break;
                }
                default: {
                    error = String.format("Schema defines unknown type %s for field %d", new Object[]{parameter.getParameterType(), i});
                    JdbcUtils.LOGGER.error(error);
                    throw new AuditException(error);
                }
            }
            ++i;
        }
    }
}

