/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.forgerock.audit.Audit;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.batch.CommonAuditBatchConfiguration;
import org.forgerock.audit.events.AuditEventHelper;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.handlers.jdbc.BufferedJdbcAuditEventExecutor;
import org.forgerock.audit.handlers.jdbc.DatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.GenericDatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEventExecutor;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEventExecutorImpl;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.jdbc.OracleDatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.TableMapping;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAuditEventHandler
extends AuditEventHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(JdbcAuditEventHandler.class);
    public static final String MYSQL = "mysql";
    public static final String H2 = "h2";
    public static final String ORACLE = "oracle";
    private final JdbcAuditEventHandlerConfiguration configuration;
    private DataSource dataSource;
    private DatabaseStatementProvider databaseStatementProvider;
    private boolean sharedDataSource;
    private JdbcAuditEventExecutor jdbcAuditEventExecutor;

    @Inject
    public JdbcAuditEventHandler(JdbcAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, @Audit DataSource dataSource) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        this.configuration = configuration;
        this.dataSource = dataSource;
    }

    public void startup() throws ResourceException {
        if (this.dataSource != null) {
            this.sharedDataSource = true;
        } else {
            logger.info("No connection pool (DataSource) provided for JDBC Audit Event Handler; defaulting to Hikari");
            this.sharedDataSource = false;
            this.dataSource = new HikariDataSource(this.createHikariConfig(this.configuration.getConnectionPool()));
        }
        this.databaseStatementProvider = this.getDatabaseStatementProvider(this.configuration.getDatabaseType());
        JdbcAuditEventExecutorImpl jdbcAuditEventExecutor = new JdbcAuditEventExecutorImpl(this.dataSource);
        JdbcAuditEventHandlerConfiguration.EventBufferingConfiguration bufferConfig = this.configuration.getBuffering();
        this.jdbcAuditEventExecutor = bufferConfig.isEnabled() ? new BufferedJdbcAuditEventExecutor(bufferConfig.getMaxSize(), bufferConfig.isAutoFlush(), jdbcAuditEventExecutor, CommonAuditBatchConfiguration.POLLING_INTERVAL, bufferConfig.getWriterThreads(), bufferConfig.getMaxBatchedEvents(), this.dataSource) : jdbcAuditEventExecutor;
    }

    public void shutdown() throws ResourceException {
        if (!this.sharedDataSource && this.dataSource instanceof HikariDataSource) {
            ((HikariDataSource)this.dataSource).close();
        }
        this.jdbcAuditEventExecutor.close();
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        try {
            TableMapping mapping = this.getTableMapping(topic);
            JdbcAuditEvent jdbcAuditEvent = this.databaseStatementProvider.buildCreateEvent(event, mapping, this.eventTopicsMetaData.getSchema(topic));
            this.jdbcAuditEventExecutor.createAuditEvent(jdbcAuditEvent);
        }
        catch (AuditException e) {
            String error = String.format("Unable to create audit entry for %s", topic);
            logger.error(error, (Throwable)e);
            return new InternalServerErrorException(error, (Throwable)e).asPromise();
        }
        return Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event).asPromise();
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest queryRequest, QueryResourceHandler queryResourceHandler) {
        String auditEventTopic = queryRequest.getResourcePathObject().get(0);
        try {
            logger.debug("Query called for audit event: {} with queryFilter: {}", (Object)topic, (Object)queryRequest.getQueryFilter());
            TableMapping mapping = this.getTableMapping(topic);
            List<Map<String, Object>> results = this.jdbcAuditEventExecutor.queryAuditEvent(this.databaseStatementProvider.buildQueryEvent(mapping, queryRequest, this.eventTopicsMetaData.getSchema(topic)));
            for (Map<String, Object> entry : results) {
                JsonValue result = this.processEntry(entry, mapping, topic);
                queryResourceHandler.handleResource(Responses.newResourceResponse((String)result.get("_id").asString(), null, (JsonValue)result));
            }
            return Responses.newQueryResponse((String)String.valueOf(queryRequest.getPagedResultsOffset() + results.size()), (CountPolicy)CountPolicy.EXACT, (int)results.size()).asPromise();
        }
        catch (AuditException e) {
            String error = String.format("Unable to query audit entry for %s", auditEventTopic);
            logger.error(error, (Throwable)e);
            return new InternalServerErrorException(error, (Throwable)e).asPromise();
        }
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        JsonValue result;
        try {
            logger.debug("Read called for audit event {} with id {}", (Object)topic, (Object)resourceId);
            TableMapping mapping = this.getTableMapping(topic);
            List<Map<String, Object>> results = this.jdbcAuditEventExecutor.readAuditEvent(this.databaseStatementProvider.buildReadEvent(mapping, resourceId, this.eventTopicsMetaData.getSchema(topic)));
            if (results.isEmpty()) {
                return new NotFoundException(String.format("Entry not found for id: %s", resourceId)).asPromise();
            }
            result = this.processEntry(results.get(0), mapping, topic);
        }
        catch (AuditException e) {
            String error = String.format("Unable to read audit entry for %s", topic);
            logger.error(error, (Throwable)e);
            return new InternalServerErrorException(error, (Throwable)e).asPromise();
        }
        return Responses.newResourceResponse((String)resourceId, null, (JsonValue)result).asPromise();
    }

    private TableMapping getTableMapping(String auditEventTopic) throws AuditException {
        for (TableMapping tableMapping : this.configuration.getTableMappings()) {
            if (!tableMapping.getEvent().equalsIgnoreCase(auditEventTopic)) continue;
            return tableMapping;
        }
        throw new AuditException(String.format("No table mapping found for audit event type: %s", auditEventTopic));
    }

    private JsonValue processEntry(Map<String, Object> sqlResult, TableMapping tableMapping, String auditEventTopic) throws AuditException {
        JsonValue result = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
        try {
            for (Map.Entry<String, String> entry : tableMapping.getFieldToColumn().entrySet()) {
                Object value = sqlResult.get(entry.getValue().toLowerCase());
                if (value == null) continue;
                JsonPointer field = new JsonPointer(entry.getKey());
                String fieldType = AuditEventHelper.getPropertyType((JsonValue)this.eventTopicsMetaData.getSchema(auditEventTopic), (JsonPointer)field);
                if ("array".equalsIgnoreCase(fieldType) || "object".equalsIgnoreCase(fieldType)) {
                    result.putPermissive(field, Json.readJson((String)((String)value)));
                    continue;
                }
                result.putPermissive(field, value);
            }
        }
        catch (IOException e) {
            logger.error("Unable to process retrieved entry", (Throwable)e);
            throw new AuditException("Unable to process retrieved entry", (Throwable)e);
        }
        return result;
    }

    private HikariConfig createHikariConfig(JdbcAuditEventHandlerConfiguration.ConnectionPool connectionPool) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setAutoCommit(connectionPool.getAutoCommit());
        hikariConfig.setConnectionTimeout((long)connectionPool.getConnectionTimeout());
        hikariConfig.setIdleTimeout((long)connectionPool.getIdleTimeout());
        hikariConfig.setMaximumPoolSize(connectionPool.getMaxPoolSize());
        hikariConfig.setMaxLifetime((long)connectionPool.getMaxLifetime());
        hikariConfig.setMinimumIdle(connectionPool.getMinIdle());
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getJdbcUrl())) {
            hikariConfig.setJdbcUrl(connectionPool.getJdbcUrl());
        }
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getDataSourceClassName())) {
            hikariConfig.setDataSourceClassName(connectionPool.getDataSourceClassName());
        }
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getUsername())) {
            hikariConfig.setUsername(connectionPool.getUsername());
        }
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getPassword())) {
            hikariConfig.setPassword(connectionPool.getPassword());
        }
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getPoolName())) {
            hikariConfig.setPoolName(connectionPool.getPoolName());
        }
        if (!JdbcAuditEventHandler.isBlank(connectionPool.getDriverClassName())) {
            hikariConfig.setDriverClassName(connectionPool.getDriverClassName());
        }
        return hikariConfig;
    }

    private DatabaseStatementProvider getDatabaseStatementProvider(String databaseName) {
        switch (databaseName) {
            case "mysql": 
            case "h2": {
                return new GenericDatabaseStatementProvider();
            }
            case "oracle": {
                return new OracleDatabaseStatementProvider();
            }
        }
        logger.warn("Unknown databaseName provided. Using the generic statement provider: {}", (Object)databaseName);
        return new GenericDatabaseStatementProvider();
    }

    private static boolean isBlank(CharSequence charSeq) {
        if (charSeq == null) {
            return true;
        }
        int length = charSeq.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(charSeq.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

