/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.events.AuditEventHelper;
import org.forgerock.audit.handlers.jdbc.DatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.Parameter;
import org.forgerock.audit.handlers.jdbc.SqlStatementParser;
import org.forgerock.audit.handlers.jdbc.TableMapping;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseDatabaseStatementProvider
implements DatabaseStatementProvider {
    private static final Logger logger = LoggerFactory.getLogger(BaseDatabaseStatementProvider.class);

    BaseDatabaseStatementProvider() {
    }

    @Override
    public JdbcAuditEvent buildReadEvent(TableMapping mapping, String id, JsonValue eventTopicMetaData) throws AuditException {
        String idTableColumn = mapping.getFieldToColumn().get("_id");
        String selectStatement = String.format("SELECT * FROM %s WHERE %s = ?", mapping.getTable(), idTableColumn);
        logger.info("Built select statement: {}", (Object)selectStatement);
        JdbcAuditEvent jdbcAuditEvent = new JdbcAuditEvent(selectStatement, Collections.singletonList(new Parameter(this.getParameterType(eventTopicMetaData, new JsonPointer("_id")), id)));
        return jdbcAuditEvent;
    }

    @Override
    public JdbcAuditEvent buildCreateEvent(JsonValue content, TableMapping tableMapping, JsonValue eventTopicMetaData) throws AuditException {
        Map<String, String> fieldToColumn = tableMapping.getFieldToColumn();
        String columns = Utils.joinAsString((String)", ", fieldToColumn.values());
        String replacementTokens = Utils.joinAsString((String)", ", this.createReplacementTokens(fieldToColumn.keySet()));
        String insertStatement = String.format("INSERT INTO %s ( %s ) VALUES ( %s )", tableMapping.getTable(), columns, replacementTokens);
        logger.info("Built insert sql: {}", (Object)insertStatement);
        SqlStatementParser sqlStatementParser = new SqlStatementParser(insertStatement);
        LinkedList<Parameter> params = new LinkedList<Parameter>();
        for (String field : sqlStatementParser.getNamedParameters()) {
            JsonPointer fieldPointer = new JsonPointer(field);
            Parameter parameter = new Parameter(this.getParameterType(eventTopicMetaData, fieldPointer), content.get(fieldPointer) == null ? null : content.get(fieldPointer).getObject());
            params.add(parameter);
        }
        return new JdbcAuditEvent(sqlStatementParser.getSqlStatement(), params);
    }

    @Override
    public abstract JdbcAuditEvent buildQueryEvent(TableMapping var1, QueryRequest var2, JsonValue var3) throws AuditException;

    protected String createNamedParameter(JsonPointer pointer) {
        return "${" + pointer.toString() + "}";
    }

    protected Collection<String> createReplacementTokens(Collection<String> values) {
        LinkedList<String> transformedValues = new LinkedList<String>();
        for (String value : values) {
            transformedValues.add(this.createNamedParameter(new JsonPointer(value)));
        }
        return transformedValues;
    }

    protected Parameter.Type getParameterType(JsonValue eventTopicMetaData, JsonPointer field) throws AuditException {
        try {
            return (Parameter.Type)Utils.asEnum((String)AuditEventHelper.getPropertyType((JsonValue)eventTopicMetaData, (JsonPointer)field), Parameter.Type.class);
        }
        catch (ResourceException e) {
            String error = String.format("Unable to get type for filed %s", field);
            logger.error(error, (Object)field);
            throw new AuditException(error, (Throwable)e);
        }
    }
}

