/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.StatsThread;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.util.promise.Promise;

abstract class PerformanceRunner
implements ConnectionEventListener {
    private static final double[] DEFAULT_PERCENTILES = new double[]{99.9, 99.99, 99.999};
    private final ConsoleApplication app;
    private DataSource[] dataSourcePrototypes;
    private final ThreadLocal<DataSource[]> dataSources = new ThreadLocal<DataSource[]>(){

        @Override
        protected DataSource[] initialValue() {
            DataSource[] prototypes = PerformanceRunner.this.getDataSources();
            int sz = prototypes.length;
            DataSource[] threadLocalCopy = new DataSource[sz];
            for (int i = 0; i < sz; ++i) {
                threadLocalCopy[i] = prototypes[i].duplicate();
            }
            return threadLocalCopy;
        }
    };
    int numThreads;
    int numConnections;
    private boolean stopRequested;
    private int targetThroughput;
    private int maxIterations;
    private long warmUpDurationMs;
    private long maxDurationTimeMs;
    private boolean noRebind;
    private BindRequest bindRequest;
    private int statsIntervalMs;
    private final IntegerArgument numThreadsArgument;
    private final IntegerArgument maxDurationArgument;
    private final IntegerArgument statsIntervalArgument;
    private final IntegerArgument targetThroughputArgument;
    private final IntegerArgument numConnectionsArgument;
    private final IntegerArgument percentilesArgument;
    private final BooleanArgument keepConnectionsOpen;
    private final BooleanArgument noRebindArgument;
    private final StringArgument arguments;
    protected final IntegerArgument maxIterationsArgument;
    protected final IntegerArgument warmUpArgument;
    private final List<Thread> workerThreads = new ArrayList<Thread>();
    StatsThread statsThread;

    PerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
        ArgumentParser argParser = options.getArgumentParser();
        this.app = options.getConsoleApplication();
        this.numThreadsArgument = ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"numThreads").shortIdentifier(Character.valueOf('t'))).description(LocalizableMessage.raw((CharSequence)"Number of worker threads per connection", (Object[])new Object[0]))).lowerBound(1).defaultValue((Object)1)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{numThreads}", (Object[])new Object[0]))).buildArgument();
        if (options.supportsMultipleThreadsPerConnection()) {
            argParser.addArgument((Argument)this.numThreadsArgument);
        } else {
            this.numThreadsArgument.addValue("1");
        }
        this.numConnectionsArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"numConnections").shortIdentifier(Character.valueOf('c'))).description(LocalizableMessage.raw((CharSequence)"Number of connections", (Object[])new Object[0]))).lowerBound(1).defaultValue((Object)1)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{numConnections}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.maxIterationsArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"maxIterations").shortIdentifier(Character.valueOf('m'))).description(LocalizableMessage.raw((CharSequence)"Max iterations, 0 for unlimited", (Object[])new Object[0]))).defaultValue((Object)0)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{maxIterations}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.maxDurationArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"maxDuration").shortIdentifier(Character.valueOf('d'))).description(LocalizableMessage.raw((CharSequence)"Maximum duration in seconds, 0 for unlimited", (Object[])new Object[0]))).lowerBound(1).defaultValue((Object)0)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{maxDuration}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.warmUpArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"warmUpDuration").shortIdentifier(Character.valueOf('B'))).description(LocalizableMessage.raw((CharSequence)"Warm up duration in seconds", (Object[])new Object[0]))).defaultValue((Object)0)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{warmUpDuration}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.statsIntervalArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"statInterval").shortIdentifier(Character.valueOf('i'))).description(LocalizableMessage.raw((CharSequence)"Display results each specified number of seconds", (Object[])new Object[0]))).lowerBound(1).defaultValue((Object)5)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{statInterval}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.targetThroughputArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"targetThroughput").shortIdentifier(Character.valueOf('M'))).description(LocalizableMessage.raw((CharSequence)"Target average throughput to achieve", (Object[])new Object[0]))).defaultValue((Object)0)).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{targetThroughput}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.percentilesArgument = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"percentile").shortIdentifier(Character.valueOf('e'))).description(LocalizableMessage.raw((CharSequence)"Calculate max response time for a percentile of operations", (Object[])new Object[0]))).multiValued()).range(0, 100).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{percentile}", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.keepConnectionsOpen = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"keepConnectionsOpen").shortIdentifier(Character.valueOf('f'))).description(LocalizableMessage.raw((CharSequence)"Keep connections open", (Object[])new Object[0]))).buildAndAddToParser(argParser);
        this.noRebindArgument = ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"noRebind").shortIdentifier(Character.valueOf('F'))).description(LocalizableMessage.raw((CharSequence)"Keep connections open and do not rebind", (Object[])new Object[0]))).buildArgument();
        if (options.supportsRebind()) {
            argParser.addArgument((Argument)this.noRebindArgument);
        }
        this.arguments = ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"argument").shortIdentifier(Character.valueOf('g'))).description(LocalizableMessage.raw((CharSequence)("Argument used to evaluate the Java style format strings in program parameters (ie. Base DN, Search Filter). The set of all arguments provided form the the argument list in order. Besides static string arguments, they can be generated per iteration with the following functions: " + StaticUtils.EOL + DataSource.getUsage()), (Object[])new Object[0]))).multiValued()).valuePlaceholder(LocalizableMessage.raw((CharSequence)"{generator function or static string}", (Object[])new Object[0]))).buildArgument();
        if (options.supportsGeneratorArgument()) {
            argParser.addArgument((Argument)this.arguments);
        }
    }

    public void handleConnectionClosed() {
    }

    public synchronized void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
        if (!this.stopRequested) {
            this.app.errPrintln(ToolsMessages.ERROR_RATE_TOOLS_CANNOT_GET_CONNECTION.get((Object)error.getMessage()));
            if (error.getCause() != null && this.app.isVerbose()) {
                error.getCause().printStackTrace(this.app.getErrorStream());
            }
            this.stopTool(true);
        }
    }

    public void handleUnsolicitedNotification(ExtendedResult notification) {
    }

    public final void validate() throws ArgumentException {
        this.numConnections = this.numConnectionsArgument.getIntValue();
        this.numThreads = this.numThreadsArgument.getIntValue();
        this.warmUpDurationMs = (long)this.warmUpArgument.getIntValue() * 1000L;
        this.maxIterations = this.maxIterationsArgument.getIntValue() / this.numConnections / this.numThreads;
        this.maxDurationTimeMs = (long)this.maxDurationArgument.getIntValue() * 1000L;
        this.statsIntervalMs = this.statsIntervalArgument.getIntValue() * 1000;
        this.targetThroughput = this.targetThroughputArgument.getIntValue();
        this.noRebind = this.noRebindArgument.isPresent();
        if (!this.noRebindArgument.isPresent() && this.numThreads > 1) {
            throw new ArgumentException(ToolsMessages.ERR_TOOL_ARG_MUST_BE_USED_WHEN_ARG_CONDITION.get((Object)("--" + this.noRebindArgument.getLongIdentifier()), (Object)("--" + this.numThreadsArgument.getLongIdentifier()), (Object)"> 1"));
        }
        if (this.maxIterationsArgument.isPresent() && this.maxIterations <= 0) {
            throw new ArgumentException(ToolsMessages.ERR_TOOL_NOT_ENOUGH_ITERATIONS.get((Object)("--" + this.maxIterationsArgument.getLongIdentifier()), (Object)(this.numConnections * this.numThreads), (Object)this.numConnectionsArgument.getLongIdentifier(), (Object)this.numThreadsArgument.getLongIdentifier()));
        }
        this.dataSourcePrototypes = DataSource.parse(this.arguments.getValues());
    }

    final DataSource[] getDataSources() {
        if (this.dataSourcePrototypes == null) {
            throw new IllegalStateException("dataSources are null - validate() must be called first");
        }
        return this.dataSourcePrototypes;
    }

    abstract WorkerThread newWorkerThread(Connection var1, ConnectionFactory var2);

    abstract StatsThread newStatsThread(PerformanceRunner var1, ConsoleApplication var2);

    TimerThread newEndTimerThread(long timeToWait) {
        return new TimerThread(timeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int run(ConnectionFactory connectionFactory) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        this.statsThread = this.newStatsThread(this, this.app);
        try {
            this.validateCanConnectToServer(connectionFactory);
            for (int i = 0; i < this.numConnections; ++i) {
                Connection connection = null;
                if (this.keepConnectionsOpen.isPresent() || this.noRebindArgument.isPresent()) {
                    connection = connectionFactory.getConnection();
                    connection.addConnectionEventListener((ConnectionEventListener)this);
                    connections.add(connection);
                }
                for (int j = 0; j < this.numThreads; ++j) {
                    WorkerThread thread = this.newWorkerThread(connection, connectionFactory);
                    this.workerThreads.add(thread);
                    thread.start();
                }
            }
            if (this.maxDurationTimeMs > 0L) {
                this.newEndTimerThread(this.maxDurationTimeMs).start();
            }
            this.statsThread.startReporting();
            this.joinAllWorkerThreads();
            this.stopTool();
        }
        catch (InterruptedException e) {
            this.stopTool(true);
        }
        catch (LdapException e) {
            this.stopTool(true);
            Utils.printErrorMessage(this.app, e);
            int n = e.getResult().getResultCode().intValue();
            return n;
        }
        finally {
            org.forgerock.util.Utils.closeSilently(connections);
        }
        return 0;
    }

    private void validateCanConnectToServer(ConnectionFactory connectionFactory) throws LdapException {
        connectionFactory.getConnection().close();
    }

    synchronized void stopTool() {
        this.stopTool(false);
    }

    synchronized void stopTool(boolean stoppedByError) {
        if (!this.stopRequested) {
            this.stopRequested = true;
            this.statsThread.stopRecording(stoppedByError);
        }
    }

    void setBindRequest(BindRequest request) {
        this.bindRequest = request;
    }

    protected void joinAllWorkerThreads() throws InterruptedException {
        for (Thread t : this.workerThreads) {
            t.join();
        }
    }

    double[] getPercentiles() {
        if (this.percentilesArgument.isPresent()) {
            double[] percentiles = new double[this.percentilesArgument.getValues().size()];
            int index = 0;
            for (String percentile : this.percentilesArgument.getValues()) {
                percentiles[index++] = Double.parseDouble(percentile);
            }
            Arrays.sort(percentiles);
            return percentiles;
        }
        return DEFAULT_PERCENTILES;
    }

    long getWarmUpDurationMs() {
        return this.warmUpDurationMs;
    }

    long getStatsInterval() {
        return this.statsIntervalMs;
    }

    abstract class WorkerThread
    extends Thread {
        private int count;
        private final Connection connection;
        private final ConnectionFactory connectionFactory;
        boolean localStopRequested;

        WorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            super("Worker Thread");
            this.connection = connection;
            this.connectionFactory = connectionFactory;
        }

        public abstract Promise<?, LdapException> performOperation(Connection var1, DataSource[] var2, long var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            double targetTimeMs = 1000.0 / ((double)PerformanceRunner.this.targetThroughput / (double)(PerformanceRunner.this.numThreads * PerformanceRunner.this.numConnections));
            double sleepTimeMs = 0.0;
            while (!PerformanceRunner.this.stopRequested) {
                long oneMinuteMs;
                long startTimeNs;
                block16: {
                    Connection connection;
                    if (this.localStopRequested) return;
                    if (PerformanceRunner.this.maxIterations > 0) {
                        if (this.count >= PerformanceRunner.this.maxIterations) return;
                    }
                    try {
                        connection = this.getConnectionToUse();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (LdapException e) {
                        PerformanceRunner.this.handleConnectionError(false, e);
                        return;
                    }
                    startTimeNs = System.nanoTime();
                    Promise<?, LdapException> promise = this.performOperation(connection, (DataSource[])PerformanceRunner.this.dataSources.get(), startTimeNs);
                    PerformanceRunner.this.statsThread.incrementOperationCount();
                    try {
                        promise.getOrThrow();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (LdapException e) {
                        if (!PerformanceRunner.this.stopRequested && e.getCause() instanceof IOException) {
                            e.getCause().printStackTrace(PerformanceRunner.this.app.getErrorStream());
                            PerformanceRunner.this.stopTool(true);
                            return;
                        }
                    }
                    finally {
                        if (this.connection != null) continue;
                        connection.close();
                        continue;
                    }
                    if (PerformanceRunner.this.targetThroughput <= 0) continue;
                    try {
                        if (!(sleepTimeMs > 1.0)) break block16;
                        WorkerThread.sleep((long)Math.floor(sleepTimeMs));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                if (!((sleepTimeMs += targetTimeMs - (double)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)) + (double)(oneMinuteMs = TimeUnit.MINUTES.toMillis(1L)) < 0.0)) continue;
                sleepTimeMs = -oneMinuteMs;
            }
        }

        private Connection getConnectionToUse() throws InterruptedException, LdapException {
            if (this.connection == null) {
                return (Connection)this.connectionFactory.getConnectionAsync().getOrThrow();
            }
            Connection resultConnection = this.connection;
            if (!PerformanceRunner.this.noRebind && PerformanceRunner.this.bindRequest != null) {
                resultConnection.bindAsync(PerformanceRunner.this.bindRequest).getOrThrow();
            }
            return resultConnection;
        }

        void incrementIterationCount() {
            ++this.count;
        }
    }

    class UpdateStatsResultHandler<S extends Result>
    implements LdapResultHandler<S> {
        protected final long operationStartTimeNs;

        UpdateStatsResultHandler(long currentTimeNs) {
            this.operationStartTimeNs = currentTimeNs;
        }

        public final void handleException(LdapException exception) {
            PerformanceRunner.this.statsThread.incrementFailedCount();
            this.updateResponseTime();
            PerformanceRunner.this.app.errPrintVerboseMessage(LocalizableMessage.raw((CharSequence)exception.getResult().toString(), (Object[])new Object[0]));
        }

        public final void handleResult(S result) {
            PerformanceRunner.this.statsThread.incrementSuccessCount();
            this.updateResponseTime();
            this.updateAdditionalStatsOnResult();
        }

        void updateAdditionalStatsOnResult() {
        }

        private void updateResponseTime() {
            PerformanceRunner.this.statsThread.addResponseTime(System.nanoTime() - this.operationStartTimeNs);
        }
    }

    class TimerThread
    extends Thread {
        private final long timeToWait;

        TimerThread(long timeToWait) {
            this.timeToWait = timeToWait;
        }

        void performStopOperations() {
            PerformanceRunner.this.stopTool();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeToWait);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.performStopOperations();
            }
        }
    }
}

