/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDIFSearch
extends ToolConsoleApplication {
    public static void main(String[] args) {
        Utils.runToolAndExit(new LDIFSearch(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDIFSearch(out, err), args);
    }

    @VisibleForTesting
    LDIFSearch(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        SearchRequest search;
        IntegerArgument wrapColumn;
        IntegerArgument timeLimit;
        IntegerArgument sizeLimit;
        BooleanArgument typesOnly;
        MultiChoiceArgument searchScope;
        StringArgument baseDN;
        StringArgument outputFilename;
        LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDIFSearch.class.getName()).toolDescription(ToolsMessages.INFO_LDIFSEARCH_TOOL_DESCRIPTION.get()).trailingArgumentsUnbounded(2, "source filter [attributes ...]").build();
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFSEARCH.get());
        try {
            outputFilename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"outputLDIF").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_LDIFSEARCH_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()))).defaultValue((Object)"stdout")).valuePlaceholder(ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_LDIFSEARCH_DESCRIPTION_BASEDN.get())).defaultValue((Object)"")).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            searchScope = CommonArguments.searchScopeArgument();
            argParser.addArgument((Argument)searchScope);
            typesOnly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"typesOnly").shortIdentifier(Character.valueOf('A'))).description(ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get())).buildAndAddToParser((ArgumentParser)argParser);
            sizeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"sizeLimit").shortIdentifier(Character.valueOf('z'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            timeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"timeLimit").shortIdentifier(Character.valueOf('l'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
            wrapColumn = CommonArguments.wrapColumnArgument();
            argParser.addArgument((Argument)wrapColumn);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
        }
        Utils.parseArguments(argParser, this.getErrorStream(), args);
        if (argParser.usageOrVersionDisplayed()) {
            return ResultCode.SUCCESS.intValue();
        }
        ArrayList trailingArguments = argParser.getTrailingArguments();
        Filter filter = Utils.readFilterFromString((String)trailingArguments.get(1));
        LinkedList attributes = new LinkedList();
        if (trailingArguments.size() > 2) {
            attributes.addAll(trailingArguments.subList(2, trailingArguments.size()));
        }
        try {
            SearchScope scope = (SearchScope)searchScope.getTypedValue();
            search = Requests.newSearchRequest((DN)DN.valueOf((String)baseDN.getValue()), (SearchScope)scope, (Filter)filter, (String[])attributes.toArray(new String[attributes.size()])).setTypesOnly(typesOnly.isPresent()).setTimeLimit(timeLimit.getIntValue()).setSizeLimit(sizeLimit.getIntValue());
        }
        catch (ArgumentException | LocalizedIllegalArgumentException e) {
            throw LDAPToolException.newToolParamException((Exception)e, ((LocalizableException)e).getMessageObject());
        }
        try (LDIFEntryReader sourceReader = new LDIFEntryReader(Utils.getLDIFToolInputStream(this, (String)trailingArguments.get(0)));
             LDIFEntryWriter outputWriter = new LDIFEntryWriter(Utils.getLDIFToolOutputStream(this, outputFilename));){
            outputWriter.setWrapColumn(Utils.computeWrapColumn(wrapColumn));
            LDIF.copyTo((EntryReader)LDIF.search((EntryReader)sourceReader, (SearchRequest)search), (EntryWriter)outputWriter);
        }
        catch (LdapException e) {
            throw LDAPToolException.newToolException((Exception)((Object)e), e.getResult().getResultCode(), ToolsMessages.ERR_LDIFSEARCH_FAILED.get((Object)e.getLocalizedMessage()));
        }
        catch (IOException e) {
            throw LDAPToolException.newToolException(e, ResultCode.CLIENT_SIDE_LOCAL_ERROR, ToolsMessages.ERR_LDIFSEARCH_FAILED.get(e instanceof LocalizableException ? ((LocalizableException)e).getMessageObject() : e.getLocalizedMessage()));
        }
        catch (ArgumentException ae) {
            throw LDAPToolException.newToolParamException((Exception)((Object)ae), ae.getMessageObject());
        }
        return ResultCode.SUCCESS.intValue();
    }
}

