/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.LDAPToolArgumentParser;
import com.forgerock.opendj.ldap.tools.LDAPToolException;
import com.forgerock.opendj.ldap.tools.ToolConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.PrintStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LDAPPasswordModify
extends ToolConsoleApplication {
    private BooleanArgument verbose;

    public static void main(String[] args) {
        Utils.runToolAndExit(new LDAPPasswordModify(System.out, System.err), args);
    }

    public static int run(PrintStream out, PrintStream err, String ... args) {
        return Utils.runTool(new LDAPPasswordModify(out, err), args);
    }

    @VisibleForTesting
    LDAPPasswordModify(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    @Override
    int run(String ... args) throws LDAPToolException {
        int n;
        block21: {
            StringArgument controlStr;
            StringArgument proxyAuthzID;
            FileBasedArgument currentPWFile;
            StringArgument currentPW;
            FileBasedArgument newPWFile;
            StringArgument newPW;
            ConnectionFactoryProvider connectionFactoryProvider;
            LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPPWMOD_TOOL_DESCRIPTION.get();
            LDAPToolArgumentParser argParser = LDAPToolArgumentParser.builder(LDAPPasswordModify.class.getName()).toolDescription(toolDescription).needAuthenticatedConnectionFactory().build();
            argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
            argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPPASSWORDMODIFY.get());
            try {
                connectionFactoryProvider = new ConnectionFactoryProvider((ArgumentParser)argParser, (ConsoleApplication)this);
                StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
                argParser.addArgument((Argument)propertiesFileArgument);
                argParser.setFilePropertiesArgument(propertiesFileArgument);
                BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
                argParser.addArgument((Argument)noPropertiesFileArgument);
                argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
                newPW = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"newPassword").shortIdentifier(Character.valueOf('n'))).description(ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPW.get())).valuePlaceholder(ToolsMessages.INFO_NEW_PASSWORD_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                newPWFile = (FileBasedArgument)((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder((String)"newPasswordFile").shortIdentifier(Character.valueOf('F'))).description(ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_NEWPWFILE.get())).valuePlaceholder(CliMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                currentPW = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"currentPassword").shortIdentifier(Character.valueOf('c'))).description(ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPW.get())).valuePlaceholder(ToolsMessages.INFO_CURRENT_PASSWORD_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                currentPWFile = (FileBasedArgument)((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder((String)"currentPasswordFile").shortIdentifier(Character.valueOf('C'))).description(ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_CURRENTPWFILE.get())).valuePlaceholder(CliMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                proxyAuthzID = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"authzID").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_LDAPPWMOD_DESCRIPTION_AUTHZID.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser((ArgumentParser)argParser);
                controlStr = CommonArguments.controlArgument();
                argParser.addArgument((Argument)controlStr);
                this.verbose = CommonArguments.verboseArgument();
                argParser.addArgument((Argument)this.verbose);
                BooleanArgument showUsage = CommonArguments.showUsageArgument();
                argParser.addArgument((Argument)showUsage);
                argParser.setUsageArgument((Argument)showUsage, this.getOutputStream());
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            argParser.parseArgumentsNoBindRequest(args, this.getErrStream(), connectionFactoryProvider);
            if (argParser.usageOrVersionDisplayed()) {
                return ResultCode.SUCCESS.intValue();
            }
            PasswordModifyExtendedRequest request = Requests.newPasswordModifyExtendedRequest();
            Utils.addControlsToRequest((Request)request, Utils.readControls(controlStr));
            try {
                com.forgerock.opendj.cli.Utils.throwIfArgumentsConflict((Argument)newPW, (Argument)newPWFile);
                com.forgerock.opendj.cli.Utils.throwIfArgumentsConflict((Argument)currentPW, (Argument)currentPWFile);
            }
            catch (ArgumentException e) {
                throw LDAPToolException.newToolParamException((Exception)((Object)e), e.getMessageObject());
            }
            Connection connection = argParser.getConnectionFactory().getConnection();
            try {
                if (proxyAuthzID.isPresent()) {
                    request.setUserIdentity((Object)proxyAuthzID.getValue());
                }
                if (currentPW.isPresent()) {
                    request.setOldPassword(currentPW.getValue().toCharArray());
                } else if (currentPWFile.isPresent()) {
                    request.setOldPassword(currentPWFile.getValue().toCharArray());
                }
                if (newPW.isPresent()) {
                    request.setNewPassword(newPW.getValue().toCharArray());
                } else if (newPWFile.isPresent()) {
                    request.setNewPassword(newPWFile.getValue().toCharArray());
                }
                PasswordModifyExtendedResult result = (PasswordModifyExtendedResult)connection.extendedRequest((ExtendedRequest)request);
                this.println(ToolsMessages.INFO_LDAPPWMOD_SUCCESSFUL.get());
                Utils.printlnTextMsg(this, ToolsMessages.INFO_LDAPPWMOD_ADDITIONAL_INFO, result.getDiagnosticMessage());
                if (result.getGeneratedPassword() != null) {
                    this.println(ToolsMessages.INFO_LDAPPWMOD_GENERATED_PASSWORD.get((Object)ByteString.valueOfBytes((byte[])result.getGeneratedPassword()).toString()));
                }
                n = ResultCode.SUCCESS.intValue();
                if (connection == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LdapException e) {
                    return Utils.printErrorMessage((ConsoleApplication)this, e, ToolsMessages.ERR_LDAPPWMOD_FAILED);
                }
            }
            connection.close();
        }
        return n;
    }
}

