/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jms;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.forgerock.audit.handlers.jms.JmsAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.jms.JmsContextManager;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JndiJmsContextManager
implements JmsContextManager {
    private static final Logger logger = LoggerFactory.getLogger(JndiJmsContextManager.class);
    private Topic topic;
    private ConnectionFactory connectionFactory;
    private final InitialContext context;
    private final JmsAuditEventHandlerConfiguration.JndiConfiguration jndiConfiguration;

    JndiJmsContextManager(JmsAuditEventHandlerConfiguration.JndiConfiguration configuration) throws ResourceException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.jndiConfiguration = configuration;
            this.context = new InitialContext(new Hashtable<String, String>(configuration.getContextProperties()));
        }
        catch (NamingException e) {
            throw new InternalServerErrorException("Encountered issue building initial JNDI context", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    @Override
    public Topic getTopic() throws InternalServerErrorException {
        try {
            if (this.topic == null) {
                this.topic = this.getObject(this.jndiConfiguration.getTopicName(), Topic.class);
            }
            return this.topic;
        }
        catch (NamingException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ConnectionFactory getConnectionFactory() throws InternalServerErrorException {
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = this.getObject(this.jndiConfiguration.getConnectionFactoryName(), ConnectionFactory.class);
            }
            return this.connectionFactory;
        }
        catch (NamingException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    private <T> T getObject(String jndiName, Class<T> clazz) throws NamingException, InternalServerErrorException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Object object = this.context.lookup(jndiName);
            if (clazz.isInstance(object)) {
                Object object2 = object;
                return (T)object2;
            }
            String error = null == object ? String.format("No Object was found at JNDI name '%s'", jndiName) : String.format("JNDI lookup('%s') did not return a '%s'. It returned a '%s'='%s'", jndiName, clazz.getCanonicalName(), object.getClass().getCanonicalName(), object.toString());
            logger.error(error);
            throw new InternalServerErrorException(error);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }
}

