/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.util;

import com.persistit.util.SequencerConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;

public class ThreadSequencer
implements SequencerConstants {
    private static final DisabledSequencer DISABLED_SEQUENCER = new DisabledSequencer();
    private static final EnabledSequencer ENABLED_SEQUENCER = new EnabledSequencer();
    private static volatile Sequencer _sequencer = DISABLED_SEQUENCER;
    private static final List<String> LOCATIONS = new ArrayList<String>();
    private static final List<Condition> CONDITIONS = new ArrayList<Condition>();
    private static final int MAX_LOCATIONS = 64;

    public static synchronized int allocate(String locationName) {
        for (String alreadyRegistered : LOCATIONS) {
            assert (!alreadyRegistered.equals(locationName)) : "Location name " + locationName + " is already in use";
        }
        int value = LOCATIONS.size();
        assert (value < 64) : "Too many ThreadSequence locations";
        LOCATIONS.add(locationName);
        CONDITIONS.add(new Condition());
        return value;
    }

    public static void sequence(int location) {
        _sequencer.sequence(location);
    }

    public static void enableSequencer(boolean history) {
        ENABLED_SEQUENCER.clear();
        if (history) {
            ThreadSequencer.ENABLED_SEQUENCER.enableHistory();
        }
        _sequencer = ENABLED_SEQUENCER;
    }

    public static void disableSequencer() {
        _sequencer = DISABLED_SEQUENCER;
        ENABLED_SEQUENCER.clear();
    }

    public static void addSchedule(int[] awaitLocations, int[] releaseLocations) {
        ENABLED_SEQUENCER.addSchedule(ThreadSequencer.bits(awaitLocations), ThreadSequencer.bits(releaseLocations));
    }

    public static void addSchedules(int[][] pairs) {
        for (int index = 0; index < pairs.length; index += 2) {
            ThreadSequencer.addSchedule(pairs[index], pairs[index + 1]);
        }
    }

    public static void setCondition(int location, Condition condition) {
        CONDITIONS.set(location, condition);
    }

    public static String sequencerHistory() {
        return ENABLED_SEQUENCER.history();
    }

    public static int[] rawSequenceHistoryCopy() {
        return ENABLED_SEQUENCER.rawHistoryCopy();
    }

    public static void appendHistoryElement(StringBuilder sb, int location) {
        if (location < 64) {
            sb.append('+');
            sb.append(LOCATIONS.get(location));
        } else if ((location = ThreadSequencer.out(location)) < 64) {
            sb.append('-');
            sb.append(LOCATIONS.get(location));
        }
    }

    public static String describeHistory(int[] history) {
        StringBuilder sb = new StringBuilder();
        if (history != null) {
            int[] nArray = history;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer location = nArray[i];
                if (sb.length() > 0) {
                    sb.append(',');
                }
                ThreadSequencer.appendHistoryElement(sb, location);
            }
        }
        return sb.toString();
    }

    public static String describePartialOrdering(int[] ... args) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append('{');
            for (int location : args[i]) {
                ThreadSequencer.appendHistoryElement(builder, location);
            }
            builder.append('}');
        }
        return builder.toString();
    }

    public static boolean historyMeetsPartialOrdering(int[] history, int[] ... partialOrderings) {
        int offset = 0;
        for (int[] subset : partialOrderings) {
            Arrays.sort(subset);
            int nextOffset = offset + subset.length;
            if (nextOffset > history.length) {
                return false;
            }
            Arrays.sort(history, offset, nextOffset);
            for (int i = 0; i < subset.length; ++i) {
                if (subset[i] == history[offset + i]) continue;
                return false;
            }
            offset = nextOffset;
        }
        return true;
    }

    public static int[] array(int ... args) {
        return args;
    }

    public static int out(int location) {
        return Integer.MAX_VALUE - location;
    }

    private static long bits(int[] locations) {
        long bits = 0L;
        for (int location : locations) {
            assert (location >= 0 && location < 64) : "Location must be between 0 and 63, inclusive";
            bits |= 1L << location;
        }
        return bits;
    }

    private static class EnabledSequencer
    implements Sequencer {
        private final List<Long> _schedule = new ArrayList<Long>();
        private final Semaphore[] _semaphores = new Semaphore[64];
        private long _waiting = 0L;
        private long _enabled = 0L;
        private final int[] _waitingCount = new int[64];
        private List<Integer> _history;

        private EnabledSequencer() {
            for (int index = 0; index < this._semaphores.length; ++index) {
                this._semaphores[index] = new Semaphore(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sequence(int location) {
            assert (location >= 0 && location < 64) : "Location must be between 0 and 63, inclusive";
            Semaphore semaphore = null;
            if (!((Condition)CONDITIONS.get(location)).enabled()) {
                return;
            }
            EnabledSequencer enabledSequencer = this;
            synchronized (enabledSequencer) {
                int index;
                if ((this._enabled & 1L << location) == 0L) {
                    return;
                }
                this._waiting |= 1L << location;
                int n = location;
                this._waitingCount[n] = this._waitingCount[n] + 1;
                semaphore = this._semaphores[location];
                long release = 0L;
                for (index = 0; index < this._schedule.size(); index += 2) {
                    long await = this._schedule.get(index);
                    if ((this._waiting & await) != await) continue;
                    release = this._schedule.get(index + 1);
                    break;
                }
                for (index = 0; index < 64; ++index) {
                    if ((release & 1L << index) == 0L) continue;
                    if (location == index) {
                        semaphore = null;
                        continue;
                    }
                    this._semaphores[index].release();
                }
                if (this._history != null) {
                    this._history.add(location);
                }
            }
            if (semaphore != null) {
                try {
                    semaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            enabledSequencer = this;
            synchronized (enabledSequencer) {
                if (this._history != null) {
                    this._history.add(ThreadSequencer.out(location));
                }
                int n = location;
                this._waitingCount[n] = this._waitingCount[n] - 1;
                if (this._waitingCount[n] == 0) {
                    this._waiting &= 1L << location ^ 0xFFFFFFFFFFFFFFFFL;
                }
            }
        }

        @Override
        public synchronized void clear() {
            this._schedule.clear();
            this._waiting = 0L;
            this._enabled = 0L;
            this._history = null;
            for (int index = 0; index < this._semaphores.length; ++index) {
                this._semaphores[index].release(1000);
                this._semaphores[index] = new Semaphore(0);
            }
        }

        @Override
        public synchronized void addSchedule(long await, long release) {
            for (int index = 0; index < this._schedule.size(); index += 2) {
                long current = this._schedule.get(index);
                assert ((current & await) != current) : "Schedules may not overlap";
                assert ((current & await) != await) : "Schedules may not overlap";
                assert ((await & release) != 0L) : "No thread is released";
            }
            this._schedule.add(await);
            this._schedule.add(release);
            this._enabled |= release;
        }

        private void enableHistory() {
            this._history = new ArrayList<Integer>();
        }

        public synchronized String history() {
            String desc = "";
            if (this._history != null) {
                int[] copy = this.rawHistoryCopy();
                desc = ThreadSequencer.describeHistory(copy);
                this._history.clear();
            }
            return desc;
        }

        public synchronized int[] rawHistoryCopy() {
            int[] historyCopy = null;
            if (this._history != null) {
                historyCopy = new int[this._history.size()];
                for (int i = 0; i < this._history.size(); ++i) {
                    historyCopy[i] = this._history.get(i);
                }
            }
            return historyCopy;
        }
    }

    private static class DisabledSequencer
    implements Sequencer {
        private DisabledSequencer() {
        }

        @Override
        public void sequence(int location) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void addSchedule(long await, long release) {
        }
    }

    static interface Sequencer {
        public void sequence(int var1);

        public void clear();

        public void addSchedule(long var1, long var3);
    }

    public static class Condition {
        public boolean enabled() {
            return true;
        }
    }
}

