/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.util;

import com.persistit.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;

public class Debug {
    public static final boolean ENABLED = false;
    public static final boolean VERIFY_PAGES = false;
    public static final Random RANDOM = new Random(123L);
    private static final AtomicLong PAUSES = new AtomicLong();
    public static Dbg $assert0 = new Null();
    public static Dbg $assert1 = new Assert("assert1");
    private static int _suspendedCount;
    private static ArrayList<Thread> _brokenThreads;
    private static long _startTime;

    public static void setStartTime(long startTime) {
        _startTime = startTime;
    }

    public static long elapsedTime() {
        return Debug.now() - _startTime;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    private static void logDebugMessage(String msg) {
        RuntimeException exception = new RuntimeException();
        exception.fillInStackTrace();
        String s = Debug.asString(exception).replace('\r', ' ');
        StringTokenizer st = new StringTokenizer(s, "\n");
        StringBuilder sb = new StringBuilder(msg);
        sb.append(Util.NEW_LINE);
        while (st.hasMoreTokens()) {
            sb.append("    ");
            sb.append(st.nextToken());
            sb.append(Util.NEW_LINE);
        }
        System.err.println("Debug " + sb.toString());
    }

    public static String trace(int from, int to) {
        return " " + Thread.currentThread().getName() + " {" + Debug.callStack(from + 2, to + 2) + "}";
    }

    public static String callStack(int from, int to) {
        RuntimeException exception = new RuntimeException();
        exception.fillInStackTrace();
        StackTraceElement[] elements = exception.getStackTrace();
        int a = Math.max(0, from);
        int b = Math.min(to, elements.length);
        StringBuilder sb = new StringBuilder();
        for (int index = b; index >= a; --index) {
            StackTraceElement t = exception.getStackTrace()[index];
            if (index != b) {
                sb.append("->");
            }
            sb.append(t.getClassName());
            sb.append('#');
            sb.append(t.getMethodName());
            sb.append('[');
            sb.append(t.getLineNumber());
            sb.append("]");
        }
        return sb.toString();
    }

    static synchronized void setSuspended(boolean b) {
        if (b) {
            ++_suspendedCount;
            _brokenThreads.add(Thread.currentThread());
        } else {
            _brokenThreads.remove(Thread.currentThread());
            if (--_suspendedCount == 0) {
                $assert1.t(_brokenThreads.size() == _suspendedCount);
            }
        }
    }

    static synchronized boolean isSuspended() {
        return _suspendedCount > 0;
    }

    public static boolean suspend() {
        return true;
    }

    public static String asString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void debugPause(float probability, long millis) {
        if (RANDOM.nextInt(1000000000) < (int)(1.0E9f * probability)) {
            try {
                Thread.sleep(millis);
                PAUSES.incrementAndGet();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        _brokenThreads = new ArrayList();
    }

    private static class Assert
    implements Dbg {
        private final String _name;

        private Assert(String name) {
            this._name = name;
        }

        @Override
        public void t(boolean b) {
            if (!b) {
                Debug.logDebugMessage(this._name);
                Debug.setSuspended(true);
                Debug.setSuspended(false);
            }
        }
    }

    private static class Null
    implements Dbg {
        private Null() {
        }

        @Override
        public void t(boolean b) {
        }
    }

    public static interface Dbg {
        public void t(boolean var1);
    }
}

