/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.logging;

import com.persistit.logging.LogBase;
import com.persistit.logging.PersistitLevel;
import com.persistit.logging.PersistitLogger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PersistitLogMessage {
    public static LogItem empty() {
        return new LogDispatchHandler();
    }

    static String throwableFormatter(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        StringBuffer sb = sw.getBuffer();
        int p = -1;
        while ((p = sb.indexOf("\n", p + 1)) >= 0) {
            sb.insert(p + 1, "    ");
        }
        return sb.toString();
    }

    static class Enabled
    implements LogItem {
        private final PersistitLogger _logger;
        private final PersistitLevel _level;
        private final String _message;

        Enabled(PersistitLogger logger, PersistitLevel level, String message) {
            this._logger = logger;
            this._level = level;
            this._message = message;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public String logMessage(Object ... args) {
            StringBuilder sb = new StringBuilder(String.format("[%s] %s ", new Object[]{Thread.currentThread().getName(), this._level}));
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (!(args[i] instanceof RuntimeException)) continue;
                    args[i] = PersistitLogMessage.throwableFormatter((RuntimeException)args[i]);
                }
                sb.append(String.format(this._message, args));
            }
            catch (Exception e) {
                sb.append("Bad log message ");
                sb.append(this._message);
                sb.append(" [");
                for (int i = 0; i < args.length; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(args[i]);
                }
                sb.append("]");
            }
            return sb.toString();
        }

        @Override
        public void log(Object ... args) {
            this._logger.log(this._level, this.logMessage(args));
        }

        @Override
        public void logRecurring(int count, long duration, Object ... args) {
            if (count == 1) {
                this.log(args);
            } else {
                this._logger.log(this._level, LogBase.recurring(this.logMessage(args), count, duration));
            }
        }

        public PersistitLogger getLogger() {
            return this._logger;
        }

        @Override
        public PersistitLevel getLevel() {
            return this._level;
        }

        public String getMessage() {
            return this._message;
        }

        @Override
        public void configure(PersistitLogger logger, PersistitLevel level, String message) {
        }
    }

    static class Disabled
    implements LogItem {
        Disabled() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public String logMessage(Object ... args) {
            return null;
        }

        @Override
        public void log(Object ... args) {
        }

        @Override
        public void logRecurring(int count, long duration, Object ... args) {
        }

        @Override
        public PersistitLevel getLevel() {
            return PersistitLevel.NONE;
        }

        @Override
        public void configure(PersistitLogger logger, PersistitLevel level, String message) {
        }
    }

    static class LogDispatchHandler
    implements LogItem {
        private PersistitLogger _logger;
        private PersistitLevel _level;
        private LogItem _dispatch = new Disabled();

        LogDispatchHandler() {
        }

        @Override
        public void configure(PersistitLogger logger, PersistitLevel level, String message) {
            this._level = level;
            this._logger = logger;
            this._dispatch = this._logger.isLoggable(this._level) ? new Enabled(logger, level, message) : new Disabled();
        }

        @Override
        public boolean isEnabled() {
            return this._dispatch.isEnabled();
        }

        @Override
        public String logMessage(Object ... args) {
            return this._dispatch.logMessage(args);
        }

        @Override
        public void log(Object ... args) {
            this._dispatch.log(args);
        }

        @Override
        public void logRecurring(int count, long duration, Object ... args) {
            this._dispatch.logRecurring(count, duration, args);
        }

        public void disable() {
            this._dispatch = new Disabled();
        }

        public PersistitLogger getLogger() {
            return this._logger;
        }

        @Override
        public PersistitLevel getLevel() {
            return this._level;
        }
    }

    public static interface LogItem {
        public boolean isEnabled();

        public String logMessage(Object ... var1);

        public void log(Object ... var1);

        public void logRecurring(int var1, long var2, Object ... var4);

        public PersistitLevel getLevel();

        public void configure(PersistitLogger var1, PersistitLevel var2, String var3);
    }
}

