/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.Persistit;
import com.persistit.Volume;
import com.persistit.VolumeStorageT2;
import com.persistit.exception.InUseException;
import com.persistit.exception.PersistitException;
import java.io.File;

class VolumeStorageL2
extends VolumeStorageT2 {
    static final String LOCK_VOLUME_FILE_PREFIX = "persistit_lockvol_";
    private Buffer _headBuffer;

    VolumeStorageL2(Persistit persistit, Volume volume, File tempDirectory) {
        super(persistit, volume, tempDirectory);
    }

    @Override
    boolean isTemp() {
        return false;
    }

    @Override
    void truncate() throws PersistitException {
        if (!this.claim(true, 0L)) {
            throw new InUseException("Unable to acquire claim on " + this);
        }
        try {
            this._headBuffer = this._volume.getStructure().getPool().get(this._volume, 0L, true, false);
            this._headBuffer.init(32);
            this._headBuffer.setFixed();
            this.truncateInternal();
            this.releaseHeadBuffer();
        }
        finally {
            this.release();
        }
    }

    @Override
    void claimHeadBuffer() throws PersistitException {
        if (!this._headBuffer.claim(true)) {
            throw new InUseException("Unable to acquire claim on " + this._headBuffer);
        }
    }

    @Override
    void releaseHeadBuffer() {
        this._headBuffer.release();
    }
}

