/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Buffer;
import com.persistit.BufferPool;
import com.persistit.CleanupManager;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.KeyHistogram;
import com.persistit.LongRecordHelper;
import com.persistit.MVV;
import com.persistit.Persistit;
import com.persistit.ReadOnlyExchange;
import com.persistit.ReentrantResourceHolder;
import com.persistit.Transaction;
import com.persistit.TransactionIndex;
import com.persistit.TransactionStatus;
import com.persistit.Tree;
import com.persistit.Value;
import com.persistit.ValueHelper;
import com.persistit.Volume;
import com.persistit.VolumeStructure;
import com.persistit.exception.CorruptVolumeException;
import com.persistit.exception.InUseException;
import com.persistit.exception.PersistitException;
import com.persistit.exception.PersistitInterruptedException;
import com.persistit.exception.ReadOnlyVolumeException;
import com.persistit.exception.RebalanceException;
import com.persistit.exception.RetryException;
import com.persistit.exception.RollbackException;
import com.persistit.exception.TreeNotFoundException;
import com.persistit.exception.VersionsOutOfOrderException;
import com.persistit.exception.WWRetryException;
import com.persistit.policy.JoinPolicy;
import com.persistit.policy.SplitPolicy;
import com.persistit.util.Debug;
import com.persistit.util.SequencerConstants;
import com.persistit.util.ThreadSequencer;
import com.persistit.util.Util;
import java.util.ArrayList;
import java.util.List;

public class Exchange
implements ReadOnlyExchange {
    static final int MAX_TREE_DEPTH = 20;
    static final int MAX_WALK_RIGHT = 50;
    private static final int LEFT_CLAIMED = 1;
    private static final int RIGHT_CLAIMED = 2;
    private static final int VERSIONS_OUT_OF_ORDER_RETRY_COUNT = 3;
    private Persistit _persistit;
    private final Key _key;
    private final Value _value;
    private final LevelCache[] _levelCache = new LevelCache[20];
    private BufferPool _pool;
    private Volume _volume;
    private Tree _tree;
    private long _timeoutMillis = 60000L;
    private volatile long _cachedTreeGeneration = -1L;
    private volatile int _cacheDepth = 0;
    private Key _spareKey1;
    private Key _spareKey2;
    private final Key _spareKey3;
    private final Key _spareKey4;
    private final Value _spareValue;
    private SplitPolicy _splitPolicy;
    private JoinPolicy _joinPolicy;
    private boolean _isDirectoryExchange = false;
    private Transaction _transaction;
    private boolean _ignoreTransactions;
    private boolean _ignoreMVCCFetch;
    private boolean _storeCausedSplit;
    private int _keysVisitedDuringTraverse;
    private Object _appCache;
    private ReentrantResourceHolder _treeHolder;
    private final MvvVisitor _mvvVisitor;
    private final ValueHelper.RawValueWriter _rawValueWriter = new ValueHelper.RawValueWriter();
    private final ValueHelper.MVVValueWriter _mvvValueWriter = new ValueHelper.MVVValueWriter();
    private LongRecordHelper _longRecordHelper;
    private volatile Thread _thread;

    Exchange(Persistit persistit) {
        this._persistit = persistit;
        this._key = new Key(this._persistit);
        this._spareKey1 = new Key(this._persistit);
        this._spareKey2 = new Key(this._persistit);
        this._spareKey3 = new Key(this._persistit);
        this._spareKey4 = new Key(this._persistit);
        this._value = new Value(this._persistit);
        this._spareValue = new Value(this._persistit);
        this._mvvVisitor = new MvvVisitor(this._persistit.getTransactionIndex(), this);
    }

    public Exchange(Persistit persistit, String volumeName, String treeName, boolean create) throws PersistitException {
        this(persistit, persistit.getVolume(volumeName), treeName, create);
    }

    public Exchange(Persistit persistit, Volume volume, String treeName, boolean create) throws PersistitException {
        this(persistit);
        if (volume == null) {
            throw new NullPointerException();
        }
        this.init(volume, treeName, create);
    }

    public Exchange(Exchange exchange) {
        this(exchange._persistit);
        this.init(exchange);
    }

    public Exchange(Tree tree) {
        this(tree._persistit);
        this.init(tree);
        this._volume = tree.getVolume();
        this._isDirectoryExchange = tree == this._volume.getDirectoryTree();
        this.initCache();
    }

    void init(Volume volume, String treeName, boolean create) throws PersistitException {
        if (volume == null) {
            throw new NullPointerException();
        }
        Tree tree = volume.getTree(treeName, create);
        if (tree == null) {
            throw new TreeNotFoundException(treeName);
        }
        this.init(tree);
    }

    void init(Tree tree) {
        this.assertCorrectThread(true);
        Volume volume = tree.getVolume();
        this._ignoreTransactions = volume.isTemporary();
        this._ignoreMVCCFetch = false;
        this._pool = volume.getStructure().getPool();
        this._transaction = this._persistit.getTransaction();
        this._key.clear();
        this._value.clear();
        if (this._volume != volume || this._tree != tree) {
            this._volume = volume;
            this._tree = tree;
            this._treeHolder = new ReentrantResourceHolder(this._tree);
            this._cachedTreeGeneration = -1L;
            this._isDirectoryExchange = tree == this._volume.getDirectoryTree();
            this.initCache();
        }
        this._splitPolicy = this._persistit.getDefaultSplitPolicy();
        this._joinPolicy = this._persistit.getDefaultJoinPolicy();
    }

    void init(Exchange exchange) {
        this.assertCorrectThread(true);
        this._persistit = exchange._persistit;
        this._volume = exchange._volume;
        this._ignoreTransactions = this._volume.isTemporary();
        this._ignoreMVCCFetch = false;
        this._tree = exchange._tree;
        this._treeHolder = new ReentrantResourceHolder(this._tree);
        this._pool = exchange._pool;
        this._cachedTreeGeneration = -1L;
        this._transaction = this._persistit.getTransaction();
        this._cacheDepth = exchange._cacheDepth;
        this.initCache();
        for (int index = 0; index < this._cacheDepth; ++index) {
            exchange._levelCache[index].copyTo(this._levelCache[index]);
        }
        exchange._key.copyTo(this._key);
        this.setMaximumValueSize(exchange._value.getMaximumSize());
        exchange._value.copyTo(this._value);
        this._splitPolicy = exchange._splitPolicy;
        this._joinPolicy = exchange._joinPolicy;
    }

    void removeState(boolean secure) {
        this.checkThread(false);
        this._key.clear(secure);
        this._value.clear(secure);
        this._spareKey1.clear(secure);
        this._spareKey2.clear(secure);
        this._spareValue.clear(secure);
        this._transaction = null;
        this._ignoreTransactions = false;
        this._ignoreMVCCFetch = false;
        this._splitPolicy = this._persistit.getDefaultSplitPolicy();
        this._joinPolicy = this._persistit.getDefaultJoinPolicy();
        this._treeHolder.verifyReleased();
    }

    public void initCache() {
        this.assertCorrectThread(true);
        for (int level = 0; level < 20; ++level) {
            if (this._levelCache[level] != null) {
                this._levelCache[level].invalidate();
                continue;
            }
            this._levelCache[level] = new LevelCache(level);
        }
    }

    private void checkLevelCache() throws PersistitException {
        if (!this._tree.isLive()) {
            if (this._tree.getVolume().isTemporary()) {
                this._tree = this._tree.getVolume().getTree(this._tree.getName(), true);
                this._treeHolder = new ReentrantResourceHolder(this._tree);
                this._cachedTreeGeneration = -1L;
            } else {
                throw new TreeNotFoundException();
            }
        }
        if (this._cachedTreeGeneration != this._tree.getGeneration()) {
            this._cachedTreeGeneration = this._tree.getGeneration();
            this._cacheDepth = this._tree.getDepth();
            for (int index = 0; index < 20; ++index) {
                LevelCache lc = this._levelCache[index];
                lc.invalidate();
            }
        }
    }

    public Exchange reset() {
        this.getKey().reset();
        return this;
    }

    public Exchange clear() {
        this.getKey().clear();
        return this;
    }

    public Exchange setDepth(int depth) {
        this.getKey().setDepth(depth);
        return this;
    }

    public Exchange cut(int level) {
        this.getKey().cut(level);
        return this;
    }

    public Exchange cut() {
        this.getKey().cut();
        return this;
    }

    public Exchange append(boolean item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(byte item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(short item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(char item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(int item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(long item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(float item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(double item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange append(Object item) {
        this.getKey().append(item);
        return this;
    }

    public Exchange to(boolean item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(byte item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(short item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(char item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(int item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(long item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(float item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(double item) {
        this.getKey().to(item);
        return this;
    }

    public Exchange to(Object item) {
        this.getKey().to(item);
        return this;
    }

    @Override
    public Key getKey() {
        this.assertCorrectThread(true);
        return this._key;
    }

    @Override
    public Value getValue() {
        this.assertCorrectThread(true);
        return this._value;
    }

    BufferPool getBufferPool() {
        return this._pool;
    }

    @Override
    public Volume getVolume() {
        this.assertCorrectThread(true);
        return this._volume;
    }

    @Override
    public Tree getTree() {
        this.assertCorrectThread(true);
        return this._tree;
    }

    @Override
    public Persistit getPersistitInstance() {
        this.assertCorrectThread(true);
        return this._persistit;
    }

    @Override
    public long getChangeCount() {
        this.assertCorrectThread(true);
        return this._tree.getChangeCount();
    }

    Key getAuxiliaryKey1() {
        return this._spareKey1;
    }

    Key getAuxiliaryKey3() {
        return this._spareKey3;
    }

    Key getAuxiliaryKey4() {
        return this._spareKey4;
    }

    Key getAuxiliaryKey2() {
        return this._spareKey2;
    }

    Value getAuxiliaryValue() {
        return this._spareValue;
    }

    boolean getStoreCausedSplit() {
        return this._storeCausedSplit;
    }

    int getKeysVisitedDuringTraverse() {
        return this._keysVisitedDuringTraverse;
    }

    public String toString() {
        return "Exchange(Volume=" + this._volume.getPath() + ",Tree=" + this._tree.getName() + ",,Key=<" + this._key.toString() + ">)";
    }

    private int search(Key key, boolean writer) throws PersistitException {
        Buffer buffer = null;
        this.checkLevelCache();
        LevelCache lc = this._levelCache[0];
        buffer = this.quicklyReclaimBuffer(lc, writer);
        if (buffer == null) {
            return this.searchTree(key, 0, writer);
        }
        this.checkPageType(buffer, 1, true);
        int foundAt = this.findKey(buffer, key, lc);
        if (buffer.isBeforeLeftEdge(foundAt) || buffer.isAfterRightEdge(foundAt)) {
            buffer.release();
            return this.searchTree(key, 0, writer);
        }
        return foundAt;
    }

    private int findKey(Buffer buffer, Key key, LevelCache lc) throws PersistitInterruptedException {
        int foundAt = lc._foundAt;
        if (foundAt != -1 && buffer.getGeneration() == lc._bufferGeneration && key == this._key && key.getGeneration() == lc._keyGeneration) {
            Debug.$assert0.t(buffer.findKey(key) == foundAt);
            return foundAt;
        }
        foundAt = buffer.findKey(key);
        lc.update(buffer, key, foundAt);
        return foundAt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchTree(Key key, int toLevel, boolean writer) throws PersistitException {
        long pageAddress;
        Buffer oldBuffer = null;
        int foundAt = -1;
        if (!this._treeHolder.claim(false)) {
            Debug.$assert0.t(false);
            throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to get reader claim on " + this._tree);
        }
        this.checkLevelCache();
        long oldPageAddress = pageAddress = this._tree.getRootPageAddr();
        Debug.$assert0.t(pageAddress != 0L);
        try {
            int currentLevel = this._cacheDepth;
            while (--currentLevel >= toLevel) {
                if (pageAddress <= 0L) {
                    this.corrupt("Volume " + this._volume + " level=" + currentLevel + " page=" + pageAddress + " oldPage=" + oldPageAddress + " key=<" + key.toString() + ">  invalid page address");
                }
                foundAt = this.searchLevel(key, false, pageAddress, currentLevel, writer && currentLevel == toLevel);
                if (oldBuffer != null) {
                    oldBuffer.releaseTouched();
                    oldBuffer = null;
                }
                LevelCache lc = this._levelCache[currentLevel];
                Buffer buffer = lc._buffer;
                if (buffer == null || buffer.isBeforeLeftEdge(foundAt)) {
                    oldBuffer = buffer;
                    this.corrupt("Volume " + this._volume + " level=" + currentLevel + " page=" + pageAddress + " key=<" + key.toString() + ">  is before left edge");
                }
                this.checkPageType(buffer, currentLevel + 1, true);
                if (currentLevel == toLevel) {
                    int level = currentLevel;
                    while (--level > 0) {
                        this._levelCache[level].invalidate();
                    }
                    level = foundAt;
                    return level;
                }
                if (buffer.isIndexPage()) {
                    int p = foundAt & 0xFFFC;
                    if ((foundAt & 1) == 0) {
                        p -= 4;
                    }
                    oldBuffer = buffer;
                    oldPageAddress = pageAddress;
                    pageAddress = buffer.getPointer(p);
                    Debug.$assert0.t(pageAddress > 0L && pageAddress < 0x7FFFFFFEL);
                    continue;
                }
                oldBuffer = buffer;
                this.corrupt("Volume " + this._volume + " level=" + currentLevel + " page=" + pageAddress + " key=<" + key.toString() + "> page type=" + buffer.getPageType() + " is invalid");
            }
            int n = -1;
            return n;
        }
        finally {
            if (oldBuffer != null) {
                oldBuffer.releaseTouched();
                oldBuffer = null;
            }
            this._treeHolder.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchLevel(Key key, boolean edge, long pageAddress, int currentLevel, boolean writer) throws PersistitException {
        Buffer oldBuffer = null;
        try {
            long initialPageAddress = pageAddress;
            long oldPageAddress = pageAddress;
            int rightWalk = 50;
            while (rightWalk-- > 0) {
                int foundAt;
                Buffer buffer = null;
                if (pageAddress <= 0L || pageAddress >= this._volume.getStorage().getNextAvailablePage()) {
                    this.corrupt("Volume " + this._volume + " level=" + currentLevel + " page=" + pageAddress + " previousPage=" + oldPageAddress + " initialPage=" + initialPageAddress + " key=<" + key.toString() + "> oldBuffer=<" + oldBuffer + "> invalid page address");
                }
                LevelCache lc = this._levelCache[currentLevel];
                if (lc._page == pageAddress) {
                    buffer = this.quicklyReclaimBuffer(lc, writer);
                }
                if (buffer == null) {
                    buffer = this._pool.get(this._volume, pageAddress, writer, true, this._timeoutMillis);
                }
                this.checkPageType(buffer, currentLevel + 1, true);
                if (oldBuffer != null) {
                    oldBuffer.releaseTouched();
                    oldBuffer = null;
                }
                if (pageAddress != lc._page) {
                    lc.invalidate();
                }
                if (!buffer.isAfterRightEdge(foundAt = this.findKey(buffer, key, lc)) || edge & (foundAt & 1) != 0) {
                    lc.update(buffer, key, foundAt);
                    int n = foundAt;
                    return n;
                }
                oldPageAddress = pageAddress;
                pageAddress = buffer.getRightSibling();
                Debug.$assert0.t(pageAddress > 0L && pageAddress < 0x7FFFFFFEL);
                oldBuffer = buffer;
            }
            this.corrupt("Volume " + this._volume + " level=" + currentLevel + " page=" + oldPageAddress + " initialPage=" + initialPageAddress + " key=<" + key.toString() + "> walked right more than " + 50 + " pages last page visited=" + pageAddress);
            int n = -1;
            return n;
        }
        finally {
            if (oldBuffer != null) {
                oldBuffer.releaseTouched();
            }
        }
    }

    int maxValueSize(int keySize) {
        int pageSize = this._volume.getPageSize();
        int reserveForKeys = 36 + Key.maxStorableKeySize(pageSize) * 2 + keySize;
        return (pageSize - 32 - reserveForKeys) / 2;
    }

    Exchange store(Key key, Value value) throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        if (this._volume.isReadOnly()) {
            throw new ReadOnlyVolumeException(this._volume.toString());
        }
        key.testValidForStoreAndFetch(this._volume.getPageSize());
        if (!this.isDirectoryExchange()) {
            this._persistit.checkSuspended();
        }
        this.throttle();
        int options = 8;
        this.storeInternal(key, value, 0, options |= !this._ignoreTransactions && this._transaction.isActive() ? 4 : 0);
        this._treeHolder.verifyReleased();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean storeInternal(Key key, Value value, int level, int options) throws PersistitException {
        block60: {
            doMVCC = (options & 4) > 0;
            doFetch = (options & 2) > 0;
            Debug.$assert0.t(key != this._spareKey1);
            this._storeCausedSplit = false;
            treeClaimRequired = false;
            treeClaimAcquired = false;
            treeWriterClaimRequired = false;
            committed = false;
            incrementMVVCount = false;
            maxSimpleValueSize = this.maxValueSize(key.getEncodedSize());
            spareValue = this._persistit.getThreadLocalValue();
            if (!Exchange.$assertionsDisabled && (doMVCC & value == spareValue || doFetch && value == this._spareValue)) {
                throw new AssertionError((Object)("storeInternal may use the supplied Value: " + value));
            }
            buffer = null;
            oldLongRecordPointer = 0L;
            oldLongRecordPointerMVV = 0L;
            newLongRecordPointer = 0L;
            newLongRecordPointerMVV = 0L;
            v0 = isLongRecord = value.getEncodedSize() > maxSimpleValueSize;
            if (isLongRecord) {
                newLongRecordPointer = this.getLongRecordHelper().storeLongRecord(value, this._transaction.isActive());
            }
            if (!this._ignoreTransactions && (options & 32) == 0) {
                this._transaction.store(this, key, value);
            }
            keyExisted = false;
            valueToStore = value;
            while (true) lbl-1000:
            // 7 sources

            {
                Debug.$assert0.t(buffer == null);
                oldLongRecordPointerMVV = 0L;
                if (!committed && newLongRecordPointerMVV != 0L) {
                    this._volume.getStructure().deallocateGarbageChain(newLongRecordPointerMVV, 0L);
                    newLongRecordPointerMVV = 0L;
                    spareValue.changeLongRecordMode(false);
                }
                if (treeClaimRequired && !treeClaimAcquired) {
                    if (!this._treeHolder.claim(treeWriterClaimRequired)) {
                        Debug.$assert0.t(false);
                        throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to get " + (treeWriterClaimRequired != false ? "writer" : "reader") + " claim on " + this._tree);
                    }
                    treeClaimAcquired = true;
                }
                this.checkLevelCache();
                prunedVersions = new ArrayList<MVV.PrunedVersion>();
                try {
                    if (level >= this._cacheDepth) {
                        Debug.$assert0.t(level == this._cacheDepth);
                        if (!treeClaimAcquired || !this._treeHolder.upgradeClaim()) {
                            treeClaimRequired = true;
                            treeWriterClaimRequired = true;
                            throw RetryException.SINGLE;
                        }
                        Debug.$assert0.t(valueToStore.getPointerValue() > 0L);
                        this.insertIndexLevel(key, valueToStore);
                        break block60;
                    }
                    Debug.$assert0.t(buffer == null);
                    foundAt = -1;
                    lc = this._levelCache[level];
                    buffer = this.quicklyReclaimBuffer(lc, true);
                    if (buffer != null && (buffer.isBeforeLeftEdge(foundAt = this.findKey(buffer, key, lc)) || buffer.isAfterRightEdge(foundAt))) {
                        buffer.release();
                        buffer = null;
                    }
                    if (buffer == null) {
                        foundAt = this.searchTree(key, level, true);
                        buffer = lc._buffer;
                    }
                    Debug.$assert0.t(buffer != null && (buffer.getStatus() & 32768) != 0 && (buffer.getStatus() & 32767) != 0);
                    didPrune = false;
                    splitRequired = false;
                    if (buffer.isDataPage()) {
                        v1 = keyExisted = (foundAt & 1) != 0;
                        if (keyExisted) {
                            oldLongRecordPointer = buffer.fetchLongRecordPointer(foundAt);
                        }
                        if (doFetch || doMVCC) {
                            buffer.fetch(foundAt, spareValue);
                            if (oldLongRecordPointer != 0L && this.isLongMVV(spareValue)) {
                                oldLongRecordPointerMVV = oldLongRecordPointer;
                                this.fetchFixupForLongRecords(spareValue, 0x7FFFFFFF);
                            }
                            oldLongRecordPointer = 0L;
                            if (doFetch) {
                                spareValue.copyTo(this._spareValue);
                                this.fetchFromValueInternal(this._spareValue, 0x7FFFFFFF, buffer);
                            }
                        }
                        if (doMVCC && (this._spareValue.isDefined() || !this._tree.isTransactionPrivate(true))) {
                            valueToStore = spareValue;
                            valueSize = value.getEncodedSize();
                            retries = 3;
                            while (true) {
                                block61: {
                                    try {
                                        spareBytes = spareValue.getEncodedBytes();
                                        if (keyExisted) {
                                            spareSize = MVV.prune(spareBytes, 0, spareValue.getEncodedSize(), this._persistit.getTransactionIndex(), false, prunedVersions);
                                            spareValue.setEncodedSize(spareSize);
                                        } else {
                                            spareSize = -1;
                                        }
                                        tStatus = this._transaction.getTransactionStatus();
                                        tStep = this._transaction.getStep();
                                        if ((options & 16) == 0) break block61;
                                        this._mvvVisitor.initInternal(tStatus, tStep, MvvVisitor.Usage.FETCH);
                                        MVV.visitAllVersions(this._mvvVisitor, spareBytes, 0, spareSize);
                                        offset = this._mvvVisitor.getOffset();
                                        if (this._mvvVisitor.foundVersion() && (this._mvvVisitor.getLength() <= 0 || spareBytes[offset] != 49)) break block61;
                                        keyExisted = false;
                                        break block60;
                                    }
                                    catch (VersionsOutOfOrderException e) {
                                        if (--retries > 0) continue;
                                        throw e;
                                    }
                                }
                                this._mvvVisitor.initInternal(tStatus, tStep, MvvVisitor.Usage.STORE);
                                MVV.visitAllVersions(this._mvvVisitor, spareBytes, 0, spareSize);
                                mvvSize = MVV.estimateRequiredLength(spareBytes, spareSize, valueSize);
                                spareValue.ensureFit(mvvSize);
                                spareBytes = spareValue.getEncodedBytes();
                                versionHandle = TransactionIndex.tss2vh(this._transaction.getStartTimestamp(), tStep);
                                storedLength = MVV.storeVersion(spareBytes, 0, spareSize, spareBytes.length, versionHandle, value.getEncodedBytes(), 0, valueSize);
                                incrementMVVCount = (storedLength & -2147483648) == 0;
                                spareValue.setEncodedSize(storedLength &= 0x7FFFFFFF);
                                Debug.$assert0.t(MVV.verify(this._persistit.getTransactionIndex(), spareBytes, 0, storedLength));
                                if (spareValue.getEncodedSize() <= maxSimpleValueSize) break;
                                newLongRecordPointerMVV = this.getLongRecordHelper().storeLongRecord(spareValue, this._transaction.isActive());
                                break;
                            }
                        }
                    }
                    Debug.$assert0.t(valueToStore.getEncodedSize() <= maxSimpleValueSize);
                    this._rawValueWriter.init(valueToStore);
                    splitRequired = this.putLevel(lc, key, this._rawValueWriter, buffer, foundAt, treeClaimAcquired);
                    Debug.$assert0.t((buffer.getStatus() & 32768) != 0 && (buffer.getStatus() & 32767) != 0);
                    if (splitRequired && !treeClaimAcquired) {
                        if (!didPrune && buffer.isDataPage()) {
                            didPrune = true;
                            if (buffer.pruneMvvValues(this._tree, false, null)) ** GOTO lbl-1000
                        }
                        treeClaimRequired = true;
                        buffer.releaseTouched();
                        buffer = null;
                    }
                    if (buffer.isDataPage()) {
                        if (!keyExisted) {
                            this._tree.bumpChangeCount();
                        }
                        if (!Exchange.$assertionsDisabled && !buffer.isDirty()) {
                            throw new AssertionError((Object)"Buffer must be dirty");
                        }
                        committed = true;
                        if (incrementMVVCount) {
                            this._transaction.getTransactionStatus().incrementMvvCount();
                        }
                        Buffer.deallocatePrunedVersions(this._persistit, this._volume, prunedVersions);
                    }
                    buffer.releaseTouched();
                    buffer = null;
                    if (splitRequired) {
                        Debug.$assert0.t(valueToStore.getPointerValue() > 0L);
                        key = this._spareKey1;
                        this._spareKey1 = this._spareKey2;
                        this._spareKey2 = key;
                        key.bumpGeneration();
                        ++level;
                    }
                    break block60;
                }
                catch (WWRetryException re) {
                    if (buffer != null) {
                        buffer.releaseTouched();
                        buffer = null;
                    }
                    if (treeClaimAcquired) {
                        this._treeHolder.release();
                        treeClaimAcquired = false;
                    }
                    try {
                        ThreadSequencer.sequence(SequencerConstants.WRITE_WRITE_STORE_A);
                        depends = this._persistit.getTransactionIndex().wwDependency(re.getVersionHandle(), this._transaction.getTransactionStatus(), this._timeoutMillis);
                        if (depends == 0L || depends == -9223372036854775808L) ** GOTO lbl-1000
                        this._transaction.rollback();
                        throw new RollbackException();
                    }
                    catch (InterruptedException ie) {
                        throw new PersistitInterruptedException(ie);
                    }
                }
                catch (RetryException re) {
                    if (buffer != null) {
                        buffer.releaseTouched();
                        buffer = null;
                    }
                    if (treeClaimAcquired) {
                        this._treeHolder.release();
                        treeClaimAcquired = false;
                    }
                    if (treeClaimAcquired = this._treeHolder.claim(true, (doWait = (options & 8) != 0) != false ? this._timeoutMillis : 0L)) ** GOTO lbl-1000
                    if (!doWait) {
                        throw re;
                    }
                    throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to get reader claim on " + this._tree);
                }
                finally {
                    if (buffer == null) continue;
                    buffer.releaseTouched();
                    buffer = null;
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (treeClaimAcquired) {
                    this._treeHolder.release();
                    treeClaimAcquired = false;
                }
                value.changeLongRecordMode(false);
                spareValue.changeLongRecordMode(false);
                if (!committed) {
                    if (newLongRecordPointer != oldLongRecordPointer && newLongRecordPointer != 0L) {
                        this._volume.getStructure().deallocateGarbageChain(newLongRecordPointer, 0L);
                    }
                    if (newLongRecordPointerMVV != 0L) {
                        this._volume.getStructure().deallocateGarbageChain(newLongRecordPointerMVV, 0L);
                    }
                } else {
                    if (oldLongRecordPointer != newLongRecordPointer && oldLongRecordPointer != 0L) {
                        this._volume.getStructure().deallocateGarbageChain(oldLongRecordPointer, 0L);
                    }
                    if (oldLongRecordPointerMVV != 0L) {
                        this._volume.getStructure().deallocateGarbageChain(oldLongRecordPointerMVV, 0L);
                    }
                }
            }
        }
        this._volume.getStatistics().bumpStoreCounter();
        this._tree.getStatistics().bumpStoreCounter();
        if (doFetch || doMVCC) {
            this._volume.getStatistics().bumpFetchCounter();
            this._tree.getStatistics().bumpFetchCounter();
        }
        return keyExisted;
    }

    private long timestamp() {
        return this._persistit.getTimestampAllocator().updateTimestamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIndexLevel(Key key, Value value) throws PersistitException {
        Buffer buffer = null;
        try {
            buffer = this._volume.getStructure().allocPage();
            long timestamp = this.timestamp();
            buffer.writePageOnCheckpoint(timestamp);
            buffer.init(2 + this._tree.getDepth() - 1);
            long newTopPage = buffer.getPageAddress();
            long leftSiblingPointer = this._tree.getRootPageAddr();
            Debug.$assert0.t(leftSiblingPointer == this._tree.getRootPageAddr());
            long rightSiblingPointer = value.getPointerValue();
            this._rawValueWriter.init(value);
            value.setPointerValue(leftSiblingPointer);
            buffer.putValue(Key.LEFT_GUARD_KEY, this._rawValueWriter);
            value.setPointerValue(rightSiblingPointer);
            buffer.putValue(key, this._rawValueWriter);
            value.setPointerValue(-1L);
            buffer.putValue(Key.RIGHT_GUARD_KEY, this._rawValueWriter);
            buffer.setDirtyAtTimestamp(timestamp);
            this._tree.changeRootPageAddr(newTopPage, 1);
            this._tree.bumpGeneration();
            this._volume.getStructure().updateDirectoryTree(this._tree);
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putLevel(LevelCache lc, Key key, ValueHelper valueWriter, Buffer buffer, int foundAt, boolean okToSplit) throws PersistitException {
        Debug.$assert0.t((buffer.getStatus() & 0x8000) != 0 && (buffer.getStatus() & Short.MAX_VALUE) != 0);
        Sequence sequence = lc.sequence(foundAt);
        long timestamp = this.timestamp();
        buffer.writePageOnCheckpoint(timestamp);
        int result = buffer.putValue(key, valueWriter, foundAt, false);
        if (result != -1) {
            buffer.setDirtyAtTimestamp(timestamp);
            lc.updateInsert(buffer, key, result);
            return false;
        }
        Debug.$assert0.t(buffer.getPageAddress() != this._volume.getStructure().getGarbageRoot());
        Buffer rightSibling = null;
        try {
            if (!okToSplit) {
                boolean bl = true;
                return bl;
            }
            this._storeCausedSplit = true;
            rightSibling = this._volume.getStructure().allocPage();
            timestamp = this.timestamp();
            buffer.writePageOnCheckpoint(timestamp);
            rightSibling.writePageOnCheckpoint(timestamp);
            Debug.$assert0.t(rightSibling.getPageAddress() != 0L);
            Debug.$assert0.t(rightSibling != buffer);
            rightSibling.init(buffer.getPageType());
            int at = buffer.split(rightSibling, key, valueWriter, foundAt, this._spareKey1, sequence, this._splitPolicy);
            if (at < 0) {
                lc.updateInsert(rightSibling, key, -at);
            } else {
                lc.updateInsert(buffer, key, at);
            }
            long oldRightSibling = buffer.getRightSibling();
            long newRightSibling = rightSibling.getPageAddress();
            Debug.$assert0.t(newRightSibling > 0L && oldRightSibling != newRightSibling);
            Debug.$assert0.t(rightSibling.getPageType() == buffer.getPageType());
            rightSibling.setRightSibling(oldRightSibling);
            buffer.setRightSibling(newRightSibling);
            valueWriter.setPointerValue(newRightSibling);
            rightSibling.setDirtyAtTimestamp(timestamp);
            buffer.setDirtyAtTimestamp(timestamp);
            boolean bl = true;
            return bl;
        }
        finally {
            if (rightSibling != null) {
                rightSibling.releaseTouched();
            }
        }
    }

    private Buffer quicklyReclaimBuffer(LevelCache lc, boolean writer) throws PersistitException {
        Buffer buffer = lc._buffer;
        if (buffer == null) {
            return null;
        }
        boolean available = buffer.claim(writer, 0L);
        if (available) {
            if (buffer.getPageAddress() == lc._page && buffer.getVolume() == this._volume && this._cachedTreeGeneration == this._tree.getGeneration() && buffer.getGeneration() == lc._bufferGeneration && buffer.isValid()) {
                return buffer;
            }
            buffer.release();
        }
        return null;
    }

    public boolean traverse(Key.Direction direction, boolean deep) throws PersistitException {
        boolean result = this.traverse(direction, deep, Integer.MAX_VALUE);
        return result;
    }

    public boolean traverse(Key.Direction direction, boolean deep, int minimumBytes) throws PersistitException {
        return this.traverse(direction, deep, minimumBytes, 0, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean traverse(Key.Direction direction, boolean deep, int minimumBytes, int minKeyDepth, int matchUpToIndex, TraverseVisitor visitor) throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        Key spareKey = this._spareKey1;
        boolean doFetch = minimumBytes > 0;
        boolean doModify = minimumBytes >= 0;
        boolean reverse = direction == Key.LT || direction == Key.LTEQ;
        Value outValue = doFetch ? this._value : this._spareValue;
        outValue.clear();
        Key.Direction dir = direction;
        Buffer buffer = null;
        boolean edge = dir == Key.EQ || dir == Key.GTEQ || dir == Key.LTEQ;
        boolean nudged = false;
        if (this._key.getEncodedSize() == 0) {
            if (reverse) {
                this._key.appendAfter();
            } else {
                this._key.appendBefore();
            }
            nudged = true;
        }
        this._key.testValidForTraverse();
        this.checkLevelCache();
        try {
            boolean bl;
            boolean matches;
            block56: {
                this._key.copyTo(spareKey);
                int index = this._key.getEncodedSize();
                int foundAt = 0;
                boolean nudgeForMVCC = false;
                this._keysVisitedDuringTraverse = 0;
                while (true) {
                    ++this._keysVisitedDuringTraverse;
                    LevelCache lc = this._levelCache[0];
                    if (buffer == null && lc._keyGeneration == this._key.getGeneration()) {
                        buffer = this.quicklyReclaimBuffer(lc, false);
                        foundAt = lc._foundAt;
                    }
                    if (buffer != null && (nudgeForMVCC || reverse && (foundAt & 0xFFFC) <= buffer.getKeyBlockStart())) {
                        buffer.releaseTouched();
                        buffer = null;
                    }
                    if (buffer == null) {
                        if (nudgeForMVCC || !edge && !nudged) {
                            if (reverse) {
                                if (!this._key.isSpecial()) {
                                    this._key.nudgeLeft();
                                }
                            } else if (!this._key.isSpecial()) {
                                if (deep) {
                                    this._key.nudgeDeeper();
                                } else {
                                    this._key.nudgeRight();
                                }
                            }
                            nudged = true;
                            nudgeForMVCC = false;
                        }
                        foundAt = this.search(this._key, false);
                        buffer = lc._buffer;
                    }
                    if (edge && (foundAt & 1) != 0) {
                        matches = true;
                    } else if (edge && !deep && Buffer.decodeDepth(foundAt) == index) {
                        matches = true;
                    } else if (dir == Key.EQ) {
                        matches = false;
                    } else {
                        edge = false;
                        if (buffer.isAfterRightEdge(foundAt = buffer.traverse(this._key, dir, foundAt))) {
                            long rightSiblingPage = buffer.getRightSibling();
                            Debug.$assert0.t(rightSiblingPage >= 0L && rightSiblingPage <= 0x7FFFFFFEL);
                            if (rightSiblingPage > 0L) {
                                Buffer rightSibling = this._pool.get(this._volume, rightSiblingPage, false, true, this._timeoutMillis);
                                buffer.releaseTouched();
                                buffer = rightSibling;
                                this.checkPageType(buffer, 1, false);
                                foundAt = buffer.traverse(this._key, dir, buffer.toKeyBlock(0));
                                matches = !buffer.isAfterRightEdge(foundAt);
                            } else {
                                matches = false;
                            }
                        } else {
                            matches = true;
                        }
                        if (!nudged && !deep && this._key.compareKeyFragment(spareKey, 0, spareKey.getEncodedSize()) == 0) {
                            this._key.setEncodedSize(spareKey.getEncodedSize());
                            lc._keyGeneration = -1L;
                            buffer.release();
                            buffer = null;
                            continue;
                        }
                    }
                    boolean stopDueToKeyDepth = minKeyDepth > 0 && this._key.getDepth() < minKeyDepth ? true : (matchUpToIndex > 0 ? spareKey.compareKeyFragment(this._key, 0, matchUpToIndex) != 0 : false);
                    if (reverse && this._key.isLeftEdge() || !reverse && this._key.isRightEdge() || stopDueToKeyDepth) {
                        matches = false;
                    } else if (deep) {
                        boolean bl2 = dir != Key.EQ;
                        index = this._key.getEncodedSize();
                        if ((matches |= bl2) && !(matches = this.fetchFromBufferInternal(buffer, outValue, foundAt, minimumBytes)) && dir != Key.EQ) {
                            nudged = false;
                            nudgeForMVCC = dir == Key.GTEQ || dir == Key.LTEQ;
                            buffer.release();
                            buffer = null;
                            continue;
                        }
                    } else {
                        int parentIndex = spareKey.previousElementIndex(index);
                        if (parentIndex < 0) {
                            parentIndex = 0;
                        }
                        if (matches &= spareKey.compareKeyFragment(this._key, 0, parentIndex) == 0) {
                            index = this._key.nextElementIndex(parentIndex);
                            if (index > 0) {
                                boolean isVisibleMatch = this.fetchFromBufferInternal(buffer, outValue, foundAt, minimumBytes);
                                if (!isVisibleMatch) {
                                    nudged = false;
                                    buffer.release();
                                    buffer = null;
                                    if (dir == Key.EQ) {
                                        matches = false;
                                    } else {
                                        nudgeForMVCC = dir == Key.GTEQ || dir == Key.LTEQ;
                                        continue;
                                    }
                                }
                                if (index != this._key.getEncodedSize()) {
                                    foundAt &= 0xFFFFFFFE;
                                }
                            } else {
                                matches = false;
                            }
                        }
                    }
                    if (doModify) {
                        if (matches) {
                            if (this._key.getEncodedSize() == index) {
                                lc.update(buffer, this._key, foundAt);
                            } else {
                                this._key.setEncodedSize(index);
                                if (buffer != null) {
                                    buffer.releaseTouched();
                                    buffer = null;
                                }
                                this.fetch(minimumBytes);
                            }
                        } else {
                            if (deep) {
                                this._key.setEncodedSize(0);
                            } else {
                                spareKey.copyTo(this._key);
                            }
                            this._key.cut();
                            if (reverse) {
                                this._key.appendAfter();
                            } else {
                                this._key.appendBefore();
                            }
                        }
                    } else {
                        spareKey.copyTo(this._key);
                    }
                    this._volume.getStatistics().bumpTraverseCounter();
                    this._tree.getStatistics().bumpTraverseCounter();
                    if (!matches || visitor == null || !visitor.visit(this)) break block56;
                    nudged = false;
                    edge = false;
                    if (dir == Key.GTEQ) {
                        dir = Key.GT;
                        continue;
                    }
                    if (dir == Key.LTEQ) {
                        dir = Key.LT;
                        continue;
                    }
                    if (dir == Key.EQ) break;
                }
                bl = false;
                return bl;
            }
            bl = matches;
            return bl;
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
                buffer = null;
            }
        }
    }

    public boolean traverse(Key.Direction direction, boolean deep, int minimumBytes, TraverseVisitor visitor) throws PersistitException {
        return this.traverse(direction, deep, Math.max(0, minimumBytes), 0, 0, visitor);
    }

    public boolean traverse(Key.Direction direction, KeyFilter keyFilter, int minBytes) throws PersistitException {
        if (keyFilter == null) {
            return this.traverse(direction, true, minBytes);
        }
        if (direction == Key.EQ) {
            return keyFilter.selected(this._key) && this.traverse(direction, true, minBytes);
        }
        this.assertCorrectThread(true);
        if (this._key.getEncodedSize() == 0) {
            if (direction == Key.GT || direction == Key.GTEQ) {
                this._key.appendBefore();
            } else {
                this._key.appendAfter();
            }
        }
        int totalVisited = 0;
        do {
            if (!keyFilter.next(this._key, direction)) {
                this._key.setEncodedSize(0);
                if (direction == Key.LT || direction == Key.LTEQ) {
                    this._key.appendAfter();
                } else {
                    this._key.appendBefore();
                }
                return false;
            }
            if (keyFilter.isKeyPrefixFilter()) {
                return this.traverse(direction, true, minBytes, keyFilter.getMinimumDepth(), keyFilter.getKeyPrefixByteCount(), null);
            }
            boolean matched = this.traverse(direction, true, minBytes);
            this._keysVisitedDuringTraverse = totalVisited += this._keysVisitedDuringTraverse;
            if (matched) continue;
            return false;
        } while (!keyFilter.selected(this._key));
        return true;
    }

    public boolean next() throws PersistitException {
        return this.traverse(Key.GT, false);
    }

    public boolean previous() throws PersistitException {
        return this.traverse(Key.LT, false);
    }

    public boolean next(boolean deep) throws PersistitException {
        return this.traverse(Key.GT, deep);
    }

    public boolean previous(boolean deep) throws PersistitException {
        return this.traverse(Key.LT, deep);
    }

    public boolean next(KeyFilter filter) throws PersistitException {
        return this.traverse(Key.GT, filter, Integer.MAX_VALUE);
    }

    public boolean previous(KeyFilter filter) throws PersistitException {
        return this.traverse(Key.LT, filter, Integer.MAX_VALUE);
    }

    public boolean hasNext() throws PersistitException {
        return this.traverse(Key.GT, false, -1);
    }

    public boolean hasNext(KeyFilter filter) throws PersistitException {
        if (filter == null) {
            return this.hasNext();
        }
        this._key.copyTo(this._spareKey2);
        boolean result = this.traverse(Key.GT, filter, 0);
        this._spareKey2.copyTo(this._key);
        return result;
    }

    public boolean hasNext(boolean deep) throws PersistitException {
        return this.traverse(Key.GT, deep, -1);
    }

    public boolean hasPrevious() throws PersistitException {
        return this.traverse(Key.LT, false, -1);
    }

    public boolean hasPrevious(boolean deep) throws PersistitException {
        return this.traverse(Key.LT, deep, -1);
    }

    public boolean hasPrevious(KeyFilter filter) throws PersistitException {
        if (filter == null) {
            return this.hasPrevious();
        }
        this._key.copyTo(this._spareKey2);
        boolean result = this.traverse(Key.GT, filter, 0);
        this._spareKey2.copyTo(this._key);
        return result;
    }

    public boolean isValueDefined() throws PersistitException {
        return this.traverse(Key.EQ, true, -1);
    }

    public Exchange store() throws PersistitException {
        return this.store(this._key, this._value);
    }

    public void lock() throws PersistitException {
        this.lock(this._key, 60000L);
    }

    public void lock(Key key) throws PersistitException {
        this.lock(key, 60000L);
    }

    public void lock(Key lockKey, long timeout) throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        if (!this._transaction.isActive()) {
            throw new IllegalStateException("No active transaction scope");
        }
        Exchange lockExchange = this._persistit.getExchange(this._persistit.getLockVolume(), this._tree.getName(), true);
        this._persistit.getJournalManager().handleForTree(lockExchange.getTree());
        lockExchange.setTimeoutMillis(timeout);
        lockKey.copyTo(lockExchange.getKey());
        lockExchange.getKey().testValidForStoreAndFetch(this._pool.getBufferSize());
        lockExchange.getValue().clear().putAntiValueMVV();
        int options = 44;
        lockExchange.storeInternal(lockExchange.getKey(), lockExchange.getValue(), 0, 44);
        long page = lockExchange._levelCache[0]._page;
        this._transaction.addLockPage(page, lockExchange.getTree().getHandle());
        this._persistit.releaseExchange(lockExchange);
    }

    public Exchange fetchAndStore() throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        if (this._volume.isReadOnly()) {
            throw new ReadOnlyVolumeException(this._volume.toString());
        }
        this._persistit.checkSuspended();
        this._key.testValidForStoreAndFetch(this._volume.getPageSize());
        int options = 10;
        this.storeInternal(this._key, this._value, 0, options |= !this._ignoreTransactions && this._transaction.isActive() ? 4 : 0);
        this._spareValue.copyTo(this._value);
        return this;
    }

    public Exchange fetch() throws PersistitException {
        return this.fetch(this._value, Integer.MAX_VALUE);
    }

    public Exchange fetch(int minimumBytes) throws PersistitException {
        return this.fetch(this._value, minimumBytes);
    }

    public Exchange fetch(Value value) throws PersistitException {
        return this.fetch(value, Integer.MAX_VALUE);
    }

    private boolean mvccFetch(Value value, int minimumBytes) throws PersistitException {
        int step;
        TransactionStatus status;
        if (this._transaction.isActive()) {
            status = this._transaction.getTransactionStatus();
            step = this._transaction.getStep();
        } else {
            status = null;
            step = 0;
        }
        this._mvvVisitor.initInternal(status, step, MvvVisitor.Usage.FETCH);
        int valueSize = value.getEncodedSize();
        byte[] valueBytes = value.getEncodedBytes();
        MVV.visitAllVersions(this._mvvVisitor, valueBytes, 0, valueSize);
        if (this._mvvVisitor.foundVersion()) {
            int finalSize = MVV.fetchVersionByOffset(valueBytes, valueSize, this._mvvVisitor.getOffset(), valueBytes);
            value.setEncodedSize(finalSize);
            return true;
        }
        if (minimumBytes > 0) {
            value.clear();
        }
        return false;
    }

    public Exchange fetch(Value value, int minimumBytes) throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        this._key.testValidForStoreAndFetch(this._volume.getPageSize());
        if (minimumBytes < 0) {
            minimumBytes = 0;
        }
        this.searchAndFetchInternal(value, minimumBytes);
        return this;
    }

    private boolean fetchFromBufferInternal(Buffer buffer, Value value, int foundAt, int minimumBytes) throws PersistitException {
        buffer.fetch(foundAt, value);
        return this.fetchFromValueInternal(value, minimumBytes, buffer);
    }

    private boolean fetchFromValueInternal(Value value, int minimumBytes, Buffer bufferForPruning) throws PersistitException {
        boolean visible = true;
        if (!this._ignoreMVCCFetch) {
            this.fetchFixupForLongRecords(value, Integer.MAX_VALUE);
            if (MVV.isArrayMVV(value.getEncodedBytes(), 0, value.getEncodedSize())) {
                visible = this.mvccFetch(value, minimumBytes);
                this.fetchFixupForLongRecords(value, minimumBytes);
            }
            if (value.isDefined() && value.isAntiValue()) {
                value.clear();
                visible = false;
            }
        } else {
            this.fetchFixupForLongRecords(value, minimumBytes);
        }
        return visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchAndFetchInternal(Value value, int minimumBytes) throws PersistitException {
        Buffer buffer = null;
        try {
            int foundAt = this.search(this._key, false);
            LevelCache lc = this._levelCache[0];
            buffer = lc._buffer;
            this.fetchFromBufferInternal(buffer, value, foundAt, minimumBytes);
            this._volume.getStatistics().bumpFetchCounter();
            this._tree.getStatistics().bumpFetchCounter();
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
            }
            this._treeHolder.verifyReleased();
        }
    }

    boolean isLongRecord(Value value) {
        return value.isDefined() && Buffer.isLongRecord(value.getEncodedBytes(), 0, value.getEncodedSize());
    }

    boolean isLongMVV(Value value) {
        return value.isDefined() && Buffer.isLongMVV(value.getEncodedBytes(), 0, value.getEncodedSize());
    }

    void fetchFixupForLongRecords(Value value, int minimumBytes) throws PersistitException {
        if (minimumBytes >= 0 && this.isLongRecord(value)) {
            this.getLongRecordHelper().fetchLongRecord(value, minimumBytes, this._timeoutMillis);
        }
    }

    public boolean hasChildren() throws PersistitException {
        this._key.copyTo(this._spareKey2);
        int size = this._key.getEncodedSize();
        boolean result = this.traverse(Key.GT, true, 0, this._key.getDepth() + 1, size, null);
        this._spareKey2.copyTo(this._key);
        return result;
    }

    public boolean fetchAndRemove() throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        this._persistit.checkSuspended();
        this._spareValue.clear();
        boolean result = this.removeInternal(Key.EQ, true);
        this._spareValue.copyTo(this._value);
        Debug.$assert0.t(this._value.isDefined() == result);
        return result;
    }

    public void removeTree() throws PersistitException {
        this.assertCorrectThread(true);
        this._persistit.checkSuspended();
        this._persistit.checkClosed();
        this._volume.getStructure().removeTree(this._tree);
        if (!this._ignoreTransactions) {
            assert (!this.isDirectoryExchange());
            this._transaction.removeTree(this);
        }
        this._key.clear();
        this._value.clear();
        this.initCache();
    }

    public boolean remove() throws PersistitException {
        return this.removeInternal(Key.EQ, false);
    }

    public boolean removeAll() throws PersistitException {
        this.clear();
        return this.removeInternal(Key.GTEQ, false);
    }

    public boolean remove(Key.Direction direction) throws PersistitException {
        return this.removeInternal(direction, false);
    }

    private boolean removeInternal(Key.Direction selection, boolean fetchFirst) throws PersistitException {
        if (selection != Key.EQ && selection != Key.GTEQ && selection != Key.GT) {
            throw new IllegalArgumentException("Invalid mode " + (Object)((Object)selection));
        }
        int keySize = this._key.getEncodedSize();
        this._key.copyTo(this._spareKey3);
        this._key.copyTo(this._spareKey4);
        if (keySize == 0) {
            if (selection == Key.EQ) {
                this.assertCorrectThread(true);
                return false;
            }
            this._spareKey3.append(Key.BEFORE);
            this._spareKey4.append(Key.AFTER);
        } else if (selection == Key.EQ) {
            this._spareKey4.nudgeDeeper();
        } else if (selection == Key.GT) {
            this._spareKey3.nudgeDeeper();
            this._spareKey4.nudgeRight();
        } else if (selection == Key.GTEQ) {
            this._spareKey4.nudgeRight();
        }
        boolean result = this.removeKeyRangeInternal(this._spareKey3, this._spareKey4, fetchFirst);
        this._treeHolder.verifyReleased();
        return result;
    }

    public boolean removeKeyRange(Key key1, Key key2) throws PersistitException {
        key1.copyTo(this._spareKey3);
        key2.copyTo(this._spareKey4);
        if (key1.getEncodedSize() == 0) {
            this._spareKey3.append(Key.BEFORE);
        }
        if (key2.getEncodedSize() == 0) {
            this._spareKey4.append(Key.AFTER);
        }
        if (this._spareKey3.compareTo(this._spareKey4) >= 0) {
            throw new IllegalArgumentException("Second key must be greater than the first");
        }
        boolean result = this.removeKeyRangeInternal(this._spareKey3, this._spareKey4, false);
        this._treeHolder.verifyReleased();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeKeyRangeInternal(Key key1, Key key2, boolean fetchFirst) throws PersistitException {
        Debug.$assert0.t(key1.getEncodedSize() > 0);
        Debug.$assert0.t(key2.getEncodedSize() > 0);
        Debug.$assert0.t(key1.compareTo(key2) < 0);
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        if (!this.isDirectoryExchange()) {
            this._persistit.checkSuspended();
        }
        this.throttle();
        if (this._ignoreTransactions || !this._transaction.isActive()) {
            return this.raw_removeKeyRangeInternal(key1, key2, fetchFirst, false);
        }
        this._transaction.remove(this, key1, key2);
        if (this._tree.isTransactionPrivate(true)) {
            return this.raw_removeKeyRangeInternal(key1, key2, fetchFirst, false);
        }
        this.checkLevelCache();
        this._value.clear().putAntiValueMVV();
        int storeOptions = 0x3C | (fetchFirst ? 2 : 0);
        boolean anyRemoved = false;
        boolean keyIsLessThan = true;
        Key nextKey = new Key(key1);
        while (keyIsLessThan && !key1.isRightEdge()) {
            Buffer buffer = null;
            try {
                buffer = this._levelCache[0]._buffer;
                int foundAt = this.search(key1, true);
                if (buffer.isAfterRightEdge(foundAt)) continue;
                boolean bl = keyIsLessThan = key1.compareTo(key2) < 0;
                if (!keyIsLessThan) continue;
                foundAt = buffer.nextKey(nextKey, foundAt);
                buffer.releaseTouched();
                buffer = null;
                anyRemoved |= this.storeInternal(key1, this._value, 0, storeOptions);
                nextKey.copyTo(key1);
            }
            finally {
                if (buffer == null) continue;
                buffer.releaseTouched();
                buffer = null;
            }
        }
        this._value.clear();
        return anyRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean raw_removeKeyRangeInternal(Key key1, Key key2, boolean fetchFirst, boolean removeOnlyAntiValue) throws PersistitException {
        assert (key1 != this._spareKey1 && key2 != this._spareKey1 && key1 != this._spareKey2 && key2 != this._spareKey2);
        this._persistit.checkClosed();
        this._persistit.checkSuspended();
        if (this._volume.isReadOnly()) {
            throw new ReadOnlyVolumeException(this._volume.toString());
        }
        boolean treeClaimAcquired = false;
        boolean treeWriterClaimRequired = false;
        boolean result = false;
        boolean deallocationRequired = true;
        boolean tryQuickDelete = true;
        if (!this._ignoreTransactions) {
            this._transaction.remove(this, key1, key2);
        }
        try {
            while (true) {
                this.checkLevelCache();
                int depth = this._cacheDepth;
                try {
                    long pageAddr1;
                    if (tryQuickDelete) {
                        ArrayList<VolumeStructure.Chain> chains = new ArrayList<VolumeStructure.Chain>();
                        Buffer buffer = null;
                        try {
                            int foundAt2;
                            int foundAt1 = this.search(key1, true) & 0xFFFC;
                            buffer = this._levelCache[0]._buffer;
                            if (this._tree.getGeneration() == this._cachedTreeGeneration && foundAt1 > buffer.getKeyBlockStart() && foundAt1 < buffer.getKeyBlockEnd() && !buffer.isBeforeLeftEdge(foundAt2 = buffer.findKey(key2) & 0xFFFC) && !buffer.isAfterRightEdge(foundAt2) && (foundAt2 &= 0xFFFC) < buffer.getKeyBlockEnd()) {
                                Debug.$assert0.t(foundAt2 >= foundAt1);
                                if (removeOnlyAntiValue) {
                                    for (int p = foundAt1; p < foundAt2; p += 4) {
                                        if (buffer.isPrimordialAntiValue(p)) continue;
                                        boolean bl = false;
                                        return bl;
                                    }
                                }
                                if (fetchFirst) {
                                    this.removeFetchFirst(buffer, foundAt1, buffer, foundAt2);
                                }
                                long timestamp = this.timestamp();
                                buffer.writePageOnCheckpoint(timestamp);
                                this._volume.getStructure().harvestLongRecords(buffer, foundAt1, foundAt2, chains);
                                boolean removed = buffer.removeKeys(foundAt1, foundAt2, this._spareKey1);
                                if (removed) {
                                    this._tree.bumpChangeCount();
                                    buffer.setDirtyAtTimestamp(timestamp);
                                }
                                result = removed;
                                break;
                            }
                            tryQuickDelete = false;
                        }
                        finally {
                            if (buffer != null) {
                                buffer.releaseTouched();
                                buffer = null;
                            }
                        }
                        this._volume.getStructure().deallocateGarbageChain(chains);
                    }
                    if (!treeClaimAcquired) {
                        if (!this._treeHolder.claim(treeWriterClaimRequired)) {
                            Debug.$assert0.t(false);
                            throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to get writer claim on " + this._tree);
                        }
                        treeClaimAcquired = true;
                    }
                    this.checkLevelCache();
                    long pageAddr2 = pageAddr1 = this._tree.getRootPageAddr();
                    int level = this._cacheDepth;
                    while (--level >= 0) {
                        boolean samePage;
                        LevelCache lc = this._levelCache[level];
                        lc.initRemoveFields();
                        depth = level;
                        int foundAt1 = this.searchLevel(key1, true, pageAddr1, level, true);
                        int foundAt2 = -1;
                        Buffer buffer = lc._buffer;
                        lc._flags |= 1;
                        lc._leftBuffer = buffer;
                        lc._leftFoundAt = foundAt1;
                        boolean bl = samePage = pageAddr2 == pageAddr1;
                        if (samePage) {
                            foundAt2 = buffer.findKey(key2);
                            if (!buffer.isAfterRightEdge(foundAt2)) {
                                lc._rightBuffer = buffer;
                                lc._rightFoundAt = foundAt2;
                            } else {
                                pageAddr2 = buffer.getRightSibling();
                                samePage = false;
                            }
                        }
                        if (!samePage) {
                            if (!treeWriterClaimRequired) {
                                treeWriterClaimRequired = true;
                                if (!this._treeHolder.upgradeClaim()) {
                                    throw RetryException.SINGLE;
                                }
                            }
                            foundAt2 = this.searchLevel(key2, false, pageAddr2, level, true);
                            buffer = lc._buffer;
                            lc._flags |= 2;
                            lc._rightBuffer = buffer;
                            lc._rightFoundAt = foundAt2;
                            pageAddr2 = buffer.getPageAddress();
                        }
                        if (lc._leftBuffer.isIndexPage()) {
                            Debug.$assert0.t(lc._rightBuffer.isIndexPage() && depth > 0);
                            int p1 = lc._leftBuffer.previousKeyBlock(foundAt1);
                            int p2 = lc._rightBuffer.previousKeyBlock(foundAt2);
                            Debug.$assert0.t(p1 != -1 && p2 != -1);
                            pageAddr1 = lc._leftBuffer.getPointer(p1);
                            pageAddr2 = lc._rightBuffer.getPointer(p2);
                            continue;
                        }
                        Debug.$assert0.t(depth == 0);
                        break;
                    }
                    LevelCache lc = this._levelCache[0];
                    if (removeOnlyAntiValue & !this.isKeyRangeAntiValue(lc._leftBuffer, lc._leftFoundAt, lc._rightBuffer, lc._rightFoundAt)) {
                        result = false;
                        break;
                    }
                    if (fetchFirst) {
                        this.removeFetchFirst(lc._leftBuffer, lc._leftFoundAt, lc._rightBuffer, lc._rightFoundAt);
                    }
                    this._tree.bumpGeneration();
                    long timestamp = this.timestamp();
                    int level2 = this._cacheDepth;
                    while (--level2 >= 0) {
                        lc = this._levelCache[level2];
                        Buffer buffer1 = lc._leftBuffer;
                        Buffer buffer2 = lc._rightBuffer;
                        int foundAt1 = lc._leftFoundAt;
                        int foundAt2 = lc._rightFoundAt;
                        foundAt1 &= 0xFFFC;
                        foundAt2 &= 0xFFFC;
                        boolean needsReindex = false;
                        buffer1.writePageOnCheckpoint(timestamp);
                        if (buffer1 != buffer2) {
                            buffer2.writePageOnCheckpoint(timestamp);
                            long leftGarbagePage = buffer1.getRightSibling();
                            this._key.copyTo(this._spareKey1);
                            this._volume.getStructure().harvestLongRecords(buffer1, foundAt1, Integer.MAX_VALUE);
                            this._volume.getStructure().harvestLongRecords(buffer2, 0, foundAt2);
                            Debug.$assert0.t(this._tree.isOwnedAsWriterByMe() && buffer1.isOwnedAsWriterByMe() && buffer2.isOwnedAsWriterByMe());
                            boolean rebalanced = false;
                            try {
                                rebalanced = buffer1.join(buffer2, foundAt1, foundAt2, this._spareKey1, this._spareKey2, this._joinPolicy);
                            }
                            catch (RebalanceException rbe) {
                                this.rebalanceSplit(lc);
                                ++level2;
                                continue;
                            }
                            if (buffer1.isDataPage()) {
                                this._tree.bumpChangeCount();
                            }
                            buffer1.setDirtyAtTimestamp(timestamp);
                            buffer2.setDirtyAtTimestamp(timestamp);
                            long rightGarbagePage = buffer1.getRightSibling();
                            if (rightGarbagePage != leftGarbagePage) {
                                lc._deallocLeftPage = leftGarbagePage;
                                lc._deallocRightPage = rightGarbagePage;
                                deallocationRequired = true;
                            }
                            if (rebalanced) {
                                needsReindex = true;
                                if (level2 < this._cacheDepth - 1) {
                                    LevelCache parentLc = this._levelCache[level2 + 1];
                                    Buffer buffer = parentLc._leftBuffer;
                                    Debug.$assert0.t(buffer != null);
                                    if (parentLc._rightBuffer == buffer) {
                                        int foundAt = buffer.findKey(this._spareKey1);
                                        Debug.$assert0.t((foundAt & 1) == 0);
                                        this._value.setPointerValue(buffer2.getPageAddress());
                                        this._value.setPointerPageType(buffer2.getPageType());
                                        this._rawValueWriter.init(this._value);
                                        int fit = buffer.putValue(this._spareKey1, this._rawValueWriter, foundAt, false);
                                        if (fit != -1) {
                                            needsReindex = false;
                                            buffer.setDirtyAtTimestamp(timestamp);
                                        }
                                    }
                                }
                                if (needsReindex) {
                                    this._spareKey1.copyTo(this._spareKey2);
                                    this._value.setPointerValue(buffer2.getPageAddress());
                                    this._value.setPointerPageType(buffer2.getPageType());
                                    this.storeInternal(this._spareKey2, this._value, level2 + 1, 0);
                                    needsReindex = false;
                                }
                            }
                            result = true;
                        } else if (foundAt1 != foundAt2) {
                            Debug.$assert0.t(foundAt2 > foundAt1);
                            this._key.copyTo(this._spareKey1);
                            this._volume.getStructure().harvestLongRecords(buffer1, foundAt1, foundAt2);
                            if (buffer1.isDataPage() && (result |= buffer1.removeKeys(foundAt1, foundAt2, this._spareKey1))) {
                                this._tree.bumpChangeCount();
                            }
                            buffer1.setDirtyAtTimestamp(timestamp);
                        }
                        if (level2 >= this._cacheDepth - 1) continue;
                        this.removeKeyRangeReleaseLevel(level2 + 1);
                    }
                    break;
                }
                catch (RetryException pageAddr1) {
                }
                finally {
                    int level = this._cacheDepth;
                    while (--level >= depth) {
                        this.removeKeyRangeReleaseLevel(level);
                    }
                    if (treeClaimAcquired) {
                        this._treeHolder.release();
                        treeClaimAcquired = false;
                    }
                }
                if (!treeWriterClaimRequired) continue;
                if (!this._treeHolder.claim(true)) {
                    Debug.$assert0.t(false);
                    throw new InUseException("Thread " + Thread.currentThread().getName() + " failed to get reader claim on " + this._tree);
                }
                treeClaimAcquired = true;
            }
            if (deallocationRequired) {
                long left = -1L;
                long right = -1L;
                int level = this._cacheDepth;
                while (--level >= 0) {
                    LevelCache lc = this._levelCache[level];
                    left = lc._deallocLeftPage;
                    right = lc._deallocRightPage;
                    if (left == 0L) continue;
                    ThreadSequencer.sequence(SequencerConstants.DEALLOCATE_CHAIN_A);
                    this._volume.getStructure().deallocateGarbageChain(left, right);
                    lc._deallocLeftPage = 0L;
                    lc._deallocRightPage = 0L;
                }
                deallocationRequired = false;
            }
        }
        finally {
            if (treeClaimAcquired) {
                if (treeWriterClaimRequired) {
                    this._tree.bumpGeneration();
                }
                this._treeHolder.release();
                treeClaimAcquired = false;
            }
        }
        this._volume.getStatistics().bumpRemoveCounter();
        this._tree.getStatistics().bumpRemoveCounter();
        if (fetchFirst) {
            this._volume.getStatistics().bumpFetchCounter();
            this._tree.getStatistics().bumpFetchCounter();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebalanceSplit(LevelCache lc) throws PersistitException {
        int level = lc._level;
        int foundAt = lc._leftFoundAt;
        Buffer left = lc._leftBuffer;
        Buffer inserted = this._volume.getStructure().allocPage();
        try {
            long timestamp = this.timestamp();
            left.writePageOnCheckpoint(timestamp);
            inserted.writePageOnCheckpoint(timestamp);
            Debug.$assert0.t(inserted.getPageAddress() != 0L);
            Debug.$assert0.t(inserted != left);
            inserted.init(left.getPageType());
            Value value = this._persistit.getThreadLocalValue();
            value.clear();
            this._rawValueWriter.init(value);
            Key key = this._persistit.getThreadLocalKey();
            lc._rightBuffer.nextKey(key, 32);
            left.split(inserted, key, this._rawValueWriter, foundAt | 1, this._spareKey1, Sequence.NONE, SplitPolicy.EVEN_BIAS);
            inserted.setRightSibling(left.getRightSibling());
            left.setRightSibling(inserted.getPageAddress());
            left.setDirtyAtTimestamp(timestamp);
            inserted.setDirtyAtTimestamp(timestamp);
            lc._leftBuffer = inserted;
            lc._leftFoundAt = inserted.findKey(key);
            this._persistit.getCleanupManager().offer(new CleanupManager.CleanupIndexHole(this._tree.getHandle(), inserted.getPageAddress(), level));
        }
        finally {
            left.releaseTouched();
        }
    }

    private void removeKeyRangeReleaseLevel(int level) {
        LevelCache lc = this._levelCache[level];
        Buffer buffer1 = lc._leftBuffer;
        Buffer buffer2 = lc._rightBuffer;
        if (buffer2 != null && (lc._flags & 2) != 0) {
            buffer2.releaseTouched();
        }
        if (buffer1 != null && (lc._flags & 1) != 0) {
            buffer1.releaseTouched();
        }
        lc._leftBuffer = null;
        lc._rightBuffer = null;
        lc._flags = 0;
    }

    private void removeFetchFirst(Buffer buffer1, int foundAt1, Buffer buffer2, int foundAt2) throws PersistitException {
        if (buffer1 == buffer2) {
            if (buffer1.nextKeyBlock(foundAt1) == (foundAt2 & 0xFFFC)) {
                buffer1.fetch(foundAt1 | 1, this._spareValue);
            }
        } else if (buffer1.getRightSibling() == buffer2.getPageAddress() && buffer1.nextKeyBlock(foundAt1) == -1 && buffer2.nextKeyBlock(foundAt1 = buffer2.toKeyBlock(0)) == (foundAt2 & 0xFFFC)) {
            buffer2.fetch(foundAt1 | 1, this._spareValue);
        }
        if (this._spareValue.isDefined()) {
            this.fetchFixupForLongRecords(this._spareValue, Integer.MAX_VALUE);
        }
    }

    private boolean isKeyRangeAntiValue(Buffer buffer1, int foundAt1, Buffer buffer2, int foundAt2) {
        if (buffer1.getKeyBlockEnd() != (foundAt1 & 0xFFFC) + 4) {
            return false;
        }
        if (buffer2.getKeyBlockStart() != (foundAt2 & 0xFFFC) - 4) {
            return false;
        }
        if (buffer1.getRightSibling() != buffer2.getPageAddress()) {
            return false;
        }
        return buffer2.isPrimordialAntiValue(32);
    }

    void prune() throws PersistitException {
        this.prune(this._key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prune(Key key) throws PersistitException {
        Buffer buffer = null;
        Debug.$assert1.t(this._tree.isLive());
        try {
            this.search(key, true);
            buffer = this._levelCache[0]._buffer;
            if (buffer != null) {
                boolean bl = buffer.pruneMvvValues(this._tree, true, null);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prune(Key key1, Key key2) throws PersistitException {
        Buffer buffer = null;
        boolean pruned = false;
        Debug.$assert1.t(this._tree.isLive());
        try {
            this.search(key1, true);
            buffer = this._levelCache[0]._buffer;
            while (buffer != null) {
                this.checkPageType(buffer, 1, false);
                pruned |= buffer.pruneMvvValues(this._tree, true, null);
                int foundAt = buffer.findKey(key2);
                if (!buffer.isAfterRightEdge(foundAt)) {
                    break;
                }
                Buffer oldBuffer = buffer;
                long rightPageAddress = buffer.getRightSibling();
                if (rightPageAddress == 0L) {
                    break;
                }
                buffer = this._pool.get(this._volume, buffer.getRightSibling(), true, true);
                oldBuffer.release();
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
        return pruned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prune(long page, List<CleanupManager.CleanupAction> consequentActions) throws PersistitException {
        Buffer buffer = null;
        try {
            buffer = this._pool.get(this._volume, page, true, true);
            boolean bl = buffer.pruneMvvValues(this._tree, true, consequentActions);
            return bl;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pruneLeftEdgeValue(long page, List<CleanupManager.CleanupAction> consequentActions) throws PersistitException {
        this._ignoreTransactions = true;
        Buffer buffer = null;
        try {
            buffer = this._pool.get(this._volume, page, false, true);
            buffer.clearEnqueuedForPruning();
            long at = buffer.at(32);
            if (at > 0L) {
                int offset = (int)(at >>> 32);
                int size = (int)at;
                if (size == 1 && buffer.getBytes()[offset] == 49) {
                    buffer.nextKey(this._spareKey3, 32);
                    buffer.release();
                    buffer = null;
                    this._spareKey3.copyTo(this._spareKey4);
                    this._spareKey4.nudgeDeeper();
                    this.raw_removeKeyRangeInternal(this._spareKey3, this._spareKey4, false, true);
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fixIndexHole(long page, int level) throws PersistitException {
        this._ignoreTransactions = true;
        Buffer buffer = null;
        if (!this._treeHolder.claim(false, 500L)) {
            return false;
        }
        try {
            buffer = this._pool.get(this._volume, page, false, true);
            buffer.nextKey(this._spareKey2, buffer.toKeyBlock(0));
            this._value.setPointerValue(page);
            this._value.setPointerPageType(buffer.getPageType());
            buffer.release();
            buffer = null;
            this.storeInternal(this._spareKey2, this._value, level + 1, 0);
            boolean bl = true;
            return bl;
        }
        finally {
            this._treeHolder.release();
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private void checkPageType(Buffer buffer, int expectedType, boolean releaseOnFailure) throws PersistitException {
        assert (!buffer.isOwnedAsWriterByOther());
        int type = buffer.getPageType();
        if (type != expectedType) {
            if (releaseOnFailure) {
                buffer.releaseTouched();
            }
            this.corrupt("Volume " + this._volume + " page " + buffer.getPageAddress() + " invalid page type " + type + ": should be " + expectedType);
        }
    }

    private void assertCorrectThread(boolean set) {
        assert (this.checkThread(set)) : "Thread " + Thread.currentThread() + " must not use " + this + " owned by " + this._thread;
    }

    private boolean checkThread(boolean set) {
        Thread t = Thread.currentThread();
        if (this._thread == t) {
            if (!set) {
                this._thread = null;
            }
            return true;
        }
        if (this._thread == null) {
            if (set) {
                this._thread = t;
            }
            return true;
        }
        return false;
    }

    @Override
    public Transaction getTransaction() {
        this.assertCorrectThread(true);
        return this._transaction;
    }

    LongRecordHelper getLongRecordHelper() {
        if (this._longRecordHelper == null) {
            this._longRecordHelper = new LongRecordHelper(this._persistit, this);
        }
        return this._longRecordHelper;
    }

    void ignoreMVCCFetch(boolean doIgnore) {
        this._ignoreMVCCFetch = doIgnore;
    }

    void ignoreTransactions() {
        this._ignoreTransactions = true;
    }

    boolean isDirectoryExchange() {
        return this._isDirectoryExchange;
    }

    public void setSplitPolicy(SplitPolicy policy) {
        this.assertCorrectThread(true);
        this._splitPolicy = policy;
    }

    public void setJoinPolicy(JoinPolicy policy) {
        this.assertCorrectThread(true);
        this._joinPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyHistogram computeHistogram(Key start, Key end, int sampleSize, int keyDepth, KeyFilter keyFilter, int requestedTreeDepth) throws PersistitException {
        int treeDepth;
        this.assertCorrectThread(true);
        this._persistit.checkClosed();
        this.checkLevelCache();
        int n = treeDepth = requestedTreeDepth > this._tree.getDepth() ? this._tree.getDepth() : requestedTreeDepth;
        if (treeDepth < 0) {
            throw new IllegalArgumentException("treeDepth out of bounds: " + treeDepth);
        }
        KeyHistogram histogram = new KeyHistogram(this.getTree(), start, end, sampleSize, keyDepth, treeDepth);
        Buffer previousBuffer = null;
        LevelCache lc = null;
        Buffer buffer = null;
        Key.Direction direction = Key.GTEQ;
        if (start != null) {
            start.copyTo(this._key);
        } else {
            Key.LEFT_GUARD_KEY.copyTo(this._key);
            direction = Key.GT;
        }
        int foundAt = this.searchTree(this._key, treeDepth, false);
        try {
            lc = this._levelCache[treeDepth];
            buffer = lc._buffer;
            if (buffer != null) {
                this.checkPageType(buffer, treeDepth + 1, false);
            }
            while (foundAt != -1) {
                foundAt = buffer.traverse(this._key, direction, foundAt);
                direction = Key.GT;
                if (buffer.isAfterRightEdge(foundAt)) {
                    long rightSiblingPage = buffer.getRightSibling();
                    if (rightSiblingPage <= 0L) {
                        foundAt = -1;
                        break;
                    }
                    Buffer rightSibling = this._pool.get(this._volume, rightSiblingPage, false, true, this._timeoutMillis);
                    buffer.releaseTouched();
                    buffer = rightSibling;
                    this.checkPageType(buffer, treeDepth + 1, false);
                    foundAt = buffer.traverse(this._key, Key.GT, buffer.toKeyBlock(0));
                }
                if (end != null && end.compareTo(this._key) < 0) {
                    break;
                }
                if (this._key.isLeftEdge()) continue;
                if (buffer != previousBuffer) {
                    histogram.addPage(buffer.getBufferSize(), buffer.getBufferSize() - buffer.getAvailableSize());
                    previousBuffer = buffer;
                }
                if (keyFilter != null && !keyFilter.selected(this._key)) continue;
                histogram.addKeyCopy(this._key);
            }
        }
        finally {
            if (buffer != null) {
                buffer.releaseTouched();
            }
        }
        histogram.cull();
        return histogram;
    }

    void corrupt(String error) throws CorruptVolumeException {
        Debug.$assert0.t(false);
        this._persistit.getLogBase().corruptVolume.log(error + Util.NEW_LINE + this.toStringDetail());
        throw new CorruptVolumeException(error);
    }

    public void setAppCache(Object appCache) {
        this.assertCorrectThread(true);
        this._appCache = appCache;
    }

    public Object getAppCache() {
        this.assertCorrectThread(true);
        return this._appCache;
    }

    public long getTimeoutMillis() {
        this.assertCorrectThread(true);
        return this._timeoutMillis;
    }

    public void setTimeoutMillis(long timeout) {
        this._timeoutMillis = Util.rangeCheck(timeout, 0L, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer fetchBufferCopy(int level) throws PersistitException {
        this.assertCorrectThread(true);
        if (level >= this._tree.getDepth() || level <= -this._tree.getDepth()) {
            throw new IllegalArgumentException("Tree depth is " + this._tree.getDepth());
        }
        int lvl = level >= 0 ? level : this._tree.getDepth() + level;
        int foundAt = this.searchTree(this._key, lvl, false);
        Buffer buffer = this._levelCache[lvl]._buffer;
        try {
            if (foundAt == -1) {
                Buffer buffer2 = null;
                return buffer2;
            }
            Buffer buffer3 = new Buffer(buffer);
            return buffer3;
        }
        finally {
            buffer.releaseTouched();
        }
    }

    String toStringDetail() {
        LevelCache lc;
        StringBuilder sb = new StringBuilder(this.toString());
        for (int level = 0; level < 20 && (lc = this._levelCache[level]) != null && lc._buffer != null; ++level) {
            sb.append(Util.NEW_LINE);
            sb.append(level);
            sb.append(": ");
            sb.append(lc);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValueLongRecord() throws PersistitException {
        boolean savedIgnore = this._ignoreMVCCFetch;
        try {
            this._ignoreMVCCFetch = true;
            this.searchAndFetchInternal(this._spareValue, -1);
            boolean wasLong = this.isLongRecord(this._spareValue);
            this._spareValue.clear();
            boolean bl = wasLong;
            return bl;
        }
        finally {
            this._ignoreMVCCFetch = savedIgnore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValueLongMVV() throws PersistitException {
        boolean savedIgnore = this._ignoreMVCCFetch;
        try {
            this._ignoreMVCCFetch = true;
            this.searchAndFetchInternal(this._spareValue, -1);
            boolean wasLong = this.isLongMVV(this._spareValue);
            this._spareValue.clear();
            boolean bl = wasLong;
            return bl;
        }
        finally {
            this._ignoreMVCCFetch = savedIgnore;
        }
    }

    private void throttle() throws PersistitInterruptedException {
        if (!(this._ignoreTransactions || this._transaction.isActive() || this.isDirectoryExchange())) {
            this._persistit.getJournalManager().throttle();
        }
    }

    public void setMaximumValueSize(int size) {
        this._value.setMaximumSize(size);
        this._spareValue.setMaximumSize(size);
    }

    public static interface TraverseVisitor {
        public boolean visit(ReadOnlyExchange var1) throws PersistitException;
    }

    static enum PruneStatus {
        REMOVED,
        CHANGED,
        UNCHANGED;

    }

    static class StoreOptions {
        public static final int NONE = 0;
        public static final int FETCH = 2;
        public static final int MVCC = 4;
        public static final int WAIT = 8;
        public static final int ONLY_IF_VISIBLE = 16;
        public static final int DONT_JOURNAL = 32;

        StoreOptions() {
        }
    }

    private class LevelCache {
        int _level;
        Buffer _buffer;
        long _page;
        long _bufferGeneration;
        long _keyGeneration;
        int _foundAt;
        int _lastInsertAt;
        Buffer _leftBuffer;
        Buffer _rightBuffer;
        int _leftFoundAt;
        int _rightFoundAt;
        int _flags;
        long _deallocLeftPage;
        long _deallocRightPage;

        private LevelCache(int level) {
            this._level = level;
        }

        public String toString() {
            if (this._buffer == null) {
                return "<empty>";
            }
            return "Buffer=<" + this._buffer + ">, keyGeneration=" + this._keyGeneration + ", bufferGeneration=" + this._bufferGeneration + ", foundAt=" + this._buffer.foundAtString(this._foundAt) + ">";
        }

        private void copyTo(LevelCache to) {
            Debug.$assert0.t(to._level == this._level || to._level == -1);
            to._buffer = this._buffer;
            to._page = this._page;
            to._foundAt = this._foundAt;
            to._keyGeneration = this._keyGeneration;
            to._bufferGeneration = this._bufferGeneration;
        }

        private void invalidate() {
            this._buffer = null;
            this._bufferGeneration = -1L;
        }

        private void updateInsert(Buffer buffer, Key key, int foundAt) {
            this.update(buffer, key, foundAt);
            this._lastInsertAt = foundAt;
        }

        private void update(Buffer buffer, Key key, int foundAt) {
            Debug.$assert0.t(this._level + 1 == buffer.getPageType());
            this._page = buffer.getPageAddress();
            this._buffer = buffer;
            this._bufferGeneration = buffer.getGeneration();
            if (key == Exchange.this._key && foundAt > 0 && !buffer.isAfterRightEdge(foundAt)) {
                this._keyGeneration = key.getGeneration();
                this._foundAt = foundAt;
            } else {
                this._keyGeneration = -1L;
                this._foundAt = -1;
            }
        }

        private Sequence sequence(int foundAt) {
            int delta = (foundAt & 0xFFFC) - (this._lastInsertAt & 0xFFFC);
            if ((foundAt & 1) == 0 && delta == 4) {
                return Sequence.FORWARD;
            }
            if ((foundAt & 1) == 0 && delta == 0) {
                return Sequence.REVERSE;
            }
            return Sequence.NONE;
        }

        private void initRemoveFields() {
            this._leftBuffer = null;
            this._rightBuffer = null;
            this._leftFoundAt = -1;
            this._rightFoundAt = -1;
            this._flags = 0;
        }
    }

    private static class MvvVisitor
    implements MVV.VersionVisitor {
        private static final long READ_COMMITTED_TS = 0x7FFFFFFFFFFFFFFEL;
        private final TransactionIndex _ti;
        private final Exchange _exchange;
        private TransactionStatus _status;
        private int _step;
        private int _foundOffset;
        private int _foundLength;
        private long _foundVersion;
        private int _foundStep;
        private Usage _usage;

        private MvvVisitor(TransactionIndex ti, Exchange exchange) {
            this._ti = ti;
            this._exchange = exchange;
        }

        public void initInternal(TransactionStatus status, int step, Usage usage) {
            Debug.$assert0.t(status != null || usage != Usage.STORE);
            this._status = status;
            this._step = step;
            this._usage = usage;
        }

        public int getOffset() {
            return this._foundOffset;
        }

        public int getLength() {
            return this._foundLength;
        }

        public boolean foundVersion() {
            return this._foundVersion != -1L;
        }

        @Override
        public void init() {
            this._foundVersion = -1L;
            this._foundOffset = -1;
            this._foundLength = -1;
            this._foundStep = 0;
        }

        @Override
        public void sawVersion(long version, int offset, int valueLength) throws PersistitException {
            try {
                switch (this._usage) {
                    case FETCH: {
                        long ts = this._status != null ? this._status.getTs() : 0x7FFFFFFFFFFFFFFEL;
                        long status = this._ti.commitStatus(version, ts, this._step);
                        if (status < 0L || status == Long.MAX_VALUE || status < this._foundVersion) break;
                        assert (status <= ts);
                        int step = TransactionIndex.vh2step(version);
                        if (step >= this._foundStep || status > this._foundVersion) {
                            this._foundOffset = offset;
                            this._foundLength = valueLength;
                            this._foundVersion = status;
                            this._foundStep = step;
                        }
                        break;
                    }
                    case STORE: {
                        long depends = this._ti.wwDependency(version, this._status, 0L);
                        if (depends == -9223372036854775807L) {
                            throw new WWRetryException(version);
                        }
                        if (depends != 0L && depends != Long.MIN_VALUE) {
                            this._exchange._transaction.rollback();
                            throw new RollbackException();
                        }
                        if (version <= this._foundVersion) break;
                        this._foundVersion = version;
                    }
                }
            }
            catch (InterruptedException ie) {
                throw new PersistitInterruptedException(ie);
            }
        }

        static enum Usage {
            FETCH,
            STORE;

        }
    }

    public static enum Sequence {
        NONE,
        FORWARD,
        REVERSE;

    }
}

