/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.AlertMonitor;
import com.persistit.Exchange;
import com.persistit.IOTaskRunnable;
import com.persistit.Persistit;
import com.persistit.Tree;
import com.persistit.exception.PersistitException;
import com.persistit.mxbeans.CleanupManagerMXBean;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class CleanupManager
extends IOTaskRunnable
implements CleanupManagerMXBean {
    static final long DEFAULT_CLEANUP_INTERVAL_MS = 1000L;
    static final int DEFAULT_QUEUE_SIZE = 100000;
    private static final int WORKLIST_LENGTH = 2000;
    private static final long MINIMUM_MAINTENANCE_INTERVAL_NS = 1000000000L;
    private static final long MINIMUM_PRUNE_OBSOLETE_TRANSACTIONS_INTERVAL_NS = 2000000000L;
    private static final long DEFAULT_MINIMUM_PRUNING_DELAY_NS = 1000L;
    private final BlockingQueue<CleanupAction> _cleanupActionQueue = new ArrayBlockingQueue<CleanupAction>(100000);
    private final AtomicBoolean _closed = new AtomicBoolean();
    private final AtomicLong _accepted = new AtomicLong();
    private final AtomicLong _refused = new AtomicLong();
    private final AtomicLong _performed = new AtomicLong();
    private final AtomicLong _errors = new AtomicLong();
    private final AtomicLong _minimumPruningDelay = new AtomicLong(1000L);
    private long _lastMaintenance;
    private long _lastPruneObsoleteTransactions;

    CleanupManager(Persistit persistit) {
        super(persistit);
    }

    public void start() {
        long now;
        this._closed.set(false);
        this._lastMaintenance = now = System.nanoTime();
        this._lastPruneObsoleteTransactions = now;
        this.start("CLEANUP_MANAGER", 1000L);
    }

    public void close(boolean flush) throws PersistitException {
        this._closed.set(true);
    }

    @Override
    protected void runTask() throws Exception {
        this.poll();
    }

    @Override
    protected boolean shouldStop() {
        return this._closed.get();
    }

    synchronized boolean offer(CleanupAction action) {
        boolean accepted = this._cleanupActionQueue.offer(action);
        if (accepted) {
            this._accepted.incrementAndGet();
        } else {
            this._refused.incrementAndGet();
            this.kick();
        }
        return accepted;
    }

    @Override
    public long getAcceptedCount() {
        return this._accepted.get();
    }

    @Override
    public long getRefusedCount() {
        return this._refused.get();
    }

    @Override
    public long getPerformedCount() {
        return this._performed.get();
    }

    @Override
    public long getErrorCount() {
        return this._errors.get();
    }

    @Override
    public long getEnqueuedCount() {
        return this._cleanupActionQueue.size();
    }

    @Override
    public long getMinimumPruningDelay() {
        return this._minimumPruningDelay.get();
    }

    @Override
    public void setMinimumPruningDelay(long delay) {
        this._minimumPruningDelay.set(delay);
    }

    @Override
    public long pollInterval() {
        if (this._cleanupActionQueue.size() < 25000) {
            return super.getPollInterval();
        }
        return 0L;
    }

    @Override
    public void poll() throws Exception {
        long now = System.nanoTime();
        if (now - this._lastMaintenance > 1000000000L) {
            this._persistit.getIOMeter().poll();
            this._persistit.cleanup();
            this._lastMaintenance = now;
        }
        if (now - this._lastPruneObsoleteTransactions > 2000000000L) {
            this._persistit.getJournalManager().pruneObsoleteTransactions();
            this._lastPruneObsoleteTransactions = now;
        }
        ArrayList workList = new ArrayList(2000);
        this._cleanupActionQueue.drainTo(workList, 2000);
        Collections.sort(workList);
        for (CleanupAction action : workList) {
            try {
                action.performAction(this._persistit, null);
                this._performed.incrementAndGet();
            }
            catch (PersistitException e) {
                this.lastException(e);
                this._persistit.getAlertMonitor().post(new AlertMonitor.Event(AlertMonitor.AlertLevel.ERROR, this._persistit.getLogBase().cleanupException, e, action), "Cleanup");
                this._errors.incrementAndGet();
            }
        }
    }

    @Override
    public synchronized void clear() {
        this._cleanupActionQueue.clear();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (CleanupAction a : this._cleanupActionQueue) {
            if (sb.length() > 1) {
                sb.append(",\n ");
            }
            sb.append(a);
        }
        sb.append("]");
        return sb.toString();
    }

    static class CleanupIndexHole
    extends CleanupTreePage {
        int _level;

        CleanupIndexHole(int treeHandle, long page, int level) {
            super(treeHandle, page);
            this._level = level;
        }

        @Override
        public void performAction(Persistit persistit, List<CleanupAction> consequentActions) throws PersistitException {
            Exchange exchange = this.getExchange(persistit);
            if (exchange != null) {
                exchange.fixIndexHole(this._page, this._level);
            }
        }
    }

    static class CleanupPruneAction
    extends CleanupTreePage {
        CleanupPruneAction(int treeHandle, long page) {
            super(treeHandle, page);
        }

        @Override
        public void performAction(Persistit persistit, List<CleanupAction> consequentActions) throws PersistitException {
            Exchange exchange = this.getExchange(persistit);
            if (exchange != null) {
                exchange.prune(this._page, consequentActions);
            }
        }
    }

    static class CleanupAntiValue
    extends CleanupTreePage {
        CleanupAntiValue(int treeHandle, long page) {
            super(treeHandle, page);
        }

        @Override
        public void performAction(Persistit persistit, List<CleanupAction> consequentActions) throws PersistitException {
            Exchange exchange = this.getExchange(persistit);
            if (exchange != null) {
                exchange.pruneLeftEdgeValue(this._page, consequentActions);
            }
        }
    }

    static abstract class CleanupTreePage
    implements CleanupAction {
        private static final ThreadLocal<WeakReference<Exchange>> _exchangeThreadLocal = new ThreadLocal();
        final int _treeHandle;
        final long _page;

        protected CleanupTreePage(int treeHandle, long page) {
            this._treeHandle = treeHandle;
            this._page = page;
        }

        public boolean equals(Object other) {
            if (other instanceof CleanupTreePage) {
                CleanupTreePage a = (CleanupTreePage)other;
                return a._page == this._page && a._treeHandle == this._treeHandle && this.getClass().equals(a.getClass());
            }
            return false;
        }

        public int hashCode() {
            return (int)((long)this._treeHandle ^ this._page);
        }

        @Override
        public int compareTo(CleanupAction other) {
            if (other instanceof CleanupTreePage) {
                CleanupTreePage a = (CleanupTreePage)other;
                int d = this._treeHandle - a._treeHandle;
                if (d != 0) {
                    return d;
                }
                return this._page > a._page ? 1 : (this._page < a._page ? -1 : 0);
            }
            return -1;
        }

        public String toString() {
            return String.format("%s on page %,d tree handle [%,d]", this.getClass().getSimpleName(), this._page, this._treeHandle);
        }

        protected Exchange getExchange(Persistit persistit) throws PersistitException {
            Exchange exchange;
            Tree tree = persistit.getJournalManager().treeForHandle(this._treeHandle);
            if (tree == null) {
                return null;
            }
            WeakReference<Exchange> ref = _exchangeThreadLocal.get();
            if (ref != null && (exchange = (Exchange)ref.get()) != null) {
                exchange.init(tree);
                return exchange;
            }
            exchange = new Exchange(tree);
            _exchangeThreadLocal.set(new WeakReference<Exchange>(exchange));
            return exchange;
        }
    }

    static interface CleanupAction
    extends Comparable<CleanupAction> {
        public void performAction(Persistit var1, List<CleanupAction> var2) throws PersistitException;
    }
}

