/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.forgerock.i18n.LocalizableMessage;

public final class LocalizableMessageBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -3292823563904285315L;
    private final List<LocalizableMessage> messages = new LinkedList<LocalizableMessage>();

    public LocalizableMessageBuilder() {
    }

    public LocalizableMessageBuilder(LocalizableMessage message) {
        this.append(message);
    }

    public LocalizableMessageBuilder(LocalizableMessageBuilder builder) {
        for (LocalizableMessage message : builder.messages) {
            this.messages.add(message);
        }
    }

    public LocalizableMessageBuilder(Object object) {
        this.append(object);
    }

    @Override
    public LocalizableMessageBuilder append(char c) {
        return this.append(LocalizableMessage.valueOf(Character.valueOf(c)));
    }

    @Override
    public LocalizableMessageBuilder append(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException("cs was null");
        }
        return this.append((Object)cs);
    }

    @Override
    public LocalizableMessageBuilder append(CharSequence cs, int start, int end) {
        return this.append(cs.subSequence(start, end));
    }

    public LocalizableMessageBuilder append(int value) {
        return this.append(LocalizableMessage.valueOf(value));
    }

    public LocalizableMessageBuilder append(LocalizableMessage message) {
        if (message == null) {
            throw new NullPointerException("message was null");
        }
        this.messages.add(message);
        return this;
    }

    public LocalizableMessageBuilder append(Object object) {
        return this.append(LocalizableMessage.valueOf(object));
    }

    @Override
    public char charAt(int index) {
        return this.charAt(Locale.getDefault(), index);
    }

    public char charAt(Locale locale, int index) {
        return this.toString(locale).charAt(index);
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public CharSequence subSequence(Locale locale, int start, int end) {
        return this.toString(locale).subSequence(start, end);
    }

    public LocalizableMessage toMessage() {
        if (this.messages.isEmpty()) {
            return LocalizableMessage.EMPTY;
        }
        int sz = this.messages.size();
        StringBuffer fmtString = new StringBuffer(sz * 2);
        for (int i = 0; i < sz; ++i) {
            fmtString.append("%s");
        }
        return LocalizableMessage.raw(fmtString, this.messages.toArray());
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        StringBuilder builder = new StringBuilder();
        for (LocalizableMessage message : this.messages) {
            builder.append(message.toString(locale));
        }
        return builder.toString();
    }
}

