/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.SoftReferenceEntryCacheCfgClient;
import org.forgerock.opendj.server.config.meta.EntryCacheCfgDefn;
import org.forgerock.opendj.server.config.server.EntryCacheCfg;
import org.forgerock.opendj.server.config.server.SoftReferenceEntryCacheCfg;

public final class SoftReferenceEntryCacheCfgDefn
extends ManagedObjectDefinition<SoftReferenceEntryCacheCfgClient, SoftReferenceEntryCacheCfg> {
    private static final SoftReferenceEntryCacheCfgDefn INSTANCE = new SoftReferenceEntryCacheCfgDefn();
    private static final StringPropertyDefinition PD_EXCLUDE_FILTER;
    private static final StringPropertyDefinition PD_INCLUDE_FILTER;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final DurationPropertyDefinition PD_LOCK_TIMEOUT;

    public static SoftReferenceEntryCacheCfgDefn getInstance() {
        return INSTANCE;
    }

    private SoftReferenceEntryCacheCfgDefn() {
        super("soft-reference-entry-cache", EntryCacheCfgDefn.getInstance());
    }

    @Override
    public SoftReferenceEntryCacheCfgClient createClientConfiguration(ManagedObject<? extends SoftReferenceEntryCacheCfgClient> impl) {
        return new SoftReferenceEntryCacheCfgClientImpl(impl);
    }

    @Override
    public SoftReferenceEntryCacheCfg createServerConfiguration(ServerManagedObject<? extends SoftReferenceEntryCacheCfg> impl) {
        return new SoftReferenceEntryCacheCfgServerImpl(impl);
    }

    @Override
    public Class<SoftReferenceEntryCacheCfg> getServerConfigurationClass() {
        return SoftReferenceEntryCacheCfg.class;
    }

    public IntegerPropertyDefinition getCacheLevelPropertyDefinition() {
        return EntryCacheCfgDefn.getInstance().getCacheLevelPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return EntryCacheCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public StringPropertyDefinition getExcludeFilterPropertyDefinition() {
        return PD_EXCLUDE_FILTER;
    }

    public StringPropertyDefinition getIncludeFilterPropertyDefinition() {
        return PD_INCLUDE_FILTER;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public DurationPropertyDefinition getLockTimeoutPropertyDefinition() {
        return PD_LOCK_TIMEOUT;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "exclude-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "exclude-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_EXCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_EXCLUDE_FILTER);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "include-filter");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "include-filter"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_INCLUDE_FILTER = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INCLUDE_FILTER);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.extensions.SoftReferenceEntryCache");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.EntryCache");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "lock-timeout");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "lock-timeout"));
        provider = new DefinedDefaultBehaviorProvider("3000ms");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setAllowUnlimited(true);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("0");
        PD_LOCK_TIMEOUT = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOCK_TIMEOUT);
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class SoftReferenceEntryCacheCfgServerImpl
    implements SoftReferenceEntryCacheCfg {
        private ServerManagedObject<? extends SoftReferenceEntryCacheCfg> impl;
        private final int pCacheLevel;
        private final boolean pEnabled;
        private final SortedSet<String> pExcludeFilter;
        private final SortedSet<String> pIncludeFilter;
        private final String pJavaClass;
        private final long pLockTimeout;

        private SoftReferenceEntryCacheCfgServerImpl(ServerManagedObject<? extends SoftReferenceEntryCacheCfg> impl) {
            this.impl = impl;
            this.pCacheLevel = impl.getPropertyValue(INSTANCE.getCacheLevelPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pExcludeFilter = impl.getPropertyValues((PropertyDefinition)INSTANCE.getExcludeFilterPropertyDefinition());
            this.pIncludeFilter = impl.getPropertyValues((PropertyDefinition)INSTANCE.getIncludeFilterPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLockTimeout = impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
        }

        @Override
        public void addSoftReferenceChangeListener(ConfigurationChangeListener<SoftReferenceEntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeSoftReferenceChangeListener(ConfigurationChangeListener<SoftReferenceEntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<EntryCacheCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public int getCacheLevel() {
            return this.pCacheLevel;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.pExcludeFilter;
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.pIncludeFilter;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public long getLockTimeout() {
            return this.pLockTimeout;
        }

        @Override
        public Class<? extends SoftReferenceEntryCacheCfg> configurationClass() {
            return SoftReferenceEntryCacheCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class SoftReferenceEntryCacheCfgClientImpl
    implements SoftReferenceEntryCacheCfgClient {
        private ManagedObject<? extends SoftReferenceEntryCacheCfgClient> impl;

        private SoftReferenceEntryCacheCfgClientImpl(ManagedObject<? extends SoftReferenceEntryCacheCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Integer getCacheLevel() {
            return this.impl.getPropertyValue(INSTANCE.getCacheLevelPropertyDefinition());
        }

        @Override
        public void setCacheLevel(int value) {
            this.impl.setPropertyValue(INSTANCE.getCacheLevelPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getExcludeFilter() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getExcludeFilterPropertyDefinition());
        }

        @Override
        public void setExcludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getExcludeFilterPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getIncludeFilter() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getIncludeFilterPropertyDefinition());
        }

        @Override
        public void setIncludeFilter(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getIncludeFilterPropertyDefinition(), values);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public long getLockTimeout() {
            return this.impl.getPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition());
        }

        @Override
        public void setLockTimeout(Long value) {
            this.impl.setPropertyValue(INSTANCE.getLockTimeoutPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends SoftReferenceEntryCacheCfgClient, ? extends SoftReferenceEntryCacheCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

