/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.KeyManagerProviderCfgClient;
import org.forgerock.opendj.server.config.client.ServiceDiscoveryMechanismCfgClient;
import org.forgerock.opendj.server.config.client.TrustManagerProviderCfgClient;
import org.forgerock.opendj.server.config.server.KeyManagerProviderCfg;
import org.forgerock.opendj.server.config.server.ServiceDiscoveryMechanismCfg;
import org.forgerock.opendj.server.config.server.TrustManagerProviderCfg;

public final class ServiceDiscoveryMechanismCfgDefn
extends ManagedObjectDefinition<ServiceDiscoveryMechanismCfgClient, ServiceDiscoveryMechanismCfg> {
    private static final ServiceDiscoveryMechanismCfgDefn INSTANCE = new ServiceDiscoveryMechanismCfgDefn();
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> PD_KEY_MANAGER_PROVIDER;
    private static final StringPropertyDefinition PD_SSL_CERT_NICKNAME;
    private static final AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> PD_TRUST_MANAGER_PROVIDER;
    private static final BooleanPropertyDefinition PD_USE_SSL;
    private static final BooleanPropertyDefinition PD_USE_START_TLS;

    public static ServiceDiscoveryMechanismCfgDefn getInstance() {
        return INSTANCE;
    }

    private ServiceDiscoveryMechanismCfgDefn() {
        super("service-discovery-mechanism", TopCfgDefn.getInstance());
    }

    @Override
    public ServiceDiscoveryMechanismCfgClient createClientConfiguration(ManagedObject<? extends ServiceDiscoveryMechanismCfgClient> impl) {
        return new ServiceDiscoveryMechanismCfgClientImpl(impl);
    }

    @Override
    public ServiceDiscoveryMechanismCfg createServerConfiguration(ServerManagedObject<? extends ServiceDiscoveryMechanismCfg> impl) {
        return new ServiceDiscoveryMechanismCfgServerImpl(impl);
    }

    @Override
    public Class<ServiceDiscoveryMechanismCfg> getServerConfigurationClass() {
        return ServiceDiscoveryMechanismCfg.class;
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public AggregationPropertyDefinition<KeyManagerProviderCfgClient, KeyManagerProviderCfg> getKeyManagerProviderPropertyDefinition() {
        return PD_KEY_MANAGER_PROVIDER;
    }

    public StringPropertyDefinition getSSLCertNicknamePropertyDefinition() {
        return PD_SSL_CERT_NICKNAME;
    }

    public AggregationPropertyDefinition<TrustManagerProviderCfgClient, TrustManagerProviderCfg> getTrustManagerProviderPropertyDefinition() {
        return PD_TRUST_MANAGER_PROVIDER;
    }

    public BooleanPropertyDefinition getUseSSLPropertyDefinition() {
        return PD_USE_SSL;
    }

    public BooleanPropertyDefinition getUseStartTLSPropertyDefinition() {
        return PD_USE_START_TLS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "java-class"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.backends.proxy.ServiceDiscoveryMechanism");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "key-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-manager-provider"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("key-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.or(Conditions.contains("use-ssl", "true"), Conditions.contains("use-start-tls", "true")));
        PD_KEY_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_KEY_MANAGER_PROVIDER.getSourceConstraint());
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "ssl-cert-nickname");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "ssl-cert-nickname"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "ssl-cert-nickname"));
        PD_SSL_CERT_NICKNAME = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SSL_CERT_NICKNAME);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "trust-manager-provider");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "trust-manager-provider"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "trust-manager-provider"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("trust-manager-provider");
        ((AggregationPropertyDefinition.Builder)builder).setTargetNeedsEnablingCondition(Conditions.or(Conditions.contains("use-ssl", "true"), Conditions.contains("use-start-tls", "true")));
        PD_TRUST_MANAGER_PROVIDER = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TRUST_MANAGER_PROVIDER);
        INSTANCE.registerConstraint(PD_TRUST_MANAGER_PROVIDER.getSourceConstraint());
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-ssl");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "use-ssl"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_SSL = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_SSL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "use-start-tls");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "use-start-tls"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_USE_START_TLS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_USE_START_TLS);
        INSTANCE.registerTag(Tag.valueOf("service-discovery"));
    }

    private static class ServiceDiscoveryMechanismCfgServerImpl
    implements ServiceDiscoveryMechanismCfg {
        private ServerManagedObject<? extends ServiceDiscoveryMechanismCfg> impl;
        private final String pJavaClass;
        private final String pKeyManagerProvider;
        private final SortedSet<String> pSSLCertNickname;
        private final String pTrustManagerProvider;
        private final boolean pUseSSL;
        private final boolean pUseStartTLS;

        private ServiceDiscoveryMechanismCfgServerImpl(ServerManagedObject<? extends ServiceDiscoveryMechanismCfg> impl) {
            this.impl = impl;
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyManagerProvider = impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
            this.pSSLCertNickname = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
            this.pTrustManagerProvider = impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
            this.pUseSSL = impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
            this.pUseStartTLS = impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<ServiceDiscoveryMechanismCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyManagerProvider() {
            return this.pKeyManagerProvider;
        }

        @Override
        public DN getKeyManagerProviderDN() {
            String value = this.getKeyManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getKeyManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.pSSLCertNickname;
        }

        @Override
        public String getTrustManagerProvider() {
            return this.pTrustManagerProvider;
        }

        @Override
        public DN getTrustManagerProviderDN() {
            String value = this.getTrustManagerProvider();
            if (value == null) {
                return null;
            }
            return INSTANCE.getTrustManagerProviderPropertyDefinition().getChildDN(value);
        }

        @Override
        public boolean isUseSSL() {
            return this.pUseSSL;
        }

        @Override
        public boolean isUseStartTLS() {
            return this.pUseStartTLS;
        }

        @Override
        public Class<? extends ServiceDiscoveryMechanismCfg> configurationClass() {
            return ServiceDiscoveryMechanismCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class ServiceDiscoveryMechanismCfgClientImpl
    implements ServiceDiscoveryMechanismCfgClient {
        private ManagedObject<? extends ServiceDiscoveryMechanismCfgClient> impl;

        private ServiceDiscoveryMechanismCfgClientImpl(ManagedObject<? extends ServiceDiscoveryMechanismCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition());
        }

        @Override
        public void setKeyManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyManagerProviderPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getSSLCertNickname() {
            return this.impl.getPropertyValues((PropertyDefinition)INSTANCE.getSSLCertNicknamePropertyDefinition());
        }

        @Override
        public void setSSLCertNickname(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getSSLCertNicknamePropertyDefinition(), values);
        }

        @Override
        public String getTrustManagerProvider() {
            return this.impl.getPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition());
        }

        @Override
        public void setTrustManagerProvider(String value) {
            this.impl.setPropertyValue(INSTANCE.getTrustManagerProviderPropertyDefinition(), value);
        }

        @Override
        public boolean isUseSSL() {
            return this.impl.getPropertyValue(INSTANCE.getUseSSLPropertyDefinition());
        }

        @Override
        public void setUseSSL(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseSSLPropertyDefinition(), value);
        }

        @Override
        public boolean isUseStartTLS() {
            return this.impl.getPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition());
        }

        @Override
        public void setUseStartTLS(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getUseStartTLSPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends ServiceDiscoveryMechanismCfgClient, ? extends ServiceDiscoveryMechanismCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

