/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.HTTPAuthorizationMechanismCfgClient;
import org.forgerock.opendj.server.config.client.Rest2ldapEndpointCfgClient;
import org.forgerock.opendj.server.config.meta.HTTPEndpointCfgDefn;
import org.forgerock.opendj.server.config.server.HTTPAuthorizationMechanismCfg;
import org.forgerock.opendj.server.config.server.HTTPEndpointCfg;
import org.forgerock.opendj.server.config.server.Rest2ldapEndpointCfg;

public final class Rest2ldapEndpointCfgDefn
extends ManagedObjectDefinition<Rest2ldapEndpointCfgClient, Rest2ldapEndpointCfg> {
    private static final Rest2ldapEndpointCfgDefn INSTANCE = new Rest2ldapEndpointCfgDefn();
    private static final StringPropertyDefinition PD_CONFIG_DIRECTORY;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;

    public static Rest2ldapEndpointCfgDefn getInstance() {
        return INSTANCE;
    }

    private Rest2ldapEndpointCfgDefn() {
        super("rest2ldap-endpoint", HTTPEndpointCfgDefn.getInstance());
    }

    @Override
    public Rest2ldapEndpointCfgClient createClientConfiguration(ManagedObject<? extends Rest2ldapEndpointCfgClient> impl) {
        return new Rest2ldapEndpointCfgClientImpl(impl);
    }

    @Override
    public Rest2ldapEndpointCfg createServerConfiguration(ServerManagedObject<? extends Rest2ldapEndpointCfg> impl) {
        return new Rest2ldapEndpointCfgServerImpl(impl);
    }

    @Override
    public Class<Rest2ldapEndpointCfg> getServerConfigurationClass() {
        return Rest2ldapEndpointCfg.class;
    }

    public AggregationPropertyDefinition<HTTPAuthorizationMechanismCfgClient, HTTPAuthorizationMechanismCfg> getAuthorizationMechanismPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getAuthorizationMechanismPropertyDefinition();
    }

    public StringPropertyDefinition getBasePathPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getBasePathPropertyDefinition();
    }

    public StringPropertyDefinition getConfigDirectoryPropertyDefinition() {
        return PD_CONFIG_DIRECTORY;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return HTTPEndpointCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = StringPropertyDefinition.createBuilder(INSTANCE, "config-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "config-directory"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DIRECTORY");
        PD_CONFIG_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CONFIG_DIRECTORY);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("org.opends.server.protocols.http.rest2ldap.Rest2LdapEndpoint");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.HttpEndpoint");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    private static class Rest2ldapEndpointCfgServerImpl
    implements Rest2ldapEndpointCfg {
        private ServerManagedObject<? extends Rest2ldapEndpointCfg> impl;
        private final SortedSet<String> pAuthorizationMechanism;
        private final String pBasePath;
        private final String pConfigDirectory;
        private final boolean pEnabled;
        private final String pJavaClass;

        private Rest2ldapEndpointCfgServerImpl(ServerManagedObject<? extends Rest2ldapEndpointCfg> impl) {
            this.impl = impl;
            this.pAuthorizationMechanism = impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
            this.pBasePath = impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
            this.pConfigDirectory = impl.getPropertyValue(INSTANCE.getConfigDirectoryPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void addRest2ldapEndpointChangeListener(ConfigurationChangeListener<Rest2ldapEndpointCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeRest2ldapEndpointChangeListener(ConfigurationChangeListener<Rest2ldapEndpointCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<HTTPEndpointCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.pAuthorizationMechanism;
        }

        @Override
        public SortedSet<DN> getAuthorizationMechanismDNs() {
            SortedSet<String> values = this.getAuthorizationMechanism();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getAuthorizationMechanismPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public String getBasePath() {
            return this.pBasePath;
        }

        @Override
        public String getConfigDirectory() {
            return this.pConfigDirectory;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public Class<? extends Rest2ldapEndpointCfg> configurationClass() {
            return Rest2ldapEndpointCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        @Override
        public String name() {
            return this.impl.getName();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class Rest2ldapEndpointCfgClientImpl
    implements Rest2ldapEndpointCfgClient {
        private ManagedObject<? extends Rest2ldapEndpointCfgClient> impl;

        private Rest2ldapEndpointCfgClientImpl(ManagedObject<? extends Rest2ldapEndpointCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public SortedSet<String> getAuthorizationMechanism() {
            return this.impl.getPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition());
        }

        @Override
        public void setAuthorizationMechanism(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getAuthorizationMechanismPropertyDefinition(), values);
        }

        @Override
        public String getBasePath() {
            return this.impl.getPropertyValue(INSTANCE.getBasePathPropertyDefinition());
        }

        @Override
        public void setBasePath(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getBasePathPropertyDefinition(), value);
        }

        @Override
        public String getConfigDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getConfigDirectoryPropertyDefinition());
        }

        @Override
        public void setConfigDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getConfigDirectoryPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends Rest2ldapEndpointCfgClient, ? extends Rest2ldapEndpointCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

