/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.spi.ConfigAddListener;
import org.forgerock.opendj.config.server.spi.ConfigDeleteListener;
import org.forgerock.opendj.config.server.spi.ConfigurationRepository;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DelayedConfigAddListener
implements ConfigAddListener {
    private static final Logger debugLogger = LoggerFactory.getLogger(DelayedConfigAddListener.class);
    private final DN parent;
    private final DN child;
    private final ConfigAddListener delayedAddListener;
    private final ConfigDeleteListener delayedDeleteListener;
    private final ConfigurationRepository configRepository;

    public DelayedConfigAddListener(DN child, ConfigAddListener addListener, ConfigurationRepository configRepository) {
        this.parent = child.parent();
        this.child = child;
        this.delayedAddListener = addListener;
        this.delayedDeleteListener = null;
        this.configRepository = configRepository;
    }

    public DelayedConfigAddListener(DN child, ConfigDeleteListener deleteListener, ConfigurationRepository configRepository) {
        this.parent = child.parent();
        this.child = child;
        this.delayedAddListener = null;
        this.configRepository = configRepository;
        this.delayedDeleteListener = deleteListener;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(Entry configEntry) {
        if (configEntry.getName().equals((Object)this.child)) {
            if (this.delayedAddListener != null) {
                this.configRepository.registerAddListener(configEntry.getName(), this.delayedAddListener);
            }
            if (this.delayedDeleteListener != null) {
                this.configRepository.registerDeleteListener(configEntry.getName(), this.delayedDeleteListener);
            }
            try {
                if (this.configRepository.hasEntry(this.parent)) {
                    this.configRepository.deregisterAddListener(this.parent, this);
                }
            }
            catch (ConfigException e) {
                debugLogger.trace("Unable to deregister add listener", (Throwable)e);
            }
        }
        return new ConfigChangeResult();
    }

    @Override
    public boolean configAddIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
        return true;
    }

    ConfigAddListener getDelayedAddListener() {
        return this.delayedAddListener;
    }

    ConfigDeleteListener getDelayedDeleteListener() {
        return this.delayedDeleteListener;
    }
}

