/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.server.AbstractConfigListenerAdaptor;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.DNBuilder;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectDeleteListener;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.config.server.spi.ConfigDeleteListener;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ResultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigDeleteListenerAdaptor<S extends Configuration>
extends AbstractConfigListenerAdaptor
implements ConfigDeleteListener {
    private static final Logger debugLogger = LoggerFactory.getLogger(ConfigDeleteListenerAdaptor.class);
    private ServerManagedObject<? extends S> cachedManagedObject;
    private final InstantiableRelationDefinition<?, S> instantiableRelation;
    private final SetRelationDefinition<?, S> setRelation;
    private final ServerManagedObjectDeleteListener<S> listener;
    private final OptionalRelationDefinition<?, S> optionalRelation;
    private final ManagedObjectPath<?, ?> path;
    private final ServerManagementContext serverContext;

    public ConfigDeleteListenerAdaptor(ServerManagementContext serverContext, ManagedObjectPath<?, ?> path, InstantiableRelationDefinition<?, S> relation, ServerManagedObjectDeleteListener<S> listener) {
        this.serverContext = serverContext;
        this.path = path;
        this.optionalRelation = null;
        this.instantiableRelation = relation;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigDeleteListenerAdaptor(ServerManagementContext serverContext, ManagedObjectPath<?, ?> path, OptionalRelationDefinition<?, S> relation, ServerManagedObjectDeleteListener<S> listener) {
        this.serverContext = serverContext;
        this.path = path;
        this.optionalRelation = relation;
        this.instantiableRelation = null;
        this.setRelation = null;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    public ConfigDeleteListenerAdaptor(ServerManagementContext serverContext, ManagedObjectPath<?, ?> path, SetRelationDefinition<?, S> relation, ServerManagedObjectDeleteListener<S> listener) {
        this.serverContext = serverContext;
        this.path = path;
        this.optionalRelation = null;
        this.instantiableRelation = null;
        this.setRelation = relation;
        this.listener = listener;
        this.cachedManagedObject = null;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(Entry configEntry) {
        ConfigChangeResult result;
        if (this.optionalRelation != null) {
            ManagedObjectPath<?, S> childPath = this.path.child(this.optionalRelation);
            DN expectedDN = DNBuilder.create(childPath);
            if (!configEntry.getName().equals((Object)expectedDN)) {
                return new ConfigChangeResult();
            }
        }
        if ((result = this.listener.applyConfigurationDelete(this.cachedManagedObject)).getResultCode() == ResultCode.SUCCESS) {
            ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
            for (Constraint constraint : d.getAllConstraints()) {
                for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                    try {
                        handler.performPostDelete(this.cachedManagedObject);
                    }
                    catch (ConfigException e) {
                        debugLogger.trace("Unable to perform post delete", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean configDeleteIsAcceptable(Entry configEntry, LocalizableMessageBuilder unacceptableReason) {
        DN dn = configEntry.getName();
        String name = dn.rdn().getFirstAVA().getAttributeValue().toString().trim();
        try {
            ManagedObjectPath<?, S> childPath;
            if (this.instantiableRelation != null) {
                childPath = this.path.child(this.instantiableRelation, name);
            } else if (this.setRelation != null) {
                try {
                    childPath = this.path.child(this.setRelation, name);
                }
                catch (IllegalArgumentException e) {
                    throw new DefinitionDecodingException(this.setRelation.getChildDefinition(), DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION);
                }
            } else {
                childPath = this.path.child(this.optionalRelation);
                DN expectedDN = DNBuilder.create(childPath);
                if (!dn.equals((Object)expectedDN)) {
                    return true;
                }
            }
            this.cachedManagedObject = this.serverContext.decode(childPath, configEntry);
        }
        catch (DecodingException e) {
            unacceptableReason.append(e.getMessageObject());
            return false;
        }
        LinkedList<LocalizableMessage> reasons = new LinkedList<LocalizableMessage>();
        boolean isDeleteAllowed = true;
        ManagedObjectDefinition<?, S> d = this.cachedManagedObject.getManagedObjectDefinition();
        for (Constraint constraint : d.getAllConstraints()) {
            for (ServerConstraintHandler handler : constraint.getServerConstraintHandlers()) {
                try {
                    if (handler.isDeleteAllowed(this.cachedManagedObject, reasons)) continue;
                    isDeleteAllowed = false;
                }
                catch (ConfigException e) {
                    LocalizableMessage message = ConfigMessages.ERR_SERVER_CONSTRAINT_EXCEPTION.get((Object)e.getMessageObject());
                    reasons.add(message);
                    isDeleteAllowed = false;
                }
            }
        }
        if (!isDeleteAllowed) {
            this.generateUnacceptableReason(reasons, unacceptableReason);
            return false;
        }
        if (this.listener.isConfigurationDeleteAcceptable(this.cachedManagedObject, reasons)) {
            return true;
        }
        this.generateUnacceptableReason(reasons, unacceptableReason);
        return false;
    }

    ServerManagedObjectDeleteListener<S> getServerManagedObjectDeleteListener() {
        return this.listener;
    }
}

