/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.Menu;
import com.forgerock.opendj.cli.MenuBuilder;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.TabSeparatedTablePrinter;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationUnit;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.ManagedObjectPathSerializer;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.SizeUnit;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.CLIProfile;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;

abstract class SubCommandHandler
implements Comparable<SubCommandHandler> {
    public static final int MULTI_COLUMN_THRESHOLD = 8;
    private static final String OPTION_DSCFG_LONG_PROPERTY = "property";
    private static final String OPTION_DSCFG_LONG_RECORD = "record";
    private static final String OPTION_DSCFG_LONG_UNIT_SIZE = "unit-size";
    private static final String OPTION_DSCFG_LONG_UNIT_TIME = "unit-time";
    private static final Character OPTION_DSCFG_SHORT_PROPERTY = null;
    private static final char OPTION_DSCFG_SHORT_RECORD = 'E';
    private static final char OPTION_DSCFG_SHORT_UNIT_SIZE = 'z';
    private static final char OPTION_DSCFG_SHORT_UNIT_TIME = 'm';
    private StringArgument propertyArgument;
    private BooleanArgument recordModeArgument;
    private StringArgument unitSizeArgument;
    private StringArgument unitTimeArgument;
    private final Set<Tag> tags = new HashSet<Tag>();
    private CommandBuilder commandBuilder;
    private boolean isCommandBuilderUseful = true;

    protected SubCommandHandler() {
    }

    @Override
    public final int compareTo(SubCommandHandler o) {
        String s1 = this.getSubCommand().getName();
        String s2 = o.getSubCommand().getName();
        return s1.compareTo(s2);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SubCommandHandler) {
            SubCommandHandler other = (SubCommandHandler)obj;
            String s1 = this.getSubCommand().getName();
            String s2 = other.getSubCommand().getName();
            return s1.equals(s2);
        }
        return false;
    }

    public abstract SubCommand getSubCommand();

    public final CommandBuilder getCommandBuilder() {
        if (this.commandBuilder == null) {
            this.commandBuilder = new CommandBuilder(System.getProperty("org.opends.server.scriptName"), this.getSubCommand().getName());
        }
        return this.commandBuilder;
    }

    public final boolean isCommandBuilderUseful() {
        return this.isCommandBuilderUseful;
    }

    protected final void setCommandBuilderUseful(boolean isCommandBuilderUseful) {
        this.isCommandBuilderUseful = isCommandBuilderUseful;
    }

    public final Set<Tag> getTags() {
        return this.tags;
    }

    public final int hashCode() {
        return this.getSubCommand().getName().hashCode();
    }

    public abstract MenuResult<Integer> run(ConsoleApplication var1, LDAPManagementContextFactory var2) throws ArgumentException, ClientException;

    public final String toString() {
        return this.getSubCommand().getName();
    }

    protected final void addTags(Collection<Tag> tags) {
        this.tags.addAll(tags);
    }

    protected final List<StringArgument> createNamingArgs(SubCommand subCommand, ManagedObjectPath<?, ?> p, boolean isCreate) throws ArgumentException {
        return NamingArgumentBuilder.create(subCommand, p, isCreate);
    }

    protected final TablePrinter createScriptFriendlyTablePrinter(PrintStream stream) {
        return new TabSeparatedTablePrinter((OutputStream)stream);
    }

    protected final MenuResult<ManagedObject<?>> getManagedObject(ConsoleApplication app, ManagementContext context, ManagedObjectPath<?, ?> path, List<String> args) throws ClientException, AuthorizationException, DefinitionDecodingException, ManagedObjectDecodingException, ConcurrentModificationException, ManagedObjectNotFoundException, LdapException {
        ManagedObjectFinder finder = new ManagedObjectFinder();
        return finder.find(app, context, path, args);
    }

    protected final List<String> getNamingArgValues(ConsoleApplication app, List<StringArgument> namingArgs) throws ArgumentException {
        ArrayList<String> values = new ArrayList<String>(namingArgs.size());
        for (StringArgument arg : namingArgs) {
            String value = arg.getValue();
            if (value == null && !app.isInteractive()) {
                throw ArgumentExceptionFactory.missingMandatoryNonInteractiveArgument((Argument)arg);
            }
            values.add(value);
        }
        return values;
    }

    protected final Set<String> getPropertyNames() {
        if (this.propertyArgument != null) {
            return new LinkedHashSet<String>(this.propertyArgument.getValues());
        }
        return Collections.emptySet();
    }

    protected final SizeUnit getSizeUnit() throws ArgumentException {
        String value;
        if (this.unitSizeArgument != null && (value = this.unitSizeArgument.getValue()) != null) {
            try {
                return SizeUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                LocalizableMessage msg = DsconfigMessages.INFO_DSCFG_ERROR_SIZE_UNIT_UNRECOGNIZED.get((Object)value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final DurationUnit getTimeUnit() throws ArgumentException {
        String value;
        if (this.unitTimeArgument != null && (value = this.unitTimeArgument.getValue()) != null) {
            try {
                return DurationUnit.getUnit(value);
            }
            catch (IllegalArgumentException e) {
                LocalizableMessage msg = DsconfigMessages.INFO_DSCFG_ERROR_TIME_UNIT_UNRECOGNIZED.get((Object)value);
                throw new ArgumentException(msg);
            }
        }
        return null;
    }

    protected final boolean isRecordMode() {
        return this.recordModeArgument != null && this.recordModeArgument.isPresent();
    }

    protected final <C extends ConfigurationClient, S extends Configuration> MenuResult<String> readChildName(ConsoleApplication app, ManagedObject<?> parent, RelationDefinition<C, S> r, AbstractManagedObjectDefinition<? extends C, ? extends S> d) throws AuthorizationException, ConcurrentModificationException, ClientException {
        AbstractManagedObjectDefinition cd;
        if (d == null) {
            d = r.getChildDefinition();
        }
        app.println();
        app.println();
        String[] childNames = null;
        try {
            childNames = r instanceof InstantiableRelationDefinition ? parent.listChildren((InstantiableRelationDefinition)r, d) : parent.listChildren((SetRelationDefinition)r, d);
        }
        catch (LdapException e) {
            System.out.println(String.format("An error occured %s", e.getMessage()));
        }
        TreeMap<String, String> children = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String childName : childNames) {
            try {
                ManagedObject child = r instanceof InstantiableRelationDefinition ? parent.getChild((InstantiableRelationDefinition)r, childName) : parent.getChild((SetRelationDefinition)r, childName);
                cd = child.getManagedObjectDefinition();
                if (SubCommandHandler.cannotDisplay(app, cd, null)) continue;
                if (r instanceof InstantiableRelationDefinition) {
                    children.put(childName, childName);
                    continue;
                }
                children.put(cd.getUserFriendlyName().toString(), childName);
            }
            catch (DefinitionDecodingException | ManagedObjectDecodingException | LdapException e) {
                children.put(childName, childName);
            }
            catch (ManagedObjectNotFoundException e) {
                // empty catch block
            }
        }
        switch (children.size()) {
            case 0: {
                app.errPrintln(DsconfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get((Object)d.getUserFriendlyPluralName()));
                return MenuResult.cancel();
            }
            case 1: {
                LocalizableMessage msg = DsconfigMessages.INFO_DSCFG_FINDER_PROMPT_SINGLE.get((Object)d.getUserFriendlyName(), children.firstKey());
                if (app.confirmAction(msg, true)) {
                    try {
                        String argName = CLIProfile.getInstance().getNamingArgument(r);
                        StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)argName).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildArgument();
                        if (r instanceof InstantiableRelationDefinition) {
                            arg.addValue((String)children.get(children.firstKey()));
                        } else {
                            String friendlyName = (String)children.firstKey();
                            String shortName = (String)children.get(friendlyName);
                            try {
                                cd = null;
                                try {
                                    cd = d.getChild(shortName);
                                }
                                catch (IllegalArgumentException e) {
                                    cd = d.getChild(friendlyName);
                                }
                                arg.addValue(SubCommandHandler.getShortTypeName(r.getChildDefinition(), cd));
                            }
                            catch (IllegalArgumentException e) {
                                arg.addValue(shortName);
                            }
                        }
                        this.getCommandBuilder().addArgument((Argument)arg);
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Unexpected exception: " + t, t);
                    }
                    return MenuResult.success((Object)((String)children.get(children.firstKey())));
                }
                return MenuResult.cancel();
            }
        }
        MenuBuilder builder = new MenuBuilder(app);
        builder.setMultipleColumnThreshold(8);
        builder.setPrompt(DsconfigMessages.INFO_DSCFG_FINDER_PROMPT_MANY.get((Object)d.getUserFriendlyName()));
        for (Map.Entry child : children.entrySet()) {
            LocalizableMessage option = LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{child.getKey()});
            builder.addNumberedOption(option, MenuResult.success((Object)((String)child.getValue())), new LocalizableMessage[0]);
        }
        if (app.isMenuDrivenMode()) {
            builder.addCancelOption(true);
        }
        builder.addQuitOption();
        Menu menu = builder.toMenu();
        MenuResult result = menu.run();
        try {
            if (result.getValue() == null) {
                return MenuResult.cancel();
            }
            String argName = CLIProfile.getInstance().getNamingArgument(r);
            StringArgument arg = ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)argName).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildArgument();
            if (r instanceof InstantiableRelationDefinition) {
                arg.addValue((String)result.getValue());
            } else {
                String longName = (String)result.getValue();
                try {
                    AbstractManagedObjectDefinition<Object, Object> cd2 = d.getChild(longName);
                    arg.addValue(SubCommandHandler.getShortTypeName(r.getChildDefinition(), cd2));
                }
                catch (IllegalArgumentException e) {
                    arg.addValue((String)children.get(result.getValue()));
                }
            }
            this.getCommandBuilder().addArgument((Argument)arg);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected exception: " + t, t);
        }
        return result;
    }

    static boolean cannotDisplay(ConsoleApplication app, AbstractManagedObjectDefinition<?, ?> defn, Tag tag) {
        return defn.hasOption(ManagedObjectOption.HIDDEN) || !app.isAdvancedMode() && defn.hasOption(ManagedObjectOption.ADVANCED) || tag != null && !defn.hasTag(tag);
    }

    static boolean cannotDisplay(ConsoleApplication app, PropertyDefinition<?> pd, Set<String> allowedPropertyNames) {
        return pd.hasOption(PropertyOption.HIDDEN) || !app.isAdvancedMode() && pd.hasOption(PropertyOption.ADVANCED) || !allowedPropertyNames.isEmpty() && !allowedPropertyNames.contains(pd.getName());
    }

    protected final void registerPropertyNameArgument(SubCommand subCommand) throws ArgumentException {
        this.propertyArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_PROPERTY).shortIdentifier(OPTION_DSCFG_SHORT_PROPERTY)).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_PROP.get())).multiValued()).valuePlaceholder(DsconfigMessages.INFO_PROPERTY_PLACEHOLDER.get())).buildAndAddToSubCommand(subCommand);
    }

    protected final void registerRecordModeArgument(SubCommand subCommand) throws ArgumentException {
        this.recordModeArgument = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)OPTION_DSCFG_LONG_RECORD).shortIdentifier(Character.valueOf('E'))).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_RECORD.get())).buildAndAddToSubCommand(subCommand);
    }

    protected final void registerUnitSizeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitSizeArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_UNIT_SIZE).shortIdentifier(Character.valueOf('z'))).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_UNIT_SIZE.get())).valuePlaceholder(DsconfigMessages.INFO_UNIT_PLACEHOLDER.get())).buildAndAddToSubCommand(subCommand);
    }

    protected final void registerUnitTimeArgument(SubCommand subCommand) throws ArgumentException {
        this.unitTimeArgument = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_DSCFG_LONG_UNIT_TIME).shortIdentifier(Character.valueOf('m'))).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_UNIT_TIME.get())).valuePlaceholder(DsconfigMessages.INFO_UNIT_PLACEHOLDER.get())).buildAndAddToSubCommand(subCommand);
    }

    protected final void updateCommandBuilderWithSubCommand() {
        for (Argument arg : this.getSubCommand().getArguments()) {
            if (!arg.isPresent()) continue;
            this.getCommandBuilder().addArgument(arg);
        }
    }

    static <T> String castAndGetArgumentValue(PropertyDefinition<T> propertyDefinition, Object o) {
        return propertyDefinition.encodeValue(propertyDefinition.castValue(o));
    }

    static <T> String getArgumentValue(PropertyDefinition<T> propertyDefinition, T o) {
        return propertyDefinition.encodeValue(o);
    }

    static <C extends ConfigurationClient, S extends Configuration> SortedMap<String, ManagedObjectDefinition<? extends C, ? extends S>> getSubTypes(AbstractManagedObjectDefinition<C, S> d) {
        TreeMap<String, ManagedObjectDefinition<C, S>> map = new TreeMap<String, ManagedObjectDefinition<C, S>>();
        if (!d.hasOption(ManagedObjectOption.HIDDEN) && d instanceof ManagedObjectDefinition) {
            ManagedObjectDefinition mod = (ManagedObjectDefinition)d;
            map.put(SubCommandHandler.getShortTypeName(d, mod), mod);
        }
        for (AbstractManagedObjectDefinition<C, S> c : d.getAllChildren()) {
            if (c.hasOption(ManagedObjectOption.HIDDEN) || !(c instanceof ManagedObjectDefinition)) continue;
            ManagedObjectDefinition mod = (ManagedObjectDefinition)c;
            map.put(SubCommandHandler.getShortTypeName(d, mod), mod);
        }
        return map;
    }

    private static <C extends ConfigurationClient, S extends Configuration> String getShortTypeName(AbstractManagedObjectDefinition<C, S> d, AbstractManagedObjectDefinition<?, ?> c) {
        if (c == d) {
            if (CLIProfile.getInstance().isForCustomization(c)) {
                return "custom";
            }
            return "generic";
        }
        String suffix = "-" + d.getName();
        String name = c.getName();
        if (name.endsWith(suffix)) {
            name = name.substring(0, name.length() - suffix.length());
        }
        if (CLIProfile.getInstance().isForCustomization(c)) {
            name = String.format("%s-%s", "custom", name);
        }
        return name;
    }

    static String getSubTypesUsage(AbstractManagedObjectDefinition<?, ?> d) {
        SortedMap<String, ManagedObjectDefinition<?, ?>> types = SubCommandHandler.getSubTypes(d);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String s : types.keySet()) {
            if (!isFirst) {
                builder.append(" | ");
            }
            builder.append(s);
            isFirst = false;
        }
        return builder.toString();
    }

    private static final class NamingArgumentBuilder
    implements ManagedObjectPathSerializer {
        private final List<StringArgument> arguments = new LinkedList<StringArgument>();
        private ArgumentException e;
        private final boolean isCreate;
        private final SubCommand subCommand;
        private int sz;

        private static List<StringArgument> create(SubCommand subCommand, ManagedObjectPath<?, ?> path, boolean isCreate) throws ArgumentException {
            NamingArgumentBuilder builder = new NamingArgumentBuilder(subCommand, path.size(), isCreate);
            path.serialize(builder);
            if (builder.e != null) {
                throw builder.e;
            }
            return builder.arguments;
        }

        private NamingArgumentBuilder(SubCommand subCommand, int sz, boolean isCreate) {
            this.subCommand = subCommand;
            this.sz = sz;
            this.isCreate = isCreate;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            --this.sz;
            String argName = CLIProfile.getInstance().getNamingArgument(r);
            try {
                StringArgument.Builder argBuilder = StringArgument.builder((String)argName);
                if (this.isCreate && this.sz == 0) {
                    PropertyDefinition<?> pd = r.getNamingPropertyDefinition();
                    if (pd != null) {
                        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(false);
                        LocalizableMessage usage = LocalizableMessage.raw((CharSequence)("{" + b.getUsage(pd) + "}"), (Object[])new Object[0]);
                        ((StringArgument.Builder)argBuilder.description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE_EXT.get((Object)d.getUserFriendlyName(), (Object)pd.getName(), (Object)pd.getSynopsis()))).valuePlaceholder(usage);
                    } else {
                        ((StringArgument.Builder)argBuilder.description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME_CREATE.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get());
                    }
                } else {
                    ((StringArgument.Builder)((StringArgument.Builder)argBuilder.description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildArgument();
                }
                StringArgument arg = (StringArgument)argBuilder.buildAndAddToSubCommand(this.subCommand);
                this.arguments.add(arg);
            }
            catch (ArgumentException e) {
                this.e = e;
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
            if (this.isCreate && this.sz == 0) {
                return;
            }
            String argName = CLIProfile.getInstance().getNamingArgument(r);
            try {
                this.arguments.add((StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)argName).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_NAME.get((Object)d.getUserFriendlyName()))).valuePlaceholder(DsconfigMessages.INFO_NAME_PLACEHOLDER.get())).buildAndAddToSubCommand(this.subCommand));
            }
            catch (ArgumentException e) {
                this.e = e;
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            --this.sz;
        }
    }

    private class ManagedObjectFinder
    implements ManagedObjectPathSerializer {
        private ConsoleApplication app;
        private int argIndex;
        private List<String> args;
        private AuthorizationException authze;
        private LdapException ere;
        private ClientException clie;
        private ConcurrentModificationException cme;
        private DefinitionDecodingException dde;
        private ManagedObjectDecodingException mode;
        private ManagedObjectNotFoundException monfe;
        private MenuResult<ManagedObject<?>> result;

        private ManagedObjectFinder() {
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(InstantiableRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d, String name) {
            if (this.result.isSuccess()) {
                String childName = this.args.get(this.argIndex++);
                try {
                    if (childName == null) {
                        try {
                            MenuResult<String> sresult = SubCommandHandler.this.readChildName(this.app, (ManagedObject)this.result.getValue(), r, d);
                            if (sresult.isCancel()) {
                                this.result = MenuResult.cancel();
                                return;
                            }
                            if (sresult.isQuit()) {
                                this.result = MenuResult.quit();
                                return;
                            }
                            childName = (String)sresult.getValue();
                        }
                        catch (ClientException e) {
                            this.clie = e;
                            this.result = MenuResult.quit();
                            return;
                        }
                    } else if (childName.trim().length() == 0) {
                        IllegalManagedObjectNameException e = new IllegalManagedObjectNameException(childName);
                        this.clie = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                        this.result = MenuResult.quit();
                        return;
                    }
                    ManagedObject<C> child = ((ManagedObject)this.result.getValue()).getChild(r, childName);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (LdapException e) {
                    this.ere = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(OptionalRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (this.result.isSuccess()) {
                try {
                    ManagedObject<C> child = ((ManagedObject)this.result.getValue()).getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (LdapException e) {
                    this.ere = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SetRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (this.result.isSuccess()) {
                String childName = this.args.get(this.argIndex++);
                try {
                    if (childName == null) {
                        try {
                            MenuResult<String> sresult = SubCommandHandler.this.readChildName(this.app, (ManagedObject)this.result.getValue(), r, d);
                            if (sresult.isCancel()) {
                                this.result = MenuResult.cancel();
                                return;
                            }
                            if (sresult.isQuit()) {
                                this.result = MenuResult.quit();
                                return;
                            }
                            childName = (String)sresult.getValue();
                        }
                        catch (ClientException e) {
                            this.clie = e;
                            this.result = MenuResult.quit();
                            return;
                        }
                    } else {
                        if (childName.trim().length() == 0) {
                            IllegalManagedObjectNameException e = new IllegalManagedObjectNameException(childName);
                            this.clie = ArgumentExceptionFactory.adaptIllegalManagedObjectNameException(e, d);
                            this.result = MenuResult.quit();
                            return;
                        }
                        String name = childName.trim();
                        SortedMap<String, ManagedObjectDefinition<C, S>> types = SubCommandHandler.getSubTypes(d);
                        ManagedObjectDefinition cd = (ManagedObjectDefinition)types.get(name);
                        if (cd == null) {
                            String typeUsage = SubCommandHandler.getSubTypesUsage(d);
                            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED.get((Object)name, (Object)r.getUserFriendlyName(), (Object)typeUsage);
                            this.clie = new ClientException(ReturnCode.APPLICATION_ERROR, msg);
                            this.result = MenuResult.quit();
                            return;
                        }
                        childName = cd.getName();
                    }
                    ManagedObject<C> child = ((ManagedObject)this.result.getValue()).getChild(r, childName);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (LdapException e) {
                    this.ere = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> void appendManagedObjectPathElement(SingletonRelationDefinition<? super C, ? super S> r, AbstractManagedObjectDefinition<C, S> d) {
            if (this.result.isSuccess()) {
                try {
                    ManagedObject<C> child = ((ManagedObject)this.result.getValue()).getChild(r);
                    if (!child.getManagedObjectDefinition().isChildOf(d)) {
                        this.clie = ArgumentExceptionFactory.wrongManagedObjectType(r, child.getManagedObjectDefinition(), SubCommandHandler.this.getSubCommand().getName());
                        this.result = MenuResult.quit();
                    } else {
                        this.result = MenuResult.success(child);
                    }
                }
                catch (DefinitionDecodingException e) {
                    this.dde = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectDecodingException e) {
                    this.mode = e;
                    this.result = MenuResult.quit();
                }
                catch (AuthorizationException e) {
                    this.authze = e;
                    this.result = MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.monfe = e;
                    this.result = MenuResult.quit();
                }
                catch (ConcurrentModificationException e) {
                    this.cme = e;
                    this.result = MenuResult.quit();
                }
                catch (LdapException e) {
                    this.ere = e;
                    this.result = MenuResult.quit();
                }
            }
        }

        public MenuResult<ManagedObject<?>> find(ConsoleApplication app, ManagementContext context, ManagedObjectPath<?, ?> path, List<String> args) throws ClientException, AuthorizationException, ConcurrentModificationException, DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, LdapException {
            this.result = MenuResult.success(context.getRootConfigurationManagedObject());
            this.app = app;
            this.args = args;
            this.argIndex = 0;
            this.clie = null;
            this.authze = null;
            this.cme = null;
            this.dde = null;
            this.mode = null;
            this.monfe = null;
            this.ere = null;
            path.serialize(this);
            if (this.result.isSuccess()) {
                return this.result;
            }
            if (this.clie != null) {
                throw this.clie;
            }
            if (this.authze != null) {
                throw this.authze;
            }
            if (this.cme != null) {
                throw this.cme;
            }
            if (this.dde != null) {
                throw this.dde;
            }
            if (this.mode != null) {
                throw this.mode;
            }
            if (this.monfe != null) {
                throw this.monfe;
            }
            if (this.ere != null) {
                throw this.ere;
            }
            return this.result;
        }
    }
}

