/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.CommandBuilder;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.Closeable;
import javax.net.ssl.SSLException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.LDAPProfile;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.ldap.LDAPManagementContext;
import org.forgerock.opendj.config.dsconfig.BuildVersion;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Utils;

public final class LDAPManagementContextFactory {
    private ManagementContext context;
    private final CommandBuilder contextCommandBuilder;
    private final ConnectionFactoryProvider provider;
    private final ConnectionFactory factory;

    public LDAPManagementContextFactory(ConnectionFactoryProvider cfp) throws ArgumentException {
        this.provider = cfp;
        this.factory = cfp.getAuthenticatedConnectionFactory();
        this.contextCommandBuilder = null;
    }

    public void close() {
        Utils.closeSilently((Closeable[])new Closeable[]{this.context});
    }

    public CommandBuilder getContextCommandBuilder() {
        return this.contextCommandBuilder;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagementContext getManagementContext() throws ArgumentException, ClientException {
        if (this.context == null) {
            Connection connection;
            String hostName = this.provider.getHostname();
            int port = this.provider.getPort();
            try {
                connection = this.factory.getConnection();
                BuildVersion.checkVersionMismatch(connection);
            }
            catch (LdapException e) {
                try {
                    LocalizableMessage msg = e.getCause() instanceof SSLException ? DsconfigMessages.ERR_FAILED_TO_CONNECT_NOT_TRUSTED.get((Object)hostName, (Object)port) : DsconfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get((Object)hostName, (Object)port);
                    throw new ClientException(ReturnCode.CLIENT_SIDE_CONNECT_ERROR, msg);
                    catch (ConfigException e2) {
                        throw new ClientException(ReturnCode.ERROR_USER_DATA, e2.getMessageObject());
                    }
                    catch (Exception ex) {
                        throw new ClientException(ReturnCode.CLIENT_SIDE_CONNECT_ERROR, DsconfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get((Object)hostName, (Object)port));
                    }
                }
                catch (Throwable throwable) {
                    Utils.closeSilently((Closeable[])new Closeable[]{this.factory});
                    throw throwable;
                }
            }
            Utils.closeSilently((Closeable[])new Closeable[]{this.factory});
            this.context = LDAPManagementContext.newManagementContext(connection, LDAPProfile.getInstance());
        }
        return this.context;
    }
}

