/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.util.Reject;

public abstract class PropertyDefinition<T>
implements Comparator<T>,
Comparable<PropertyDefinition<?>> {
    private final AdministratorAction adminAction;
    private final DefaultBehaviorProvider<T> defaultBehavior;
    private final AbstractManagedObjectDefinition<?, ?> definition;
    private final Set<PropertyOption> options;
    private final String propertyName;
    private final Class<T> theClass;

    protected PropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, Class<T> theClass, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<T> defaultBehavior) {
        Reject.ifNull((Object[])new Object[]{d, theClass, propertyName, options, adminAction, defaultBehavior});
        this.definition = d;
        this.theClass = theClass;
        this.propertyName = propertyName;
        this.options = EnumSet.copyOf(options);
        this.adminAction = adminAction;
        this.defaultBehavior = defaultBehavior;
    }

    public abstract <R, P> R accept(PropertyDefinitionVisitor<R, P> var1, P var2);

    public abstract <R, P> R accept(PropertyValueVisitor<R, P> var1, T var2, P var3);

    public final T castValue(Object object) {
        return this.theClass.cast(object);
    }

    @Override
    public int compare(T o1, T o2) {
        Reject.ifNull(o1);
        Reject.ifNull(o2);
        String s1 = this.normalizeValue(o1);
        String s2 = this.normalizeValue(o2);
        return s1.compareTo(s2);
    }

    @Override
    public final int compareTo(PropertyDefinition<?> o) {
        int rc = this.propertyName.compareTo(o.propertyName);
        if (rc == 0) {
            rc = this.theClass.getName().compareTo(o.theClass.getName());
        }
        return rc;
    }

    public abstract T decodeValue(String var1);

    public String encodeValue(T value) {
        Reject.ifNull(value);
        return value.toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PropertyDefinition) {
            PropertyDefinition other = (PropertyDefinition)o;
            return this.propertyName.equals(other.propertyName) && this.theClass.equals(other.theClass);
        }
        return false;
    }

    public final AdministratorAction getAdministratorAction() {
        return this.adminAction;
    }

    public final DefaultBehaviorProvider<T> getDefaultBehaviorProvider() {
        return this.defaultBehavior;
    }

    public final LocalizableMessage getDescription() {
        return this.getDescription(Locale.getDefault());
    }

    public final LocalizableMessage getDescription(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".description";
        try {
            return resource.getMessage(this.definition, property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final AbstractManagedObjectDefinition<?, ?> getManagedObjectDefinition() {
        return this.definition;
    }

    public final String getName() {
        return this.propertyName;
    }

    public final LocalizableMessage getSynopsis() {
        return this.getSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.propertyName + ".synopsis";
        return resource.getMessage(this.definition, property, locale);
    }

    public final int hashCode() {
        int rc = 17 + this.propertyName.hashCode();
        return 37 * rc + this.theClass.hashCode();
    }

    public final boolean hasOption(PropertyOption option) {
        return this.options.contains((Object)option);
    }

    public String normalizeValue(T value) {
        Reject.ifNull(value);
        return this.encodeValue(value);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        builder.append(this.propertyName);
    }

    public abstract void validateValue(T var1);

    protected void initialize() throws Exception {
    }

    protected static abstract class AbstractBuilder<T, D extends PropertyDefinition<T>> {
        private AdministratorAction adminAction;
        private DefaultBehaviorProvider<T> defaultBehavior;
        private final AbstractManagedObjectDefinition<?, ?> definition;
        private final EnumSet<PropertyOption> options;
        private final String propertyName;

        protected AbstractBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            this.definition = d;
            this.propertyName = propertyName;
            this.options = EnumSet.noneOf(PropertyOption.class);
            this.adminAction = new AdministratorAction(AdministratorAction.Type.NONE, d, propertyName);
            this.defaultBehavior = new UndefinedDefaultBehaviorProvider();
        }

        public final D getInstance() {
            return this.buildInstance(this.definition, this.propertyName, this.options, this.adminAction, this.defaultBehavior);
        }

        public final void setAdministratorAction(AdministratorAction adminAction) {
            Reject.ifNull((Object)adminAction);
            this.adminAction = adminAction;
        }

        public final void setDefaultBehaviorProvider(DefaultBehaviorProvider<T> defaultBehavior) {
            Reject.ifNull(defaultBehavior);
            this.defaultBehavior = defaultBehavior;
        }

        public final void setOption(PropertyOption option) {
            Reject.ifNull((Object)((Object)option));
            this.options.add(option);
        }

        protected abstract D buildInstance(AbstractManagedObjectDefinition<?, ?> var1, String var2, EnumSet<PropertyOption> var3, AdministratorAction var4, DefaultBehaviorProvider<T> var5);
    }
}

